/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.serenegiant.egl.EGLBase;
import com.serenegiant.gl.EffectDrawer2D;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.glutils.AbstractRendererHolder;
import com.serenegiant.glutils.IEffectRendererHolder;
import com.serenegiant.glutils.IRendererHolder;

public class EffectRendererHolder
extends AbstractRendererHolder
implements IEffectRendererHolder {
    private static final boolean DEBUG = false;
    private static final String TAG = EffectRendererHolder.class.getSimpleName();
    private static final int REQUEST_CHANGE_EFFECT = 100;
    private static final int REQUEST_SET_PARAMS = 101;

    public EffectRendererHolder(int width, int height, @Nullable IRendererHolder.RenderHolderCallback callback) {
        this(width, height, 3, null, 2, callback);
    }

    public EffectRendererHolder(int width, int height, int maxClientVersion, @Nullable EGLBase.IContext<?> sharedContext, int flags, @Nullable IRendererHolder.RenderHolderCallback callback) {
        super(width, height, maxClientVersion, sharedContext, flags, callback);
    }

    @Override
    @NonNull
    protected AbstractRendererHolder.BaseRendererTask createRendererTask(int width, int height, int maxClientVersion, @Nullable EGLBase.IContext<?> sharedContext, int flags) {
        return new MyRendererTask(this, width, height, maxClientVersion, sharedContext, flags);
    }

    @Override
    public void changeEffect(int effect) {
        ((MyRendererTask)this.mRendererTask).changeEffect(effect);
    }

    @Override
    public int getCurrentEffect() {
        GLDrawer2D drawer = this.mRendererTask.getDrawer();
        return drawer instanceof EffectDrawer2D ? ((EffectDrawer2D)drawer).getCurrentEffect() : 0;
    }

    @Override
    public void setParams(@NonNull float[] params) {
        ((MyRendererTask)this.mRendererTask).setParams(-1, params);
    }

    @Override
    public void setParams(int effect, @NonNull float[] params) throws IllegalArgumentException {
        if (effect <= 0) {
            throw new IllegalArgumentException("invalid effect number:" + effect);
        }
        ((MyRendererTask)this.mRendererTask).setParams(effect, params);
    }

    protected void handleDefaultEffect(int effect, @NonNull GLDrawer2D drawer) {
        drawer.resetShader();
    }

    protected static final class MyRendererTask
    extends AbstractRendererHolder.BaseRendererTask {
        public MyRendererTask(@NonNull AbstractRendererHolder parent, int width, int height, int maxClientVersion, @Nullable EGLBase.IContext<?> sharedContext, int flags) {
            super(parent, width, height, maxClientVersion, sharedContext, flags, new GLDrawer2D.DrawerFactory(){

                @Override
                @NonNull
                public GLDrawer2D create(boolean isGLES3, boolean isOES) {
                    return new EffectDrawer2D(isGLES3, isOES);
                }
            });
        }

        public void changeEffect(int effect) {
            this.checkFinished();
            this.offer(100, effect);
        }

        public void setParams(int effect, @NonNull float[] params) {
            this.checkFinished();
            this.offer(101, effect, 0, params);
        }

        @Override
        @WorkerThread
        protected Object handleRequest(int request, int arg1, int arg2, Object obj) {
            Object result = null;
            switch (request) {
                case 100: {
                    this.handleChangeEffect(arg1);
                    break;
                }
                case 101: {
                    this.handleSetParam(arg1, (float[])obj);
                    break;
                }
                default: {
                    result = super.handleRequest(request, arg1, arg2, obj);
                }
            }
            return result;
        }

        @WorkerThread
        private void handleChangeEffect(int effect) {
            GLDrawer2D drawer = this.getDrawer();
            if (drawer instanceof EffectDrawer2D) {
                ((EffectDrawer2D)drawer).setEffect(effect);
            }
        }

        @WorkerThread
        private void handleSetParam(int effect, @NonNull float[] params) {
            GLDrawer2D drawer = this.getDrawer();
            if (drawer instanceof EffectDrawer2D) {
                ((EffectDrawer2D)drawer).setParams(effect, params);
            }
        }
    }
}

