/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glpipeline;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLManager;
import com.serenegiant.gl.GLSurface;
import com.serenegiant.gl.GLTexture;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.gl.RendererTarget;
import com.serenegiant.glpipeline.GLSurfacePipeline;
import com.serenegiant.glpipeline.ProxyPipeline;
import com.serenegiant.math.Fraction;

public class MaskPipeline
extends ProxyPipeline
implements GLSurfacePipeline {
    private static final boolean DEBUG = true;
    private static final String TAG = MaskPipeline.class.getSimpleName();
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final GLManager mManager;
    @Nullable
    private GLDrawer2D mDrawer;
    @Nullable
    private RendererTarget mRendererTarget;
    private volatile boolean mMaskOnly;
    @Nullable
    private GLSurface work;
    @Nullable
    private Bitmap mMaskBitmap;
    @Nullable
    private GLTexture mMaskTexture;
    private volatile boolean mRequestUpdateMask;
    private int cnt;
    private static final String FRAGMENT_SHADER_BASE_ES2 = "#version 100\n%sprecision highp float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nuniform %s sTexture2;\nvoid main() {\n    highp vec4 tex1 = texture2D(sTexture, vTextureCoord);\n    highp vec4 tex2 = texture2D(sTexture2, vTextureCoord);\n    gl_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a), tex1.a);\n}\n";
    private static final String MY_FRAGMENT_SHADER_ES2 = String.format("#version 100\n%sprecision highp float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nuniform %s sTexture2;\nvoid main() {\n    highp vec4 tex1 = texture2D(sTexture, vTextureCoord);\n    highp vec4 tex2 = texture2D(sTexture2, vTextureCoord);\n    gl_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a), tex1.a);\n}\n", "", "sampler2D", "sampler2D");
    private static final String MY_FRAGMENT_SHADER_EXT_ES2 = String.format("#version 100\n%sprecision highp float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nuniform %s sTexture2;\nvoid main() {\n    highp vec4 tex1 = texture2D(sTexture, vTextureCoord);\n    highp vec4 tex2 = texture2D(sTexture2, vTextureCoord);\n    gl_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a), tex1.a);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES", "sampler2D");
    private static final String FRAGMENT_SHADER_BASE_ES3 = "#version 300 es\n%sprecision highp float;\nin vec2 vTextureCoord;\nuniform %s sTexture;\nuniform %s sTexture2;\nlayout(location = 0) out vec4 o_FragColor;\nvoid main() {\n    highp vec4 tex1 = texture(sTexture, vTextureCoord);\n    highp vec4 tex2 = texture(sTexture2, vTextureCoord);\n    o_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a), tex1.a);\n}\n";
    private static final String MY_FRAGMENT_SHADER_ES3 = String.format("#version 300 es\n%sprecision highp float;\nin vec2 vTextureCoord;\nuniform %s sTexture;\nuniform %s sTexture2;\nlayout(location = 0) out vec4 o_FragColor;\nvoid main() {\n    highp vec4 tex1 = texture(sTexture, vTextureCoord);\n    highp vec4 tex2 = texture(sTexture2, vTextureCoord);\n    o_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a), tex1.a);\n}\n", "", "sampler2D", "sampler2D");
    private static final String MY_FRAGMENT_SHADER_EXT_ES3 = String.format("#version 300 es\n%sprecision highp float;\nin vec2 vTextureCoord;\nuniform %s sTexture;\nuniform %s sTexture2;\nlayout(location = 0) out vec4 o_FragColor;\nvoid main() {\n    highp vec4 tex1 = texture(sTexture, vTextureCoord);\n    highp vec4 tex2 = texture(sTexture2, vTextureCoord);\n    o_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a), tex1.a);\n}\n", "#extension GL_OES_EGL_image_external_essl3 : require\n", "samplerExternalOES", "sampler2D");

    public MaskPipeline(@NonNull GLManager manager) throws IllegalStateException, IllegalArgumentException {
        this(manager, null, null);
    }

    public MaskPipeline(final @NonNull GLManager manager, final @Nullable Object surface, final @Nullable Fraction maxFps) throws IllegalStateException, IllegalArgumentException {
        Log.v((String)TAG, (String)"\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf:");
        if (surface != null && !GLUtils.isSupportedSurface(surface)) {
            throw new IllegalArgumentException("Unsupported surface type!," + surface);
        }
        this.mManager = manager;
        manager.runOnGLThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                boolean isGLES3 = manager.isGLES3();
                MaskPipeline.this.createTargetOnGL(surface, maxFps);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalRelease() {
        Log.v((String)TAG, (String)"internalRelease:");
        if (this.isValid()) {
            Object object = this.mSync;
            synchronized (object) {
                this.mMaskBitmap = null;
            }
            this.releaseAll();
        }
        super.internalRelease();
    }

    @Override
    public void setSurface(@Nullable Object surface) throws IllegalStateException, IllegalArgumentException {
        this.setSurface(surface, null);
    }

    @Override
    public void setSurface(final @Nullable Object surface, final @Nullable Fraction maxFps) throws IllegalStateException, IllegalArgumentException {
        Log.v((String)TAG, (String)("setSurface:" + surface));
        if (!this.isValid()) {
            throw new IllegalStateException("already released?");
        }
        if (surface != null && !GLUtils.isSupportedSurface(surface)) {
            throw new IllegalArgumentException("Unsupported surface type!," + surface);
        }
        this.mManager.runOnGLThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                MaskPipeline.this.createTargetOnGL(surface, maxFps);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSurface() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mRendererTarget != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getId() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mRendererTarget != null ? this.mRendererTarget.getId() : 0;
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.mManager.isValid();
    }

    public boolean isMaskOnly() {
        return this.mMaskOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void onFrameAvailable(boolean isOES, int texId, @NonNull @Size(min=16L) float[] texMatrix) {
        Bitmap bitmap;
        RendererTarget target;
        if (this.mDrawer == null || isOES != this.mDrawer.isOES()) {
            this.releaseDrawerOnGL();
            Log.v((String)TAG, (String)"onFrameAvailable:create GLDrawer2D");
            this.mDrawer = MaskPipeline.createDrawerOnGL(this.mManager.isGLES3(), isOES);
        }
        GLDrawer2D drawer = this.mDrawer;
        Object object = this.mSync;
        synchronized (object) {
            target = this.mRendererTarget;
            bitmap = this.mMaskBitmap;
        }
        if (this.mRequestUpdateMask) {
            this.mRequestUpdateMask = false;
            if (bitmap != null) {
                this.createMaskTextureOnGL(bitmap);
            } else {
                this.releaseMaskOnGL();
            }
        }
        if (target != null && target.canDraw()) {
            if (this.mMaskTexture != null) {
                this.mMaskTexture.bindTexture();
            }
            target.draw(drawer, 33984, texId, texMatrix);
        }
        if (this.mMaskOnly && this.work != null) {
            if (++this.cnt % 100 == 0) {
                Log.v((String)TAG, (String)("onFrameAvailable:effectOnly," + this.cnt));
            }
            super.onFrameAvailable(this.work.isOES(), this.work.getTexId(), this.work.getTexMatrix());
        } else {
            if (++this.cnt % 100 == 0) {
                Log.v((String)TAG, (String)("onFrameAvailable:" + this.cnt));
            }
            super.onFrameAvailable(isOES, texId, texMatrix);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        Log.v((String)TAG, (String)"refresh:");
        if (this.isValid()) {
            this.mManager.runOnGLThread(new Runnable(){

                @Override
                @WorkerThread
                public void run() {
                    Log.v((String)TAG, (String)"refresh#run:release drawer");
                    MaskPipeline.this.releaseDrawerOnGL();
                }
            });
        }
    }

    @Override
    @CallSuper
    public void resize(int width, int height) throws IllegalStateException {
        super.resize(width, height);
        Log.v((String)TAG, (String)String.format("resize:(%dx%d)", width, height));
        this.mManager.runOnGLThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                Log.v((String)TAG, (String)"resize#run:");
                MaskPipeline.this.releaseMaskOnGL();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMask(@Nullable Bitmap bitmap) {
        Log.v((String)TAG, (String)"setMask:");
        Object object = this.mSync;
        synchronized (object) {
            this.mMaskBitmap = bitmap;
            this.mRequestUpdateMask = true;
        }
    }

    private void releaseAll() {
        Log.v((String)TAG, (String)"releaseAll:");
        if (this.mManager.isValid()) {
            try {
                this.mManager.runOnGLThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    @WorkerThread
                    public void run() {
                        Log.v((String)TAG, (String)"releaseAll#run:");
                        Object object = MaskPipeline.this.mSync;
                        synchronized (object) {
                            if (MaskPipeline.this.mRendererTarget != null) {
                                Log.v((String)TAG, (String)"releaseAll:release target");
                                MaskPipeline.this.mRendererTarget.release();
                                MaskPipeline.this.mRendererTarget = null;
                            }
                            if (MaskPipeline.this.work != null) {
                                Log.v((String)TAG, (String)"releaseAll:release work");
                                MaskPipeline.this.work.release();
                                MaskPipeline.this.work = null;
                            }
                        }
                        MaskPipeline.this.releaseDrawerOnGL();
                    }
                });
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        } else {
            Log.w((String)TAG, (String)"releaseAll:unexpectedly GLManager is already released!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void createTargetOnGL(@Nullable Object surface, @Nullable Fraction maxFps) {
        Log.v((String)TAG, (String)("createTarget:" + surface));
        Object object = this.mSync;
        synchronized (object) {
            if (this.mRendererTarget == null || this.mRendererTarget.getSurface() != surface) {
                if (this.mRendererTarget != null) {
                    this.mRendererTarget.release();
                    this.mRendererTarget = null;
                }
                if (this.work != null) {
                    this.work.release();
                    this.work = null;
                }
                if (GLUtils.isSupportedSurface(surface)) {
                    this.mRendererTarget = RendererTarget.newInstance(this.mManager.getEgl(), surface, maxFps != null ? maxFps.asFloat() : 0.0f);
                    this.mMaskOnly = false;
                } else if (this.isValid()) {
                    Log.v((String)TAG, (String)"createTarget:create GLSurface as work texture");
                    this.work = GLSurface.newInstance(this.mManager.isGLES3(), this.getWidth(), this.getHeight());
                    this.mRendererTarget = RendererTarget.newInstance(this.mManager.getEgl(), this.work, maxFps != null ? maxFps.asFloat() : 0.0f);
                    this.mMaskOnly = true;
                }
                if (this.mRendererTarget != null) {
                    this.mRendererTarget.setMirror(2);
                }
            }
        }
    }

    @WorkerThread
    private static GLDrawer2D createDrawerOnGL(boolean isGLES3, boolean isOES) {
        Log.v((String)TAG, (String)("createDrawerOnGL:isGLES3=" + isGLES3 + ",isOES=" + isOES));
        return GLDrawer2D.create(isGLES3, isOES, isOES ? (isGLES3 ? MY_FRAGMENT_SHADER_EXT_ES3 : MY_FRAGMENT_SHADER_EXT_ES2) : (isGLES3 ? MY_FRAGMENT_SHADER_ES3 : MY_FRAGMENT_SHADER_ES2));
    }

    @WorkerThread
    private void releaseDrawerOnGL() {
        Log.v((String)TAG, (String)"releaseDrawerOnGL:");
        if (this.mDrawer != null) {
            this.mDrawer.release();
            this.mDrawer = null;
        }
        this.releaseMaskOnGL();
    }

    @WorkerThread
    private void createMaskTextureOnGL(@NonNull Bitmap bitmap) {
        Log.v((String)TAG, (String)"createMaskTextureOnGL:");
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        if (this.mMaskTexture == null || this.mMaskTexture.getWidth() != width || this.mMaskTexture.getHeight() != height) {
            this.releaseMaskOnGL();
            this.mMaskTexture = GLTexture.newInstance(33985, width, height);
            this.mMaskTexture.bindTexture();
            int uTex2 = this.mDrawer.glGetUniformLocation("sTexture2");
            GLES20.glUniform1i((int)uTex2, (int)GLUtils.gLTextureUnit2Index(33985));
        }
        Log.v((String)TAG, (String)"createMaskTextureOnGL:loadBitmap");
        this.mMaskTexture.loadBitmap(bitmap);
    }

    @WorkerThread
    private void releaseMaskOnGL() {
        Log.v((String)TAG, (String)"releaseMaskOnGL:");
        if (this.mMaskTexture != null) {
            this.mMaskTexture.release();
            this.mMaskTexture = null;
        }
    }
}

