/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.gl;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.Drawable;
import android.opengl.GLES20;
import android.opengl.GLES30;
import android.opengl.Matrix;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.core.content.res.ResourcesCompat;
import com.serenegiant.gl.GLConst;
import com.serenegiant.gl.GLContext;
import com.serenegiant.gl.ShaderConst;
import com.serenegiant.system.Stacktrace;
import com.serenegiant.utils.AssetsHelper;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GLUtils
implements GLConst {
    private static final boolean DEBUG = false;
    private static final String TAG = GLUtils.class.getSimpleName();
    private static int sSupportedGLVersion = -1;

    private GLUtils() {
    }

    public static boolean isSupportedSurface(@Nullable Object surface) {
        return surface instanceof Surface || surface instanceof SurfaceHolder || surface instanceof SurfaceTexture || surface instanceof SurfaceView;
    }

    public static synchronized int getSupportedGLVersion() {
        if (sSupportedGLVersion < 1) {
            final AtomicInteger result = new AtomicInteger(1);
            final Semaphore sync = new Semaphore(0);
            final GLContext context = new GLContext(3, null, 0);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        context.initialize();
                        String extensions = GLES20.glGetString((int)7939);
                        if (extensions == null || !extensions.contains("GL_OES_EGL_image_external")) {
                            result.set(1);
                        } else if (Build.VERSION.SDK_INT >= 21 && context.isGLES3()) {
                            extensions = GLES30.glGetString((int)7939);
                            result.set(extensions != null && extensions.contains("GL_OES_EGL_image_external_essl3") ? 3 : 2);
                        } else {
                            result.set(2);
                        }
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                    finally {
                        context.release();
                        sync.release();
                    }
                }
            }).start();
            try {
                if (sync.tryAcquire(500L, TimeUnit.MILLISECONDS)) {
                    sSupportedGLVersion = result.get();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return sSupportedGLVersion;
    }

    public static void setMirror(@NonNull @Size(min=16L) float[] mvp, int mirror) {
        switch (mirror) {
            case 0: {
                mvp[0] = Math.abs(mvp[0]);
                mvp[5] = Math.abs(mvp[5]);
                break;
            }
            case 1: {
                mvp[0] = -Math.abs(mvp[0]);
                mvp[5] = Math.abs(mvp[5]);
                break;
            }
            case 2: {
                mvp[0] = Math.abs(mvp[0]);
                mvp[5] = -Math.abs(mvp[5]);
                break;
            }
            case 3: {
                mvp[0] = -Math.abs(mvp[0]);
                mvp[5] = -Math.abs(mvp[5]);
            }
        }
    }

    public static void rotate(@NonNull @Size(min=16L) float[] mvp, int degrees) {
        if (degrees % 180 != 0) {
            Matrix.rotateM((float[])mvp, (int)0, (float)degrees, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    public static void setRotation(@NonNull @Size(min=16L) float[] mvp, int degrees) {
        Matrix.setIdentityM((float[])mvp, (int)0);
        if (degrees % 180 != 0) {
            Matrix.rotateM((float[])mvp, (int)0, (float)degrees, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    public static int gLTextureUnit2Index(int glTextureUnit) {
        return glTextureUnit >= 33984 && glTextureUnit <= 34015 ? glTextureUnit - 33984 : 0;
    }

    public static ByteBuffer glReadPixels(@Nullable ByteBuffer buffer, @IntRange(from=1L) int width, @IntRange(from=1L) int height) {
        int sz = width * height * 4;
        ByteBuffer buf = buffer;
        if (buf == null || buf.capacity() < sz) {
            buf = ByteBuffer.allocateDirect(sz).order(ByteOrder.LITTLE_ENDIAN);
        }
        if (buf.order() != ByteOrder.LITTLE_ENDIAN) {
            buf.order(ByteOrder.LITTLE_ENDIAN);
        }
        buf.clear();
        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)buf);
        buf.position(sz);
        buf.flip();
        return buf;
    }

    public static void checkGlError(String op) {
        int error = GLES20.glGetError();
        if (error != 0) {
            String msg = op + ": glError 0x" + Integer.toHexString(error);
            Log.e((String)TAG, (String)msg);
            Stacktrace.print();
        }
    }

    public static int initTex(int texTarget, int texUnit, int filterParam) {
        return GLUtils.initTex(texTarget, texUnit, filterParam, filterParam, 33071);
    }

    public static int initTex(int texTarget, int texUnit, int minFilter, int magFilter, int wrap) {
        int[] tex = new int[1];
        GLES20.glActiveTexture((int)texUnit);
        GLES20.glGenTextures((int)1, (int[])tex, (int)0);
        GLES20.glBindTexture((int)texTarget, (int)tex[0]);
        GLES20.glTexParameteri((int)texTarget, (int)10242, (int)wrap);
        GLES20.glTexParameteri((int)texTarget, (int)10243, (int)wrap);
        GLES20.glTexParameteri((int)texTarget, (int)10241, (int)minFilter);
        GLES20.glTexParameteri((int)texTarget, (int)10240, (int)magFilter);
        Log.d((String)TAG, (String)("initTex:texId=" + tex[0]));
        return tex[0];
    }

    public static int[] initTexes(int n, int texTarget, int filterParam) {
        return GLUtils.initTexes(new int[n], texTarget, filterParam, filterParam, 33071);
    }

    public static int[] initTexes(@NonNull int[] texIds, int texTarget, int filterParam) {
        return GLUtils.initTexes(texIds, texTarget, filterParam, filterParam, 33071);
    }

    public static int[] initTexes(int n, int texTarget, int minFilter, int magFilter, int wrap) {
        return GLUtils.initTexes(new int[n], texTarget, minFilter, magFilter, wrap);
    }

    public static int[] initTexes(@NonNull int[] texIds, int texTarget, int minFilter, int magFilter, int wrap) {
        int[] textureUnits = new int[1];
        GLES20.glGetIntegerv((int)34930, (int[])textureUnits, (int)0);
        Log.v((String)TAG, (String)("GL_MAX_TEXTURE_IMAGE_UNITS=" + textureUnits[0]));
        int n = Math.min(texIds.length, textureUnits[0]);
        for (int i = 0; i < n; ++i) {
            texIds[i] = GLUtils.initTex(texTarget, ShaderConst.TEX_NUMBERS[i], minFilter, magFilter, wrap);
        }
        return texIds;
    }

    public static int[] initTexes(int n, int texTarget, int texUnit, int minFilter, int magFilter, int wrap) {
        return GLUtils.initTexes(new int[n], texTarget, texUnit, minFilter, magFilter, wrap);
    }

    public static int[] initTexes(@NonNull int[] texIds, int texTarget, int texUnit, int filterParam) {
        return GLUtils.initTexes(texIds, texTarget, texUnit, filterParam, filterParam, 33071);
    }

    public static int[] initTexes(@NonNull int[] texIds, int texTarget, int texUnit, int minFilter, int magFilter, int wrap) {
        int[] textureUnits = new int[1];
        GLES20.glGetIntegerv((int)34930, (int[])textureUnits, (int)0);
        int n = Math.min(texIds.length, textureUnits[0]);
        for (int i = 0; i < n; ++i) {
            texIds[i] = GLUtils.initTex(texTarget, texUnit, minFilter, magFilter, wrap);
        }
        return texIds;
    }

    public static void deleteTex(int hTex) {
        int[] tex = new int[]{hTex};
        GLES20.glDeleteTextures((int)1, (int[])tex, (int)0);
    }

    public static void deleteTex(@NonNull int[] tex) {
        GLES20.glDeleteTextures((int)tex.length, (int[])tex, (int)0);
    }

    public static int loadTextureFromResource(Context context, int resId) {
        return GLUtils.loadTextureFromResource(context, resId, null);
    }

    @SuppressLint(value={"NewApi"})
    public static int loadTextureFromResource(Context context, int resId, Resources.Theme theme) {
        Bitmap bitmap = Bitmap.createBitmap((int)256, (int)256, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawARGB(0, 0, 255, 0);
        Drawable background = ResourcesCompat.getDrawable((Resources)context.getResources(), (int)resId, (Resources.Theme)theme);
        background.setBounds(0, 0, 256, 256);
        background.draw(canvas);
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glBindTexture((int)3553, (int)textures[0]);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GLES20.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        android.opengl.GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        bitmap.recycle();
        return textures[0];
    }

    public static int createTextureWithTextContent(@NonNull String text) {
        return GLUtils.createTextureWithTextContent(text, 33984);
    }

    public static int createTextureWithTextContent(@NonNull String text, int texUnit) {
        Bitmap bitmap = Bitmap.createBitmap((int)256, (int)256, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawARGB(0, 0, 255, 0);
        Paint textPaint = new Paint();
        textPaint.setTextSize(32.0f);
        textPaint.setAntiAlias(true);
        textPaint.setARGB(255, 255, 255, 255);
        canvas.drawText(text, 16.0f, 112.0f, textPaint);
        int texture = GLUtils.initTex(3553, texUnit, 9728, 9729, 10497);
        android.opengl.GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        bitmap.recycle();
        return texture;
    }

    public static int loadShader(@NonNull Context context, String vss_asset, String fss_asset) {
        int program;
        try {
            String vss = AssetsHelper.loadString(context.getAssets(), vss_asset);
            String fss = AssetsHelper.loadString(context.getAssets(), vss_asset);
            program = GLUtils.loadShader(vss, fss);
        }
        catch (IOException e) {
            program = 0;
        }
        return program;
    }

    public static int loadShader(String vss, String fss) {
        int[] compiled = new int[1];
        int vs = GLUtils.loadShader(35633, vss);
        if (vs == 0) {
            Log.d((String)TAG, (String)("loadShader:failed to compile vertex shader,\n" + vss));
            return 0;
        }
        int fs = GLUtils.loadShader(35632, fss);
        if (fs == 0) {
            Log.d((String)TAG, (String)("loadShader:failed to compile fragment shader,\n" + fss));
            return 0;
        }
        int program = GLES20.glCreateProgram();
        GLUtils.checkGlError("glCreateProgram");
        if (program == 0) {
            Log.e((String)TAG, (String)"Could not create program");
        }
        GLES20.glAttachShader((int)program, (int)vs);
        GLUtils.checkGlError("glAttachShader");
        GLES20.glAttachShader((int)program, (int)fs);
        GLUtils.checkGlError("glAttachShader");
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            Log.e((String)TAG, (String)"Could not link program: ");
            Log.e((String)TAG, (String)GLES20.glGetProgramInfoLog((int)program));
            GLES20.glDeleteProgram((int)program);
            return 0;
        }
        return program;
    }

    public static int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        GLUtils.checkGlError("glCreateShader type=" + shaderType);
        GLES20.glShaderSource((int)shader, (String)source);
        GLES20.glCompileShader((int)shader);
        int[] compiled = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            Log.e((String)TAG, (String)("Could not compile shader " + shaderType + ":"));
            Log.e((String)TAG, (String)(" " + GLES20.glGetShaderInfoLog((int)shader)));
            GLES20.glDeleteShader((int)shader);
            shader = 0;
        }
        return shader;
    }

    public static void checkLocation(int location, String label) {
        if (location < 0) {
            throw new RuntimeException("Unable to locate '" + label + "' in program");
        }
    }

    public static int createBuffer(int target, @NonNull FloatBuffer data, int usage) {
        int[] ids = new int[1];
        GLES20.glGenBuffers((int)1, (int[])ids, (int)0);
        GLUtils.checkGlError("glGenBuffers");
        GLES20.glBindBuffer((int)target, (int)ids[0]);
        GLUtils.checkGlError("glBindBuffer");
        GLES20.glBufferData((int)target, (int)(4 * data.limit()), (Buffer)data, (int)usage);
        GLUtils.checkGlError("glBufferData");
        GLES20.glBindBuffer((int)target, (int)0);
        return ids[0];
    }

    public static void deleteBuffer(int bufId) {
        GLUtils.deleteBuffer(new int[]{bufId});
    }

    public static void deleteBuffer(@NonNull int[] bufIds) {
        GLES20.glDeleteBuffers((int)bufIds.length, (int[])bufIds, (int)0);
    }
}

