/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.camera;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.camera.CameraConst;
import com.serenegiant.gl.WrappedSurfaceHolder;
import com.serenegiant.view.ViewUtils;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Iterator;
import java.util.List;

public class CameraUtils
implements CameraConst {
    private static final boolean DEBUG = false;
    private static final String TAG = CameraUtils.class.getSimpleName();

    public static Camera setupCamera(@NonNull Context context, int face, int width, int height) throws IOException {
        int cameraId = CameraUtils.findCamera(0);
        Camera camera = Camera.open((int)cameraId);
        Camera.Parameters params = camera.getParameters();
        if (params != null) {
            List focusModes = params.getSupportedFocusModes();
            if (focusModes.contains("continuous-video")) {
                params.setFocusMode("continuous-video");
            } else if (focusModes.contains("auto")) {
                params.setFocusMode("auto");
            }
            params.setRecordingHint(true);
            CameraUtils.chooseVideoSize(params, width, height);
            int[] fps = CameraUtils.chooseFps(params, 1.0f, 120.0f);
            CameraUtils.setupRotation(context, cameraId, camera, params);
            camera.setParameters(params);
            Camera.Size previewSize = camera.getParameters().getPreviewSize();
            Log.d((String)TAG, (String)String.format("handleStartPreview(%d, %d),fps(%d-%d)", previewSize.width, previewSize.height, fps[0], fps[1]));
        }
        return camera;
    }

    public static final int findCamera(int face) {
        Camera.CameraInfo info = new Camera.CameraInfo();
        int numCameras = Camera.getNumberOfCameras();
        int targetFace = face;
        boolean triedAllCameras = false;
        int result = -1;
        block0: while (!triedAllCameras) {
            for (int i = 0; i < numCameras; ++i) {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                if (info.facing != targetFace) continue;
                result = i;
                break block0;
            }
            if (result >= 0) continue;
            if (targetFace == face) {
                targetFace = face == 0 ? 1 : 0;
                continue;
            }
            triedAllCameras = true;
        }
        return result;
    }

    @NonNull
    public static Camera.Size chooseVideoSize(@NonNull Camera.Parameters params, int width, int height) throws IllegalArgumentException {
        Camera.Size ppsfv = params.getPreferredPreviewSizeForVideo();
        for (Camera.Size size : params.getSupportedPreviewSizes()) {
            if (width > 0 && height > 0 && (size.width != width || size.height != height)) continue;
            Log.d((String)TAG, (String)String.format("match supported preview size:%dx%d", size.width, size.height));
            params.setPreviewSize(size.width, size.height);
            params.setPictureSize(size.width, size.height);
            return size;
        }
        Camera.Size selectedSize = CameraUtils.getClosestSupportedSize(params.getSupportedPreviewSizes(), width, height);
        if (ppsfv != null) {
            Log.d((String)TAG, (String)String.format("use ppsfv: %dx%d", ppsfv.width, ppsfv.height));
            params.setPreviewSize(ppsfv.width, ppsfv.height);
            params.setPictureSize(ppsfv.width, ppsfv.height);
            return ppsfv;
        }
        throw new IllegalArgumentException(String.format("Unable to set preview size to %dx%d)", width, height));
    }

    @Nullable
    public static Camera.Size getClosestSupportedSize(@NonNull List<Camera.Size> supportedSizes, int requestWidth, int requestHeight) {
        double a;
        double r;
        double aspect = (double)requestWidth / (double)requestHeight;
        double selectedDelta = Double.MAX_VALUE;
        Camera.Size selectedSize = null;
        for (Camera.Size size : supportedSizes) {
            if (size.width != requestWidth || !((r = Math.abs((a = (double)size.width / (double)size.height) - aspect) / aspect) < selectedDelta)) continue;
            selectedSize = size;
            selectedDelta = r;
        }
        if (selectedSize == null || selectedDelta < 0.05) {
            selectedDelta = Double.MAX_VALUE;
            selectedSize = null;
            for (Camera.Size size : supportedSizes) {
                if (size.width != requestWidth || !((r = Math.abs((a = (double)size.width / (double)size.height) - aspect) / aspect) < selectedDelta)) continue;
                selectedSize = size;
                selectedDelta = r;
            }
        }
        if (selectedSize != null && selectedDelta < 0.05) {
            Log.w((String)TAG, (String)String.format("Set preview size to (%dx%d) instead of (%d,%d)", selectedSize.width, selectedSize.height, requestWidth, requestHeight));
        }
        return selectedSize;
    }

    @Nullable
    public static int[] chooseFps(@NonNull Camera.Parameters params, float minFps, float maxFps) {
        List fpsRanges = params.getSupportedPreviewFpsRange();
        int[] foundFpsRange = null;
        if (fpsRanges != null && !fpsRanges.isEmpty()) {
            int[] range;
            int x;
            for (x = fpsRanges.size() - 1; x >= 0; --x) {
                range = (int[])fpsRanges.get(x);
                if (!((float)range[0] / 1000.0f >= minFps) || !((float)range[1] / 1000.0f <= maxFps)) continue;
                foundFpsRange = range;
                break;
            }
            if (foundFpsRange == null) {
                for (x = fpsRanges.size() - 1; x >= 0; --x) {
                    range = (int[])fpsRanges.get(x);
                    if (!((float)range[1] / 1000.0f <= maxFps)) continue;
                    foundFpsRange = range;
                    break;
                }
            }
            if (foundFpsRange == null) {
                Log.w((String)TAG, (String)String.format("chooseFps:specific fps range(%f-%f) not found,use fastest one", Float.valueOf(minFps), Float.valueOf(maxFps)));
            }
        }
        if (foundFpsRange != null) {
            params.setPreviewFpsRange((int)foundFpsRange[0], (int)foundFpsRange[1]);
            Camera.Size sz = params.getPreviewSize();
            Log.d((String)TAG, (String)String.format("chooseFps:(%dx%d),fps=%d-%d", sz.width, sz.height, (int)foundFpsRange[0], foundFpsRange[1]));
        }
        return foundFpsRange;
    }

    @SuppressLint(value={"NewApi"})
    public static int setupRotation(int cameraId, @NonNull View view, @NonNull Camera camera, @NonNull Camera.Parameters params) {
        int degrees = ViewUtils.getRotationDegrees(view);
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        if (info.facing == 1) {
            degrees = (info.orientation + degrees) % 360;
            degrees = (360 - degrees) % 360;
        } else {
            degrees = (info.orientation - degrees + 360) % 360;
        }
        camera.setDisplayOrientation(degrees);
        return degrees;
    }

    public static int setupRotation(@NonNull Context context, int cameraId, @NonNull Camera camera, @NonNull Camera.Parameters params) {
        int degrees = ViewUtils.getRotationDegrees(context);
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        if (info.facing == 1) {
            degrees = (info.orientation + degrees) % 360;
            degrees = (360 - degrees) % 360;
        } else {
            degrees = (info.orientation - degrees + 360) % 360;
        }
        camera.setDisplayOrientation(degrees);
        return degrees;
    }

    public static void setPreviewSurface(@NonNull Camera camera, @NonNull Object surface) throws IllegalArgumentException, IOException {
        if (surface instanceof SurfaceTexture) {
            camera.setPreviewTexture((SurfaceTexture)surface);
        } else if (surface instanceof SurfaceHolder) {
            camera.setPreviewDisplay((SurfaceHolder)surface);
        } else if (surface instanceof Surface) {
            camera.setPreviewDisplay((SurfaceHolder)new WrappedSurfaceHolder((Surface)surface));
        } else if (surface instanceof SurfaceView) {
            camera.setPreviewDisplay(((SurfaceView)surface).getHolder());
        } else {
            throw new IllegalArgumentException("Unknown surface type," + surface);
        }
    }

    public static void dumpSupportedPictureFormats(@NonNull Camera.Parameters params) {
        List formats = params.getSupportedPictureFormats();
        Iterator iterator = formats.iterator();
        block21: while (iterator.hasNext()) {
            int format = (Integer)iterator.next();
            switch (format) {
                case 1144402265: {
                    Log.i((String)TAG, (String)"supported: DEPTH16");
                    continue block21;
                }
                case 257: {
                    Log.i((String)TAG, (String)"supported: DEPTH_POINT_CLOUD");
                    continue block21;
                }
                case 42: {
                    Log.i((String)TAG, (String)"supported: FLEX_RGBA_8888");
                    continue block21;
                }
                case 41: {
                    Log.i((String)TAG, (String)"supported: FLEX_RGB_888");
                    continue block21;
                }
                case 256: {
                    Log.i((String)TAG, (String)"supported: JPEG");
                    continue block21;
                }
                case 16: {
                    Log.i((String)TAG, (String)"supported: NV16");
                    continue block21;
                }
                case 17: {
                    Log.i((String)TAG, (String)"supported: NV21");
                    continue block21;
                }
                case 34: {
                    Log.i((String)TAG, (String)"supported: PRIVATE");
                    continue block21;
                }
                case 37: {
                    Log.i((String)TAG, (String)"supported: RAW10");
                    continue block21;
                }
                case 38: {
                    Log.i((String)TAG, (String)"supported: RAW12");
                    continue block21;
                }
                case 36: {
                    Log.i((String)TAG, (String)"supported: RAW_PRIVATE");
                    continue block21;
                }
                case 32: {
                    Log.i((String)TAG, (String)"supported: RAW_SENSOR");
                    continue block21;
                }
                case 4: {
                    Log.i((String)TAG, (String)"supported: RGB_565");
                    continue block21;
                }
                case 0: {
                    Log.i((String)TAG, (String)"supported: UNKNOWN");
                    continue block21;
                }
                case 35: {
                    Log.i((String)TAG, (String)"supported: YUV_420_888");
                    continue block21;
                }
                case 39: {
                    Log.i((String)TAG, (String)"supported: YUV_422_888");
                    continue block21;
                }
                case 40: {
                    Log.i((String)TAG, (String)"supported: YUV_444_888");
                    continue block21;
                }
                case 20: {
                    Log.i((String)TAG, (String)"supported: YUY2");
                    continue block21;
                }
                case 842094169: {
                    Log.i((String)TAG, (String)"supported: YV12");
                    continue block21;
                }
            }
            Log.i((String)TAG, (String)String.format("supported: unknown, %08x", format));
        }
    }

    public static void dumpSupportedPreviewFormats(@NonNull Camera.Parameters params) {
        List formats = params.getSupportedPreviewFormats();
        Iterator iterator = formats.iterator();
        block21: while (iterator.hasNext()) {
            int format = (Integer)iterator.next();
            switch (format) {
                case 1144402265: {
                    Log.i((String)TAG, (String)"supported: DEPTH16");
                    continue block21;
                }
                case 257: {
                    Log.i((String)TAG, (String)"supported: DEPTH_POINT_CLOUD");
                    continue block21;
                }
                case 42: {
                    Log.i((String)TAG, (String)"supported: FLEX_RGBA_8888");
                    continue block21;
                }
                case 41: {
                    Log.i((String)TAG, (String)"supported: FLEX_RGB_888");
                    continue block21;
                }
                case 256: {
                    Log.i((String)TAG, (String)"supported: JPEG");
                    continue block21;
                }
                case 16: {
                    Log.i((String)TAG, (String)"supported: NV16");
                    continue block21;
                }
                case 17: {
                    Log.i((String)TAG, (String)"supported: NV21");
                    continue block21;
                }
                case 34: {
                    Log.i((String)TAG, (String)"supported: PRIVATE");
                    continue block21;
                }
                case 37: {
                    Log.i((String)TAG, (String)"supported: RAW10");
                    continue block21;
                }
                case 38: {
                    Log.i((String)TAG, (String)"supported: RAW12");
                    continue block21;
                }
                case 36: {
                    Log.i((String)TAG, (String)"supported: RAW_PRIVATE");
                    continue block21;
                }
                case 32: {
                    Log.i((String)TAG, (String)"supported: RAW_SENSOR");
                    continue block21;
                }
                case 4: {
                    Log.i((String)TAG, (String)"supported: RGB_565");
                    continue block21;
                }
                case 0: {
                    Log.i((String)TAG, (String)"supported: UNKNOWN");
                    continue block21;
                }
                case 35: {
                    Log.i((String)TAG, (String)"supported: YUV_420_888");
                    continue block21;
                }
                case 39: {
                    Log.i((String)TAG, (String)"supported: YUV_422_888");
                    continue block21;
                }
                case 40: {
                    Log.i((String)TAG, (String)"supported: YUV_444_888");
                    continue block21;
                }
                case 20: {
                    Log.i((String)TAG, (String)"supported: YUY2");
                    continue block21;
                }
                case 842094169: {
                    Log.i((String)TAG, (String)"supported: YV12");
                    continue block21;
                }
            }
            Log.i((String)TAG, (String)String.format("supported: unknown, %08x", format));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @TargetApi(value=24)
    public static @interface PreviewFormat {
    }
}

