/*
 * Decompiled with CFR 0.152.
 */
package androidx.documentfile.provider;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;
import androidx.documentfile.provider.TreeDocumentFile;
import com.serenegiant.system.SAFUtils;

@TargetApi(value=21)
public class SAFTreeDocumentFile
extends TreeDocumentFile {
    @NonNull
    private final Context mContext;
    private final int mRequestCode;

    SAFTreeDocumentFile(@Nullable DocumentFile parent, @NonNull Context context, @NonNull Uri uri, int requestCode) {
        super(parent, context, uri);
        this.mContext = context;
        this.mRequestCode = requestCode;
    }

    public boolean delete() {
        boolean result = super.delete();
        if (result) {
            SAFUtils.releasePersistableUriPermission(this.mContext, this.mRequestCode);
        }
        return result;
    }
}

