/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.ptp;

import android.content.Context;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.usb.NativeLibLoader;
import com.serenegiant.usb.USBMonitor;
import com.serenegiant.usb.UsbDeviceInfo;
import com.serenegiant.usb.UsbUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@Keep
public class PTPController {
    private static final boolean DEBUG = true;
    private static final String TAG = PTPController.class.getSimpleName();
    private static final String DEFAULT_USBFS = "/dev/bus/usb";
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_INITIALIZING = 1;
    public static final int STATE_INITIALIZED = 16;
    public static final int STATE_CONNECTING = 256;
    public static final int STATE_CONNECTED = 512;
    public static final int STATE_STREAMING = 1024;
    public static final int STATE_MASK_CONNECTING = 272;
    public static final int STATE_MASK_CONNECTED = 528;
    public static final int STATE_MASK_STREAM = 1552;
    private final ReentrantReadWriteLock mSensorLock = new ReentrantReadWriteLock();
    private final Lock mReadLock = this.mSensorLock.readLock();
    private final Lock mWriteLock = this.mSensorLock.writeLock();
    private int mState = 0;
    @Keep
    @NonNull
    private final Context mContext;
    @Keep
    private long mNativePtr;
    @Keep
    private int mNativeValue;
    private USBMonitor.UsbControlBlock mCtrlBlock;

    public PTPController(@NonNull Context context) throws IllegalAccessException {
        Log.v((String)TAG, (String)"\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf");
        this.mContext = context;
        this.setState(1);
        this.mNativePtr = this.nativeCreate();
        if (this.mNativePtr == 0L) {
            throw new IllegalAccessException("Failed to create native instance");
        }
        this.setState(16);
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public void release() {
        Log.v((String)TAG, (String)("release:mNativePtr=" + this.mNativePtr));
        if (this.mNativePtr != 0L) {
            this.nativeDestroy(this.mNativePtr);
            this.mNativePtr = 0L;
        }
        this.setState(0);
    }

    public boolean isInitialized() {
        this.mReadLock.lock();
        try {
            boolean bl = (this.mState & 0x10) == 16;
            return bl;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public boolean isConnected() {
        this.mReadLock.lock();
        try {
            boolean bl = (this.mState & 0x210) == 528;
            return bl;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public boolean isStreaming() {
        this.mReadLock.lock();
        try {
            boolean bl = (this.mState & 0x610) == 1552;
            return bl;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public synchronized void open(@NonNull USBMonitor.UsbControlBlock ctrlBlock) throws IOException {
        Log.v((String)TAG, (String)"open:");
        if (!this.isConnected()) {
            int result;
            this.setState(256, -257);
            try {
                this.mCtrlBlock = ctrlBlock.clone();
                result = PTPController.nativeConnect(this.mNativePtr, this.mCtrlBlock.getFileDescriptor());
            }
            catch (Exception e) {
                result = -1;
            }
            if (result != 0) {
                if (this.mCtrlBlock != null) {
                    this.mCtrlBlock.close();
                    this.mCtrlBlock = null;
                }
                this.setState(0, -769);
                throw new IOException("open failed:result=" + result);
            }
            this.setState(512, -769);
        }
    }

    public synchronized void close() {
        Log.v((String)TAG, (String)"close:");
        this.setState(0, -769);
        if (this.mNativePtr != 0L) {
            PTPController.nativeDisconnect(this.mNativePtr);
        }
        if (this.mCtrlBlock != null) {
            this.mCtrlBlock.close();
            this.mCtrlBlock = null;
        }
        Log.v((String)TAG, (String)"close:finished");
    }

    public synchronized boolean startStream() {
        Log.v((String)TAG, (String)("startStream:mNativePtr=" + this.mNativePtr));
        if (this.mNativePtr != 0L) {
            int result = PTPController.nativeStartStream(this.mNativePtr);
            if (result != 0) {
                throw new RuntimeException("startStream: Failed result=" + result);
            }
        } else {
            throw new RuntimeException("startStream: not ready");
        }
        this.setState(1024, -1025);
        return this.isStreaming();
    }

    public synchronized boolean stopStream() {
        Log.v((String)TAG, (String)"stopStream:");
        this.setState(0, -1025);
        if (this.mNativePtr != 0L) {
            PTPController.nativeStopStream(this.mNativePtr);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public synchronized String getDescriptor() {
        Log.v((String)TAG, (String)"getDescriptor:");
        String result = null;
        if (this.mNativePtr != 0L && this.mCtrlBlock != null) {
            File dir = this.mContext.getExternalFilesDir("Descriptors");
            dir.mkdirs();
            if (dir.canWrite()) {
                File filepath = new File(dir, String.format("desc-%04x_%04x_%08x.txt", this.mCtrlBlock.getVenderId(), this.mCtrlBlock.getProductId(), UsbUtils.getDeviceKey((UsbDeviceInfo)this.mCtrlBlock.getInfo())));
                if (!filepath.exists()) {
                    PTPController.nativeOutputDescriptor(this.mNativePtr, this.mCtrlBlock.getVenderId(), this.mCtrlBlock.getProductId(), this.mCtrlBlock.getFileDescriptor(), filepath.getAbsolutePath());
                }
                if (filepath.exists()) {
                    try (BufferedReader in = new BufferedReader(new FileReader(filepath));){
                        StringBuilder sb = new StringBuilder(1024);
                        char[] buffer = new char[512];
                        int n = 0;
                        while (n >= 0 && (n = in.read(buffer)) > 0) {
                            sb.append(buffer, 0, n);
                        }
                        result = sb.toString();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        Log.v((String)TAG, (String)"getDescriptor:finished");
        return result;
    }

    public void readLock() {
        this.mReadLock.lock();
    }

    public boolean tryReadLock(long timeoutMs) throws InterruptedException {
        return this.mReadLock.tryLock(timeoutMs, TimeUnit.MILLISECONDS);
    }

    public void readUnlock() {
        this.mReadLock.unlock();
    }

    public void writeLock() {
        this.mWriteLock.lock();
    }

    public boolean tryWriteLock(long timeoutMs) throws InterruptedException {
        return this.mWriteLock.tryLock(timeoutMs, TimeUnit.MILLISECONDS);
    }

    public void writeUnlock() {
        this.mWriteLock.unlock();
    }

    protected int state() {
        this.mReadLock.lock();
        try {
            int n = this.mState;
            return n;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    protected boolean setState(int newState) {
        boolean changed;
        this.mWriteLock.lock();
        try {
            changed = this.mState != newState;
            this.mState = newState;
        }
        finally {
            this.mWriteLock.unlock();
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setState(int newState, int mask) {
        boolean changed;
        this.mWriteLock.lock();
        try {
            int state = this.mState & mask;
            boolean bl = changed = state != newState;
            if (changed) {
                this.mState = state | newState;
            }
        }
        finally {
            this.mWriteLock.unlock();
        }
        return changed;
    }

    private native long nativeCreate();

    private native void nativeDestroy(long var1);

    private static native int nativeConnect(long var0, int var2);

    private static native int nativeDisconnect(long var0);

    private static native int nativeOutputDescriptor(long var0, int var2, int var3, int var4, String var5);

    private static native int nativeStartStream(long var0);

    private static native int nativeStopStream(long var0);

    static {
        NativeLibLoader.loadNative();
    }
}

