/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.serenegiant.usb.NativeLibLoader;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

@Keep
public final class DeviceDetector {
    private static final boolean DEBUG = false;
    private static final String TAG = DeviceDetector.class.getSimpleName();
    static DeviceDetector sDeviceDetector;
    private final Set<DeviceDetectorCallback> mCallbacks = new CopyOnWriteArraySet<DeviceDetectorCallback>();

    public static synchronized DeviceDetector getInstance() {
        if (sDeviceDetector == null) {
            sDeviceDetector = new DeviceDetector();
        }
        return sDeviceDetector;
    }

    private DeviceDetector() {
        this.nativeCreate();
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    private void release() {
        DeviceDetector.nativeRelease();
    }

    public void add(@NonNull String name, int fileDescriptor) {
        DeviceDetector.nativeAdd(name, fileDescriptor);
    }

    public void remove(@NonNull String name) {
        DeviceDetector.nativeRemove(name);
    }

    public void clearAll() {
        DeviceDetector.nativeClearAll();
    }

    public void add(@NonNull DeviceDetectorCallback callback) {
        this.mCallbacks.add(callback);
    }

    public void remove(@NonNull DeviceDetectorCallback callback) {
        this.mCallbacks.remove(callback);
    }

    protected void onRequestRefreshDevice() {
        for (DeviceDetectorCallback callback : this.mCallbacks) {
            callback.onRequestRefreshDevices();
        }
    }

    private native int nativeCreate();

    private static native int nativeRelease();

    private static native int nativeClearAll();

    private static native int nativeAdd(@NonNull String var0, int var1);

    private static native int nativeRemove(@NonNull String var0);

    static {
        NativeLibLoader.loadNative();
    }

    public static interface DeviceDetectorCallback {
        public void onRequestRefreshDevices();
    }
}

