/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.camera;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.params.TonemapCurve;
import android.opengl.Matrix;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.util.Range;
import android.util.Rational;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.serenegiant.camera.AbstractBuiltInCamera;
import com.serenegiant.camera.Camera2Utils;
import com.serenegiant.camera.CameraConst;
import com.serenegiant.camera.FuncMaxMinDef;
import com.serenegiant.camera.RawFrameType;
import com.serenegiant.camera.Size;
import com.serenegiant.utils.HandlerThreadHandler;
import com.serenegiant.view.ViewUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

@RequiresApi(value=21)
public abstract class AbstractBuiltInCamera2
extends AbstractBuiltInCamera<CameraDevice> {
    private static final boolean DEBUG = true;
    private static final String TAG = AbstractBuiltInCamera2.class.getSimpleName();
    @NonNull
    private final Semaphore mCameraOpenCloseLock = new Semaphore(1);
    private final boolean mOwnCameraThread;
    @Nullable
    protected Handler mCameraHandler;
    @NonNull
    protected final float[] mMatrix = new float[16];
    private int mRotation;
    @Nullable
    private CameraCaptureSession mCaptureSession;
    @Nullable
    private CaptureRequest.Builder mPreviewRequestBuilder;
    @NonNull
    private final List<CaptureRequest> mPreviewRequest = new ArrayList<CaptureRequest>();
    protected volatile boolean mRequestPreview;
    protected final int mTemplateType;
    private final boolean mNeedCaptureCallback;
    private final int mBurstNum;
    private final int mAFMode;
    private final Runnable mStartPreviewTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Log.v((String)TAG, (String)"mStartPreviewTask#run:");
            try {
                AbstractBuiltInCamera2.this.mCameraOpenCloseLock.acquire();
                try {
                    CameraDevice camera = (CameraDevice)AbstractBuiltInCamera2.this.getCamera();
                    if (camera == null) {
                        Log.d((String)TAG, (String)"mStartPreviewTask#run:unexpectedly camera is not set");
                        return;
                    }
                    SurfaceTexture tex = AbstractBuiltInCamera2.this.getInputSurfaceTexture();
                    tex.setDefaultBufferSize(AbstractBuiltInCamera2.this.mInfo.width, AbstractBuiltInCamera2.this.mInfo.height);
                    Surface surface = new Surface(tex);
                    Log.v((String)TAG, (String)(String.format("mStartPreviewTask#run:size(%dx%d)", AbstractBuiltInCamera2.this.mInfo.width, AbstractBuiltInCamera2.this.mInfo.height) + ",surface=" + surface));
                    final CaptureRequest.Builder previewRequestBuilder = AbstractBuiltInCamera2.this.createCaptureRequestBuilder(camera, AbstractBuiltInCamera2.this.mTemplateType, surface);
                    Log.v((String)TAG, (String)("mStartPreviewTask#run:mPreviewRequestBuilder=" + AbstractBuiltInCamera2.this.mPreviewRequestBuilder));
                    camera.createCaptureSession(AbstractBuiltInCamera2.this.createCaptureSurfaceList(surface), new CameraCaptureSession.StateCallback(){

                        public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                            Log.v((String)TAG, (String)("onConfigured:session=" + cameraCaptureSession));
                            CameraDevice camera = (CameraDevice)AbstractBuiltInCamera2.this.getCamera();
                            if (camera == null) {
                                Log.w((String)TAG, (String)"onConfigured: camera is null");
                                return;
                            }
                            AbstractBuiltInCamera2.this.writeLock();
                            try {
                                AbstractBuiltInCamera2.this.mCaptureSession = cameraCaptureSession;
                                AbstractBuiltInCamera2.this.mPreviewRequestBuilder = previewRequestBuilder;
                            }
                            finally {
                                AbstractBuiltInCamera2.this.writeUnlock();
                            }
                            try {
                                previewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)AbstractBuiltInCamera2.this.mAFMode);
                                AbstractBuiltInCamera2.this.internalOnStartPreview(cameraCaptureSession);
                                AbstractBuiltInCamera2.this.applySettingsLocked(cameraCaptureSession, previewRequestBuilder);
                            }
                            catch (CameraAccessException | IllegalStateException e) {
                                Log.e((String)TAG, (String)("onConfigured:" + cameraCaptureSession), (Throwable)e);
                            }
                        }

                        public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                            Log.e((String)TAG, (String)("onConfigureFailed:" + cameraCaptureSession));
                        }
                    }, null);
                }
                catch (CameraAccessException e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                finally {
                    AbstractBuiltInCamera2.this.mCameraOpenCloseLock.release();
                }
            }
            catch (InterruptedException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    };
    private final CameraDevice.StateCallback mCameraStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(@NonNull CameraDevice camera) {
            Log.v((String)TAG, (String)("onOpened:camera=" + camera + ".mRequestPreview=" + AbstractBuiltInCamera2.this.mRequestPreview));
            AbstractBuiltInCamera2.this.mCameraOpenCloseLock.release();
            AbstractBuiltInCamera2.this.swap(camera);
            if (AbstractBuiltInCamera2.this.mRequestPreview) {
                AbstractBuiltInCamera2.this.mRequestPreview = false;
                Log.v((String)TAG, (String)"onOpened:request start preview");
                AbstractBuiltInCamera2.this.mCameraHandler.post(AbstractBuiltInCamera2.this.mStartPreviewTask);
            }
            Log.v((String)TAG, (String)"onOpened:finished");
        }

        public void onClosed(@NonNull CameraDevice camera) {
            super.onClosed(camera);
            Log.v((String)TAG, (String)("onClosed:camera=" + camera));
        }

        public void onDisconnected(@NonNull CameraDevice camera) {
            Log.v((String)TAG, (String)("onDisconnected:camera=" + camera));
            AbstractBuiltInCamera2.this.mRequestPreview = false;
            AbstractBuiltInCamera2.this.mCameraOpenCloseLock.release();
            camera.close();
            AbstractBuiltInCamera2.this.swap(null);
        }

        public void onError(@NonNull CameraDevice camera, int error) {
            Log.v((String)TAG, (String)("onError:camera=" + camera + ",err=" + error));
            AbstractBuiltInCamera2.this.mRequestPreview = false;
            AbstractBuiltInCamera2.this.mCameraOpenCloseLock.release();
            camera.close();
            AbstractBuiltInCamera2.this.swap(null);
        }
    };
    private final CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
            AbstractBuiltInCamera2.this.onCaptureProgressed(session, request, partialResult);
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            AbstractBuiltInCamera2.this.onCaptureCompleted(session, request, result);
        }
    };
    private final List<CaptureRequest.Key<?>> mAvailableKeys = new ArrayList();
    protected int mMinExposureCompensation;
    protected int mMaxExposureCompensation;
    protected double mStepExposureCompensation;
    protected double mScaleExposureCompensation;
    private int mTonemapMaxCurvePoints = 0;
    private int mMinContrast = 0;
    private int mMaxContrast = 1;
    private final float[][] mTonemapChannels = new float[3][];

    protected AbstractBuiltInCamera2(@NonNull Context context, int face, int templateType, boolean needCaptureCallback) throws Exception {
        this(context, null, face, templateType, needCaptureCallback, 1, 3);
    }

    protected AbstractBuiltInCamera2(@NonNull Context context, int face, int templateType, boolean needCaptureCallback, int burstNum) throws Exception {
        this(context, null, face, templateType, needCaptureCallback, burstNum, 3);
    }

    protected AbstractBuiltInCamera2(@NonNull Context context, @Nullable Handler cameraHandler, int face, int templateType, boolean needCaptureCallback, int burstNum, int afMode) throws Exception {
        super(context, face);
        this.mTemplateType = templateType;
        this.mNeedCaptureCallback = needCaptureCallback;
        this.mBurstNum = burstNum;
        this.mAFMode = afMode;
        if (cameraHandler != null) {
            this.mOwnCameraThread = false;
            this.mCameraHandler = cameraHandler;
        } else {
            Looper looper = Looper.myLooper();
            boolean bl = this.mOwnCameraThread = looper == null;
            if (this.mOwnCameraThread) {
                Log.v((String)TAG, (String)"create own camera thread");
                this.mCameraHandler = HandlerThreadHandler.createHandler((String)TAG);
            } else {
                this.mCameraHandler = new Handler(looper);
            }
        }
        this.init(context, face);
    }

    private void init(@NonNull Context context, int face) throws CameraAccessException {
        Log.v((String)TAG, (String)"init:");
        int degree = ViewUtils.getRotationDegrees((Context)context);
        CameraConst.CameraInfo info = Camera2Utils.findCamera((CameraManager)this.requireCameraManager(), (int)face);
        if (info == null) {
            throw new RuntimeException("failed to find internal camera");
        }
        this.mInfo.set(info);
        this.setRotation(degree);
        this.setState(16);
    }

    @Override
    @Nullable
    protected Size getVideoSizeSetting() {
        return null;
    }

    @Override
    protected void internalRelease() {
        Log.v((String)TAG, (String)"release:");
        if (this.mCameraHandler != null) {
            this.mCameraHandler.removeCallbacksAndMessages(null);
        }
        this.internalDisconnect();
        if (this.mOwnCameraThread && this.mCameraHandler != null) {
            try {
                this.mCameraHandler.getLooper().quit();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        this.mCameraHandler = null;
        Log.v((String)TAG, (String)"release:finished");
        super.internalRelease();
    }

    @Override
    protected void internalOpenCamera() throws Exception {
        Log.v((String)TAG, (String)"internalOpenCamera:");
        CameraManager manager = this.requireCameraManager();
        try {
            CameraCharacteristics characteristics = manager.getCameraCharacteristics(this.mInfo.id);
            StreamConfigurationMap map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            this.updateResolutions(map);
            this.internalCreateImageReader(manager);
            if (!this.mCameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Time out waiting to lock camera opening.");
            }
            manager.openCamera(this.mInfo.id, this.mCameraStateCallback, this.mCameraHandler);
        }
        catch (CameraAccessException e) {
            throw e;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void internalCreateImageReader(CameraManager manager) {
        Log.v((String)TAG, (String)"internalCreateImageReader:");
    }

    protected void internalCloseImageReader() {
        Log.v((String)TAG, (String)"internalCloseImageReader:");
    }

    private void internalStopCapture() {
        Log.v((String)TAG, (String)"internalStopCapture:");
        this.mRequestPreview = false;
        this.mPreviewRequest.clear();
        if (this.mCaptureSession != null) {
            try {
                this.mCaptureSession.abortCaptures();
            }
            catch (CameraAccessException e) {
                Log.d((String)TAG, (String)"internalStopCapture:", (Throwable)e);
            }
            catch (IllegalStateException e) {
                Log.d((String)TAG, (String)"internalStopCapture:", (Throwable)e);
            }
            this.mCaptureSession.close();
            this.mCaptureSession = null;
        }
        this.mPreviewRequestBuilder = null;
    }

    @Override
    protected void internalReOpen() {
        Log.v((String)TAG, (String)"internalReOpen:");
    }

    @Override
    protected boolean internalDisconnect() {
        Log.v((String)TAG, (String)"internalDisconnect:");
        try {
            this.mCameraOpenCloseLock.acquire();
            this.internalStopCapture();
            this.internalCloseImageReader();
            CameraDevice camera = this.swap(null);
            if (camera != null) {
                camera.close();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera closing.", e);
        }
        finally {
            this.mCameraOpenCloseLock.release();
        }
        Log.v((String)TAG, (String)"internalDisconnect:finished");
        return false;
    }

    @Override
    public void toggleFacing() {
        Log.v((String)TAG, (String)"toggleFacing:");
    }

    @Override
    public void setVideoSize(int width, int height, float minFps, float maxFps) {
        this.setVideoSize(width, height, minFps, maxFps, 0.0f);
    }

    @Override
    public void setVideoSize(int width, int height, float minFps, float maxFps, float bandwidthFactor) {
        Log.v((String)TAG, (String)String.format("setVideoSize:Size(%dx%d)@(%f-%f)", width, height, Float.valueOf(minFps), Float.valueOf(maxFps)));
        if (this.mInfo.width == width && this.mInfo.height == height) {
            return;
        }
        CameraConst.CameraInfo info = null;
        try {
            info = Camera2Utils.findCamera((CameraManager)this.requireCameraManager(), (int)width, (int)height, (int)this.mInfo.face, (int)ViewUtils.getRotationDegrees((Context)this.requireContext()));
        }
        catch (CameraAccessException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        Log.v((String)TAG, (String)("setVideoSize:info=" + info));
        if (info != null) {
            this.mInfo.set(info);
            this.currentMinFps = minFps;
            this.currentMaxFps = maxFps;
            this.resize(this.mInfo.width, this.mInfo.height);
        }
    }

    @Override
    public boolean startStream() {
        Log.v((String)TAG, (String)String.format("startStream:size(%dx%d)", this.mInfo.width, this.mInfo.height));
        this.readLock();
        try {
            this.resize(this.mInfo.width, this.mInfo.height);
            SurfaceTexture tex = this.getInputSurfaceTexture();
            tex.setDefaultBufferSize(this.mInfo.width, this.mInfo.height);
            CameraDevice camera = (CameraDevice)this.getCamera();
            if (camera != null) {
                Log.v((String)TAG, (String)"startStream:request start preview");
                this.mCameraHandler.post(this.mStartPreviewTask);
            } else {
                Log.d((String)TAG, (String)"startStream:camera is null, set start preview flag");
                this.mRequestPreview = true;
            }
        }
        finally {
            this.readUnlock();
        }
        this.setState(1024, -1025);
        Log.v((String)TAG, (String)"startStream:finished");
        return true;
    }

    @NonNull
    protected CaptureRequest.Builder createCaptureRequestBuilder(CameraDevice camera, int templateType, Surface previewSurface) throws CameraAccessException {
        Log.v((String)TAG, (String)"createCaptureRequestBuilder:");
        CaptureRequest.Builder builder = camera.createCaptureRequest(this.mTemplateType);
        builder.addTarget(previewSurface);
        return builder;
    }

    protected List<Surface> createCaptureSurfaceList(Surface captureSurface) {
        Log.v((String)TAG, (String)"createCaptureSurfaceList:");
        return Collections.singletonList(captureSurface);
    }

    protected void internalOnStartPreview(@NonNull CameraCaptureSession cameraCaptureSession) {
        Log.v((String)TAG, (String)"internalOnStartPreview:");
    }

    @Override
    protected void internalStopStream() {
        Log.v((String)TAG, (String)"internalStopStream:");
        try {
            this.mCameraOpenCloseLock.acquire();
            this.internalStopCapture();
            this.internalCloseImageReader();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.mCameraOpenCloseLock.release();
        }
        Log.v((String)TAG, (String)"internalStopStream:finished");
    }

    @Override
    public int getRotation() {
        boolean isFrontFace = this.mInfo.face == 1;
        int degrees = this.mRotation;
        if (isFrontFace) {
            degrees = (this.mInfo.orientation + degrees) % 360;
            degrees = (360 - degrees) % 360;
        } else {
            degrees = (this.mInfo.orientation - degrees + 360) % 360;
        }
        Log.v((String)TAG, (String)("getRotation:" + degrees));
        return degrees;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRotation() {
        Log.v((String)TAG, (String)"updateRotation:");
        this.readLock();
        try {
            int degrees;
            CameraDevice camera = (CameraDevice)this.getCamera();
            if (camera != null && this.mRotation != (degrees = ViewUtils.getRotationDegrees((Context)this.requireContext()))) {
                this.mRotation = degrees;
                boolean isPreviewing = this.isStreaming();
                this.setRotation(degrees);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @NonNull
    protected CameraManager requireCameraManager() {
        return (CameraManager)this.requireContext().getSystemService("camera");
    }

    protected static String getImageFormatString(int format) {
        switch (format) {
            case 0: {
                return "UNKNOWN";
            }
            case 1144402265: {
                return "DEPTH16";
            }
            case 16: {
                return "NV16";
            }
            case 257: {
                return "DEPTH_POINT_CLOUD";
            }
            case 41: {
                return "FLEX_RGB_888";
            }
            case 42: {
                return "FLEX_RGBA_8888";
            }
            case 256: {
                return "JPEG";
            }
            case 17: {
                return "NV21";
            }
            case 34: {
                return "PRIVATE";
            }
            case 37: {
                return "RAW10";
            }
            case 38: {
                return "RAW12";
            }
            case 36: {
                return "RAW_PRIVATE";
            }
            case 32: {
                return "RAW_SENSOR";
            }
            case 4: {
                return "RGB_565";
            }
            case 35: {
                return "YUV_420_888";
            }
            case 39: {
                return "YUV_422_888";
            }
            case 40: {
                return "YUV_444_888";
            }
            case 20: {
                return "YUY2";
            }
            case 842094169: {
                return "YV12";
            }
        }
        return "UNKNOWN" + format;
    }

    protected final void updateResolutions(StreamConfigurationMap map) {
        int[] formats;
        Log.v((String)TAG, (String)"updateResolutions:");
        this.mSupportedResolutions.clear();
        android.util.Size[] sizes = map.getOutputSizes(SurfaceTexture.class);
        int index = 0;
        for (android.util.Size sz : sizes) {
            this.mSupportedResolutions.add(new Size(RawFrameType.RAW_FRAME_INTERNAL_CAMERA, index++, sz.getWidth(), sz.getHeight()));
        }
        if (Build.VERSION.SDK_INT >= 23) {
            for (int format : formats = map.getInputFormats()) {
                Log.i((String)TAG, (String)("updateResolutions:input format=" + AbstractBuiltInCamera2.getImageFormatString(format)));
            }
        }
        for (int format : formats = map.getOutputFormats()) {
            Log.i((String)TAG, (String)("updateResolutions:output format=" + AbstractBuiltInCamera2.getImageFormatString(format)));
        }
    }

    @Override
    protected void updateCurrentSize() {
    }

    public float[] getMatrix() {
        return this.mMatrix;
    }

    protected void setRotation(int degrees) {
        Log.v((String)TAG, (String)("setRotation:" + degrees));
        Matrix.setIdentityM((float[])this.mMatrix, (int)0);
        if (degrees % 180 != 0) {
            Matrix.rotateM((float[])this.mMatrix, (int)0, (float)degrees, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.mRotation = degrees;
    }

    protected void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
        Log.v((String)TAG, (String)"onCaptureProgressed:");
    }

    protected void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        Log.v((String)TAG, (String)"onCaptureCompleted:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateCameraParamsLocked() {
        super.updateCameraParamsLocked();
        Log.v((String)TAG, (String)"updateCameraParamsLocked:");
        CameraManager manager = this.requireCameraManager();
        try {
            CameraCharacteristics characteristics = manager.getCameraCharacteristics(this.mInfo.id);
            List available = characteristics.getAvailableCaptureRequestKeys();
            this.writeLock();
            try {
                this.mAvailableKeys.clear();
                this.mAvailableKeys.addAll(available);
                if (available.contains(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION)) {
                    this.updateCameraParamsBrightness(characteristics);
                }
                if (available.contains(CaptureRequest.TONEMAP_MODE)) {
                    this.updateCameraParamsContrast(characteristics);
                }
            }
            finally {
                this.writeUnlock();
            }
        }
        catch (CameraAccessException e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    private void applySettingsLocked(@NonNull CameraCaptureSession session, @NonNull CaptureRequest.Builder builder) throws CameraAccessException {
        Log.v((String)TAG, (String)("applySettingsLocked:session=" + session + ",builder=" + builder));
        this.mPreviewRequest.clear();
        if (this.mBurstNum <= 1) {
            CaptureRequest req = builder.build();
            this.mPreviewRequest.add(req);
            session.setRepeatingRequest(req, this.mNeedCaptureCallback ? this.mCaptureCallback : null, this.mCameraHandler);
        } else {
            for (int i = 0; i < this.mBurstNum; ++i) {
                CaptureRequest req = builder.build();
                this.mPreviewRequest.add(req);
            }
            session.setRepeatingBurst(this.mPreviewRequest, this.mNeedCaptureCallback ? this.mCaptureCallback : null, this.mCameraHandler);
        }
    }

    protected <T> T getValue(CaptureRequest.Key<T> key) throws IllegalStateException {
        CaptureRequest req;
        CaptureRequest captureRequest = req = !this.mPreviewRequest.isEmpty() ? this.mPreviewRequest.get(0) : null;
        if (req != null) {
            return (T)req.get(key);
        }
        throw new IllegalStateException("not ready");
    }

    protected <T> void setValue(CaptureRequest.Key<T> key, T value) throws IllegalStateException {
        if (this.mPreviewRequestBuilder != null) {
            this.mPreviewRequestBuilder.set(key, value);
            return;
        }
        throw new IllegalStateException("not ready");
    }

    @Override
    public int setExposurePriority(int i) {
        return 0;
    }

    @Override
    public int getExposurePriority() {
        return 0;
    }

    @Override
    public int getExposurePriorityDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getExposurePriorityInfo() {
        return null;
    }

    @Override
    public int setExposure(int i) {
        return 0;
    }

    @Override
    public int getExposure() {
        return 0;
    }

    @Override
    public int getExposureDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getExposureInfo() {
        return null;
    }

    @Override
    public int setExposureRel(int i) {
        return 0;
    }

    @Override
    public int getExposureRel() {
        return 0;
    }

    @Override
    public int getExposureRelDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getExposureRelInfo() {
        return null;
    }

    private void updateCameraParamsBrightness(CameraCharacteristics characteristics) {
        Rational controlAECompensationStep = (Rational)characteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP);
        if (controlAECompensationStep != null) {
            this.mStepExposureCompensation = controlAECompensationStep.doubleValue();
            Range controlAECompensationRange = (Range)characteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
            if (controlAECompensationRange != null) {
                this.mMinExposureCompensation = (Integer)controlAECompensationRange.getLower();
                this.mMaxExposureCompensation = (Integer)controlAECompensationRange.getUpper();
                this.mScaleExposureCompensation = (double)(this.mMaxExposureCompensation - this.mMinExposureCompensation) / this.mStepExposureCompensation / 100.0;
            }
            Log.v((String)TAG, (String)String.format("updateCameraParamsBrightness:min=%d,max=%d,step=%f,scale=%f", this.mMinExposureCompensation, this.mMaxExposureCompensation, this.mStepExposureCompensation, this.mScaleExposureCompensation));
        }
        this.mProcSupports |= this.mMaxExposureCompensation >= 0 && this.mMaxExposureCompensation > 0 ? -2147483647L : 0L;
        if ((this.mProcSupports & 0xFFFFFFFF80000001L) == 0L) {
            Log.w((String)TAG, (String)"This camera does not support PU_BRIGHTNESS");
        }
    }

    @Override
    public int setBrightness(int brightness) throws IllegalStateException {
        Log.v((String)TAG, (String)("setBrightness:" + brightness));
        try {
            this.mCameraOpenCloseLock.acquire();
            try {
                CameraDevice camera = (CameraDevice)this.getCamera();
                if (camera == null || this.mCaptureSession == null) {
                    throw new IllegalStateException("camera is null, already released?");
                }
                int value = (int)((float)this.mMinExposureCompensation + (float)(this.mMaxExposureCompensation - this.mMinExposureCompensation) * ((float)brightness / 100.0f));
                Log.v((String)TAG, (String)("setBrightness:value=" + value));
                this.setValue(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, value);
                this.applySettingsLocked(this.mCaptureSession, this.mPreviewRequestBuilder);
            }
            catch (CameraAccessException e) {
                throw new IllegalStateException("can't access camera");
            }
            finally {
                this.mCameraOpenCloseLock.release();
            }
            return this.getBrightness();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted while trying to lock camera");
        }
    }

    @Override
    public int getBrightness() throws IllegalStateException {
        this.readLock();
        try {
            int value = (Integer)this.getValue(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION);
            int n = (int)((double)((value - this.mMinExposureCompensation) / (this.mMaxExposureCompensation - this.mMinExposureCompensation)) * this.mScaleExposureCompensation);
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public int getBrightnessDef() {
        return 50;
    }

    @Override
    public FuncMaxMinDef getBrightnessInfo() {
        return null;
    }

    private void updateCameraParamsContrast(CameraCharacteristics characteristics) {
        Log.v((String)TAG, (String)"updateCameraParamsContrast:");
        try {
            this.mTonemapMaxCurvePoints = (Integer)characteristics.get(CameraCharacteristics.TONEMAP_MAX_CURVE_POINTS);
            Log.w((String)TAG, (String)("updateCameraParamsContrast:mTonemapMaxCurvePoints=" + this.mTonemapMaxCurvePoints));
            this.mProcSupports |= this.mTonemapMaxCurvePoints >= 2 ? -2147483646L : 0L;
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
        if ((this.mProcSupports & 0xFFFFFFFF80000002L) == 0L) {
            Log.w((String)TAG, (String)"This camera does not support PU_CONTRAST");
        }
    }

    @Override
    public int setContrast(int contrast) throws IllegalStateException {
        Log.v((String)TAG, (String)("setContrast:" + contrast));
        try {
            this.mCameraOpenCloseLock.acquire();
            try {
                CameraDevice camera = (CameraDevice)this.getCamera();
                if (camera == null || this.mCaptureSession == null) {
                    throw new IllegalStateException("camera is null, already released?");
                }
                float value = (int)((float)this.mMinContrast + (float)(this.mMaxContrast - this.mMinContrast) * ((float)contrast / 100.0f));
                float[][] newValues = new float[3][];
                for (int channel = 0; channel <= 2; ++channel) {
                    float[] array = new float[this.mTonemapChannels[channel].length];
                    System.arraycopy(this.mTonemapChannels[channel], 0, array, 0, array.length);
                    int i = 0;
                    while (i < array.length) {
                        int n = i++;
                        array[n] = array[n] * value;
                    }
                    newValues[channel] = array;
                }
                TonemapCurve tc = new TonemapCurve(newValues[0], newValues[1], newValues[2]);
                this.setValue(CaptureRequest.TONEMAP_MODE, 0);
                this.setValue(CaptureRequest.TONEMAP_CURVE, tc);
                this.applySettingsLocked(this.mCaptureSession, this.mPreviewRequestBuilder);
            }
            catch (CameraAccessException e) {
                throw new IllegalStateException("can't access camera");
            }
            finally {
                this.mCameraOpenCloseLock.release();
            }
            return this.getBrightness();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted while trying to lock camera");
        }
    }

    @Override
    public int getContrast() throws IllegalStateException {
        return 0;
    }

    @Override
    public int getContrastDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getContrastInfo() {
        return null;
    }

    @Override
    public int setSharpness(int i) {
        return 0;
    }

    @Override
    public int getSharpness() {
        return 0;
    }

    @Override
    public int getSharpnessDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getSharpnessInfo() {
        return null;
    }

    @Override
    public int setSaturation(int i) {
        return 0;
    }

    @Override
    public int getSaturation() {
        return 0;
    }

    @Override
    public int getSaturationDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getSaturationInfo() {
        return null;
    }
}

