/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.view;

import android.annotation.SuppressLint;
import android.content.res.Configuration;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.view.ViewTransformer;
import com.serenegiant.view.ViewUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class ViewTransformDelegater
extends ViewTransformer {
    private static final boolean DEBUG = false;
    private static final String TAG = ViewTransformDelegater.class.getSimpleName();
    public static final int TOUCH_DISABLED = 0;
    public static final int TOUCH_ENABLED_MOVE = 1;
    public static final int TOUCH_ENABLED_ZOOM = 2;
    public static final int TOUCH_ENABLED_ROTATE = 4;
    public static final int TOUCH_ENABLED_ALL = 7;
    public static final int TAP_TIMEOUT = ViewConfiguration.getTapTimeout() * 2;
    public static final int LONG_PRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
    public static final int STATE_RESET = -1;
    public static final int STATE_NON = 0;
    public static final int STATE_WAITING = 1;
    public static final int STATE_DRAGGING = 2;
    public static final int STATE_CHECKING = 3;
    public static final int STATE_ZOOMING = 4;
    public static final int STATE_ROTATING = 5;
    public static final float DEFAULT_MAX_SCALE = 10.0f;
    public static final float DEFAULT_MIN_SCALE = 0.05f;
    public static final float DEFAULT_SCALE = 1.0f;
    public static final float MIN_DISTANCE = 15.0f;
    public static final float MIN_DISTANCE_SQUARE = 225.0f;
    public static final float MOVE_LIMIT_RATE = 0.2f;
    public static final int CHECK_TIMEOUT = ViewConfiguration.getTapTimeout() + ViewConfiguration.getLongPressTimeout();
    private int mScaleMode;
    private boolean mNeedResizeToKeepAspect;
    private int mHandleTouchEvent = 7;
    private boolean mIsRestored;
    @NonNull
    protected final Matrix mImageMatrix = new Matrix();
    @NonNull
    private final Matrix mSavedImageMatrix = new Matrix();
    @NonNull
    private final RectF mLimitRect = new RectF();
    @NonNull
    private final ViewUtils.LineSegment[] mLimitSegments = new ViewUtils.LineSegment[4];
    @NonNull
    private final RectF mContentRect = new RectF();
    @NonNull
    private final float[] mTransCoords = new float[8];
    private int mPrimaryId;
    private int mSecondaryId;
    private float mPrimaryX;
    private float mPrimaryY;
    private float mSecondX;
    private float mSecondY;
    private float mPivotX;
    private float mPivotY;
    private float mTouchDistance;
    private float mCurrentDegrees;
    private boolean mIsRotating;
    private float mMaxScale = 10.0f;
    private float mMinScale = 0.05f;
    private int mState = 0;
    @Nullable
    private ViewTransformListener mViewTransformListener;
    private Runnable mWaitImageReset;
    private Runnable mStartCheckRotate;
    private Runnable mWaitReverseReset;

    public ViewTransformDelegater(@NonNull View parent) {
        super(parent);
        if (parent instanceof ViewTransformListener) {
            this.mViewTransformListener = (ViewTransformListener)parent;
        }
    }

    @Override
    @NonNull
    public ViewTransformer setTransform(@Nullable Matrix transform) {
        super.setTransform(transform);
        if (this.mViewTransformListener != null) {
            this.mViewTransformListener.onTransformed(this.getTargetView(), transform);
        }
        return this;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            SavedState saved = (SavedState)state;
            this.mIsRestored = true;
            this.mImageMatrix.setValues(saved.mMatrixCache);
            this.mState = saved.mState;
            this.mHandleTouchEvent = saved.mHandleTouchEvent;
            this.mMinScale = saved.mMinScale;
            this.mMaxScale = saved.mMaxScale;
            this.mCurrentDegrees = saved.mCurrentDegrees;
        }
    }

    public Parcelable onSaveInstanceState(Parcelable superState) {
        SavedState saveState = new SavedState(superState);
        saveState.mState = this.mState;
        saveState.mHandleTouchEvent = this.mHandleTouchEvent;
        saveState.mMinScale = this.mMinScale;
        saveState.mMaxScale = this.mMaxScale;
        saveState.mCurrentDegrees = this.mCurrentDegrees;
        this.mImageMatrix.getValues(saveState.mMatrixCache);
        return saveState;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.mIsRestored = false;
    }

    /*
     * Unable to fully structure code
     */
    @SuppressLint(value={"SwitchIntDef"})
    public boolean onTouchEvent(MotionEvent event) {
        if (this.mHandleTouchEvent == 0) {
            return false;
        }
        view = this.getTargetView();
        actionCode = event.getActionMasked();
        switch (actionCode) {
            case 0: {
                this.startWaiting(event);
                return true;
            }
            case 5: {
                switch (this.mState) {
                    case 1: {
                        view.removeCallbacks(this.mWaitImageReset);
                    }
                    case 2: {
                        if (event.getPointerCount() <= 1) break;
                        this.startCheck(event);
                        return true;
                    }
                }
                break;
            }
            case 2: {
                switch (this.mState) {
                    case 1: {
                        if ((this.mHandleTouchEvent & 1) != 1 || !this.checkTouchMoved(event)) break;
                        view.removeCallbacks(this.mWaitImageReset);
                        this.setState(2);
                        return true;
                    }
                    case 2: {
                        if (!this.processDrag(event)) break;
                        return true;
                    }
                    case 3: {
                        if (!this.checkTouchMoved(event) || (this.mHandleTouchEvent & 2) != 2) break;
                        this.startZoom(event);
                        return true;
                    }
                    case 4: {
                        if (!this.processZoom(event)) break;
                        return true;
                    }
                    case 5: {
                        if (!this.processRotate(event)) break;
                        return true;
                    }
                }
                break;
            }
            case 1: 
            case 3: {
                view.removeCallbacks(this.mWaitImageReset);
                view.removeCallbacks(this.mStartCheckRotate);
                if (actionCode != 1 || this.mState != 1) ** GOTO lbl55
                downTime = SystemClock.uptimeMillis() - event.getDownTime();
                if (downTime <= (long)ViewTransformDelegater.LONG_PRESS_TIMEOUT) ** GOTO lbl52
                view.performLongClick();
                ** GOTO lbl55
lbl52:
                // 1 sources

                if (downTime < (long)ViewTransformDelegater.TAP_TIMEOUT) {
                    view.performClick();
                }
            }
lbl55:
            // 6 sources

            case 6: {
                this.setState(0);
            }
        }
        return false;
    }

    public void setViewTransformListener(@Nullable ViewTransformListener listener) {
        this.mViewTransformListener = listener;
    }

    public ViewTransformListener getViewTransformListener() {
        return this.mViewTransformListener;
    }

    public void setEnableHandleTouchEvent(int enabled) {
        this.mHandleTouchEvent = enabled;
    }

    public int getEnableHandleTouchEvent() {
        return this.mHandleTouchEvent;
    }

    public void setMaxScale(float maxScale) throws IllegalArgumentException {
        if (this.mMinScale > maxScale || maxScale <= 0.0f) {
            throw new IllegalArgumentException();
        }
        if (this.mMaxScale != maxScale) {
            this.mMaxScale = maxScale;
            this.checkScale();
        }
    }

    public float getMaxScale() {
        return this.mMaxScale;
    }

    public void setMinScale(float minScale) throws IllegalArgumentException {
        if (this.mMaxScale < minScale || minScale <= 0.0f) {
            throw new IllegalArgumentException();
        }
        if (this.mMinScale != minScale) {
            this.mMinScale = minScale;
            this.checkScale();
        }
    }

    public float getMinScale() {
        return this.mMinScale;
    }

    public ViewTransformDelegater setScaleRelative(float scaleRelative) {
        this.getTransform(this.mImageMatrix);
        float tmpScale = scaleRelative * this.getScale();
        if (tmpScale >= this.mMinScale && tmpScale <= this.mMaxScale && this.mImageMatrix.postScale(scaleRelative, scaleRelative, (float)this.getViewWidth() / 2.0f, (float)this.getViewHeight() / 2.0f)) {
            this.setTransform(this.mImageMatrix);
        }
        return this;
    }

    public void setScaleMode(int scaleMode) {
        if (this.mScaleMode != scaleMode) {
            this.mScaleMode = scaleMode;
            this.getTargetView().requestLayout();
        }
    }

    public int getScaleMode() {
        return this.mScaleMode;
    }

    public void setKeepAspect(boolean keepAspect) {
        if (this.mNeedResizeToKeepAspect != keepAspect) {
            this.mNeedResizeToKeepAspect = keepAspect;
            this.getTargetView().requestLayout();
        }
    }

    public void init() {
        this.mState = -1;
        this.clearPendingTasks();
        if (!this.mIsRestored) {
            this.onInit();
            this.updateTransform(true);
            this.mCurrentDegrees = 0.0f;
        }
        this.mIsRestored = false;
        this.mIsRotating = Math.abs((float)((int)(this.mCurrentDegrees / 360.0f)) * 360.0f - this.mCurrentDegrees) > 0.1f;
        this.mLimitRect.set(this.getDrawingRect());
        RectF bounds = this.getContentBounds();
        if (bounds != null && !bounds.isEmpty()) {
            this.mContentRect.set(bounds);
        } else {
            this.mContentRect.set(this.mLimitRect);
        }
        this.mLimitRect.inset(0.2f * (float)this.getViewWidth(), 0.2f * (float)this.getViewHeight());
        this.mLimitSegments[0] = null;
        this.setupDefaultTransform();
        this.setState(0);
    }

    private void setupDefaultTransform() {
        int viewWidth = this.getViewWidth();
        int viewHeight = this.getViewHeight();
        float contentWidth = this.mContentRect.width();
        float contentHeight = this.mContentRect.height();
        float scaleX = (float)viewWidth / contentWidth;
        float scaleY = (float)viewHeight / contentHeight;
        this.mImageMatrix.reset();
        switch (this.mScaleMode) {
            case 1: {
                this.mImageMatrix.setScale(scaleX, scaleY);
                break;
            }
            case 0: 
            case 2: {
                float scale = this.mScaleMode == 2 ? Math.max(scaleX, scaleY) : Math.min(scaleX, scaleY);
                float dx = Math.round(((float)viewWidth - contentWidth * scale) * 0.5f);
                float dy = Math.round(((float)viewHeight - contentHeight * scale) * 0.5f);
                this.mImageMatrix.setScale(scale, scale);
                this.mImageMatrix.postTranslate(dx, dy);
                break;
            }
        }
        this.setTransform(this.mImageMatrix);
        this.setDefault(this.mImageMatrix);
    }

    public void clearPendingTasks() {
        View view = this.getTargetView();
        if (this.mWaitImageReset != null) {
            view.removeCallbacks(this.mWaitImageReset);
        }
        if (this.mStartCheckRotate != null) {
            view.removeCallbacks(this.mStartCheckRotate);
        }
        if (this.mWaitReverseReset != null) {
            view.removeCallbacks(this.mWaitReverseReset);
        }
    }

    private void checkScale() {
        float scale = this.getScale();
        if (scale < this.mMinScale) {
            scale = this.mMinScale;
            this.getTransform(this.mImageMatrix);
            this.mImageMatrix.setScale(scale, scale);
            this.setTransform(this.mImageMatrix);
        } else if (scale > this.mMaxScale) {
            scale = this.mMaxScale;
            this.getTransform(this.mImageMatrix);
            this.mImageMatrix.setScale(scale, scale);
            this.setTransform(this.mImageMatrix);
        }
    }

    private void setState(int state) {
        if (this.mState != state) {
            this.mState = state;
            this.getTransform(this.mSavedImageMatrix);
            this.mImageMatrix.set(this.mSavedImageMatrix);
            if (this.mViewTransformListener != null) {
                this.mViewTransformListener.onStateChanged(this.getTargetView(), state);
            }
        }
    }

    private void startWaiting(@NonNull MotionEvent event) {
        this.mPrimaryId = 0;
        this.mSecondaryId = -1;
        this.mPrimaryX = this.mSecondX = event.getX();
        this.mPrimaryY = this.mSecondY = event.getY();
        if (this.mWaitImageReset == null) {
            this.mWaitImageReset = new WaitImageReset();
        }
        this.getTargetView().postDelayed(this.mWaitImageReset, (long)CHECK_TIMEOUT);
        this.setState(1);
    }

    private boolean processDrag(@NonNull MotionEvent event) {
        boolean canMove;
        float dx = event.getX() - this.mPrimaryX;
        float dy = event.getY() - this.mPrimaryY;
        this.mTransCoords[0] = this.mTransCoords[6] = this.mContentRect.left;
        this.mTransCoords[1] = this.mTransCoords[3] = this.mContentRect.top;
        this.mTransCoords[5] = this.mTransCoords[7] = this.mContentRect.bottom;
        this.mTransCoords[2] = this.mTransCoords[4] = this.mContentRect.right;
        this.mImageMatrix.mapPoints(this.mTransCoords);
        for (int i = 0; i < 8; i += 2) {
            int n = i;
            this.mTransCoords[n] = this.mTransCoords[n] + dx;
            int n2 = i + 1;
            this.mTransCoords[n2] = this.mTransCoords[n2] + dy;
        }
        boolean bl = canMove = this.mLimitRect.contains(this.mTransCoords[0], this.mTransCoords[1]) || this.mLimitRect.contains(this.mTransCoords[2], this.mTransCoords[3]) || this.mLimitRect.contains(this.mTransCoords[4], this.mTransCoords[5]) || this.mLimitRect.contains(this.mTransCoords[6], this.mTransCoords[7]) || ViewUtils.ptInPoly(this.mLimitRect.left, this.mLimitRect.top, this.mTransCoords) || ViewUtils.ptInPoly(this.mLimitRect.right, this.mLimitRect.top, this.mTransCoords) || ViewUtils.ptInPoly(this.mLimitRect.right, this.mLimitRect.bottom, this.mTransCoords) || ViewUtils.ptInPoly(this.mLimitRect.left, this.mLimitRect.bottom, this.mTransCoords);
        if (!canMove) {
            ViewUtils.LineSegment side;
            if (this.mLimitSegments[0] == null) {
                this.mLimitSegments[0] = new ViewUtils.LineSegment(this.mLimitRect.left, this.mLimitRect.top, this.mLimitRect.right, this.mLimitRect.top);
                this.mLimitSegments[1] = new ViewUtils.LineSegment(this.mLimitRect.right, this.mLimitRect.top, this.mLimitRect.right, this.mLimitRect.bottom);
                this.mLimitSegments[2] = new ViewUtils.LineSegment(this.mLimitRect.right, this.mLimitRect.bottom, this.mLimitRect.left, this.mLimitRect.bottom);
                this.mLimitSegments[3] = new ViewUtils.LineSegment(this.mLimitRect.left, this.mLimitRect.bottom, this.mLimitRect.left, this.mLimitRect.top);
            }
            if (!(canMove = ViewUtils.checkIntersect(side = new ViewUtils.LineSegment(this.mTransCoords[0], this.mTransCoords[1], this.mTransCoords[2], this.mTransCoords[3]), this.mLimitSegments))) {
                side.set(this.mTransCoords[2], this.mTransCoords[3], this.mTransCoords[4], this.mTransCoords[5]);
                canMove = ViewUtils.checkIntersect(side, this.mLimitSegments);
                if (!canMove) {
                    side.set(this.mTransCoords[4], this.mTransCoords[5], this.mTransCoords[6], this.mTransCoords[7]);
                    canMove = ViewUtils.checkIntersect(side, this.mLimitSegments);
                    if (!canMove) {
                        side.set(this.mTransCoords[6], this.mTransCoords[7], this.mTransCoords[0], this.mTransCoords[1]);
                        canMove = ViewUtils.checkIntersect(side, this.mLimitSegments);
                    }
                }
            }
        }
        if (canMove) {
            if (!this.mIsRotating) {
                float left = Math.min(Math.min(this.mTransCoords[0], this.mTransCoords[2]), Math.min(this.mTransCoords[4], this.mTransCoords[6]));
                float right = Math.max(Math.max(this.mTransCoords[0], this.mTransCoords[2]), Math.max(this.mTransCoords[4], this.mTransCoords[6]));
                float top = Math.min(Math.min(this.mTransCoords[1], this.mTransCoords[3]), Math.min(this.mTransCoords[5], this.mTransCoords[7]));
                float bottom = Math.max(Math.max(this.mTransCoords[1], this.mTransCoords[3]), Math.max(this.mTransCoords[5], this.mTransCoords[7]));
                if (right < this.mLimitRect.left) {
                    dx = this.mLimitRect.left - right;
                } else if (left + 0.1f > this.mLimitRect.right) {
                    dx = this.mLimitRect.right - left - 0.1f;
                }
                if (bottom < this.mLimitRect.top) {
                    dy = this.mLimitRect.top - bottom;
                } else if (top + 0.1f > this.mLimitRect.bottom) {
                    dy = this.mLimitRect.bottom - top - 0.1f;
                }
            }
            if ((dx != 0.0f || dy != 0.0f) && this.mImageMatrix.postTranslate(dx, dy)) {
                this.setTransform(this.mImageMatrix);
            }
        }
        this.mPrimaryX = event.getX();
        this.mPrimaryY = event.getY();
        return canMove;
    }

    private final void startCheck(MotionEvent event) {
        if (event.getPointerCount() > 1) {
            this.mPrimaryId = event.getPointerId(0);
            this.mPrimaryX = event.getX(0);
            this.mPrimaryY = event.getY(0);
            this.mSecondaryId = event.getPointerId(1);
            this.mSecondX = event.getX(1);
            this.mSecondY = event.getY(1);
            float dx = this.mSecondX - this.mPrimaryX;
            float dy = this.mSecondY - this.mPrimaryY;
            float distance = (float)Math.hypot(dx, dy);
            if (distance < 15.0f) {
                return;
            }
            this.mTouchDistance = distance;
            this.mPivotX = (this.mPrimaryX + this.mSecondX) / 2.0f;
            this.mPivotY = (this.mPrimaryY + this.mSecondY) / 2.0f;
            if ((this.mHandleTouchEvent & 4) == 4) {
                if (this.mStartCheckRotate == null) {
                    this.mStartCheckRotate = new StartCheckRotate();
                }
                this.getTargetView().postDelayed(this.mStartCheckRotate, (long)CHECK_TIMEOUT);
            }
            this.setState(3);
        }
    }

    private final void startZoom(MotionEvent event) {
        this.getTargetView().removeCallbacks(this.mStartCheckRotate);
        this.setState(4);
    }

    private final boolean processZoom(MotionEvent event) {
        this.restoreMatrix();
        float scale = this.calcScale(event);
        float tmpScale = scale * this.getScale();
        if (tmpScale < this.mMinScale) {
            return false;
        }
        if (tmpScale > this.mMaxScale) {
            return false;
        }
        if (this.mImageMatrix.postScale(scale, scale, this.mPivotX, this.mPivotY)) {
            this.setTransform(this.mImageMatrix);
        }
        return true;
    }

    private final float calcScale(MotionEvent event) {
        float dx = event.getX(0) - event.getX(1);
        float dy = event.getY(0) - event.getY(1);
        float distance = (float)Math.hypot(dx, dy);
        return distance / this.mTouchDistance;
    }

    private final boolean checkTouchMoved(MotionEvent event) {
        float y;
        float x;
        boolean result = true;
        int ix0 = event.findPointerIndex(this.mPrimaryId);
        int ix1 = event.findPointerIndex(this.mSecondaryId);
        if (ix0 >= 0 && (x = event.getX(ix0) - this.mPrimaryX) * x + (y = event.getY(ix0) - this.mPrimaryY) * y < 225.0f) {
            if (ix1 >= 0) {
                x = event.getX(ix1) - this.mSecondX;
                if (x * x + (y = event.getY(ix1) - this.mSecondY) * y < 225.0f) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return result;
    }

    private final boolean processRotate(MotionEvent event) {
        if (this.checkTouchMoved(event)) {
            this.restoreMatrix();
            this.mCurrentDegrees = this.calcAngle(event);
            boolean bl = this.mIsRotating = Math.abs((float)((int)(this.mCurrentDegrees / 360.0f)) * 360.0f - this.mCurrentDegrees) > 0.1f;
            if (this.mIsRotating && this.mImageMatrix.postRotate(this.mCurrentDegrees, this.mPivotX, this.mPivotY)) {
                this.setTransform(this.mImageMatrix);
                return true;
            }
        }
        return false;
    }

    private final float calcAngle(MotionEvent event) {
        int ix0 = event.findPointerIndex(this.mPrimaryId);
        int ix1 = event.findPointerIndex(this.mSecondaryId);
        float angle = 0.0f;
        if (ix0 >= 0 && ix1 >= 0) {
            float x0 = this.mSecondX - this.mPrimaryX;
            float y0 = this.mSecondY - this.mPrimaryY;
            float x1 = event.getX(ix1) - event.getX(ix0);
            float y1 = event.getY(ix1) - event.getY(ix0);
            double s = (x0 * x0 + y0 * y0) * (x1 * x1 + y1 * y1);
            double cos = (double)ViewUtils.dotProduct(x0, y0, x1, y1) / Math.sqrt(s);
            angle = 57.29578f * (float)Math.acos(cos) * Math.signum(ViewUtils.crossProduct(x0, y0, x1, y1));
        }
        return angle;
    }

    protected void restoreMatrix() {
        this.mImageMatrix.set(this.mSavedImageMatrix);
    }

    @NonNull
    private Rect getDrawingRect() {
        Rect r = new Rect();
        this.getTargetView().getDrawingRect(r);
        return r;
    }

    private int getViewWidth() {
        return this.getTargetView().getWidth();
    }

    private int getViewHeight() {
        return this.getTargetView().getHeight();
    }

    protected abstract RectF getContentBounds();

    protected abstract void onInit();

    public static class SavedState
    extends View.BaseSavedState {
        private int mState;
        private int mHandleTouchEvent;
        private float mMinScale;
        private float mMaxScale;
        private float mCurrentDegrees;
        private final float[] mMatrixCache = new float[9];
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel in) {
            super(in);
            this.readFromParcel(in);
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private void readFromParcel(Parcel in) {
            this.mState = in.readInt();
            this.mHandleTouchEvent = in.readInt();
            this.mMinScale = in.readFloat();
            this.mMaxScale = in.readFloat();
            this.mCurrentDegrees = in.readFloat();
            in.readFloatArray(this.mMatrixCache);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.mState);
            out.writeInt(this.mHandleTouchEvent);
            out.writeFloat(this.mMinScale);
            out.writeFloat(this.mMaxScale);
            out.writeFloat(this.mCurrentDegrees);
            out.writeFloatArray(this.mMatrixCache);
        }
    }

    private final class StartCheckRotate
    implements Runnable {
        private StartCheckRotate() {
        }

        @Override
        public void run() {
            if (ViewTransformDelegater.this.mState == 3) {
                ViewTransformDelegater.this.setState(5);
            }
        }
    }

    private final class WaitImageReset
    implements Runnable {
        private WaitImageReset() {
        }

        @Override
        public void run() {
            ViewTransformDelegater.this.getTargetView().requestLayout();
        }
    }

    public static interface ViewTransformListener {
        public void onStateChanged(@NonNull View var1, int var2);

        public void onTransformed(@NonNull View var1, @NonNull Matrix var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TouchMode {
    }
}

