/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.system;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.util.Pair;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.Fragment;
import com.serenegiant.system.SAFUtils;
import java.lang.ref.WeakReference;

@TargetApi(value=21)
public class SAFPermission {
    private static final boolean DEBUG = false;
    private static final String TAG = SAFPermission.class.getSimpleName();
    public static final SAFCallback DEFAULT_CALLBACK = new DefaultSAFCallback();
    @NonNull
    private final WeakReference<Context> mWeakContext;
    @NonNull
    private final ActivityResultLauncher<Pair<Integer, Uri>> mLauncher;

    @RequiresApi(api=21)
    public SAFPermission(@NonNull ComponentActivity activity, @NonNull SAFCallback callback) {
        this.mWeakContext = new WeakReference<ComponentActivity>(activity);
        this.mLauncher = activity.registerForActivityResult((ActivityResultContract)new OpenDocumentTree(), (ActivityResultCallback)new MyActivityResultCallback(this.mWeakContext, callback));
    }

    @RequiresApi(api=21)
    public SAFPermission(@NonNull Fragment fragment, @NonNull SAFCallback callback) {
        this.mWeakContext = new WeakReference<Context>(fragment.requireContext());
        this.mLauncher = fragment.registerForActivityResult((ActivityResultContract)new OpenDocumentTree(), (ActivityResultCallback)new MyActivityResultCallback(this.mWeakContext, callback));
    }

    public void requestPermission(int treeId) throws IllegalStateException {
        this.requestPermission(treeId, null);
    }

    @TargetApi(value=26)
    public void requestPermission(int treeId, @Nullable Uri initialUri) throws IllegalStateException {
        Context context = (Context)this.mWeakContext.get();
        if (context == null) {
            throw new IllegalStateException("context is already released!");
        }
        SAFUtils.releasePersistableUriPermission(context, treeId);
        this.mLauncher.launch((Object)Pair.create((Object)treeId, (Object)initialUri));
    }

    @TargetApi(value=21)
    private static class OpenDocumentTree
    extends ActivityResultContract<Pair<Integer, Uri>, Pair<Integer, Uri>> {
        private static final String TAG = OpenDocumentTree.class.getSimpleName();
        @Nullable
        private Pair<Integer, Uri> input;

        private OpenDocumentTree() {
        }

        @CallSuper
        @NonNull
        public Intent createIntent(@NonNull Context context, @Nullable Pair<Integer, Uri> input) {
            this.input = input;
            Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT_TREE");
            if (Build.VERSION.SDK_INT >= 26 && input != null) {
                Uri initialUri = input != null ? (Uri)input.second : null;
                intent.putExtra("android.provider.extra.INITIAL_URI", (Parcelable)initialUri);
            }
            return intent;
        }

        @Nullable
        public final ActivityResultContract.SynchronousResult<Pair<Integer, Uri>> getSynchronousResult(@NonNull Context context, @Nullable Pair<Integer, Uri> input) {
            Uri uri;
            this.input = input;
            if (input != null && (uri = SAFUtils.getStorageUri(context, (Integer)input.first)) != null) {
                return new ActivityResultContract.SynchronousResult((Object)Pair.create((Object)((Integer)input.first), (Object)uri));
            }
            return null;
        }

        @Nullable
        public final Pair<Integer, Uri> parseResult(int resultCode, @Nullable Intent intent) {
            Uri uri = intent != null && resultCode == -1 ? intent.getData() : null;
            int treeId = this.input != null ? (Integer)this.input.first : 0;
            return Pair.create((Object)treeId, (Object)uri);
        }
    }

    private static class MyActivityResultCallback
    implements ActivityResultCallback<Pair<Integer, Uri>> {
        private static final String TAG = MyActivityResultCallback.class.getSimpleName();
        @NonNull
        private final WeakReference<Context> mWeakContext;
        @NonNull
        final SAFCallback callback;

        private MyActivityResultCallback(@NonNull WeakReference<Context> weakContext, @NonNull SAFCallback callback) {
            this.mWeakContext = weakContext;
            this.callback = callback;
        }

        public void onActivityResult(Pair<Integer, Uri> result) {
            if (result != null) {
                int requestCode = (Integer)result.first;
                Uri uri = (Uri)result.second;
                Context context = (Context)this.mWeakContext.get();
                if (uri != null) {
                    if (context != null) {
                        SAFUtils.takePersistableUriPermission(context, requestCode, uri);
                    }
                    this.callback.onResult(requestCode, uri);
                } else {
                    if (context != null) {
                        SAFUtils.releasePersistableUriPermission(context, requestCode);
                    }
                    this.callback.onFailed(requestCode);
                }
            } else {
                this.callback.onFailed(0);
            }
        }
    }

    public static class DefaultSAFCallback
    implements SAFCallback {
        @Override
        public void onResult(int treeId, @NonNull Uri uri) {
        }

        @Override
        public void onFailed(int treeId) {
        }
    }

    public static interface SAFCallback {
        public void onResult(int var1, @NonNull Uri var2);

        public void onFailed(int var1);
    }
}

