/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.media.IMediaQueue;
import com.serenegiant.media.IRecycleBuffer;
import com.serenegiant.media.IRecycleParent;
import com.serenegiant.media.RecycleMediaData;
import com.serenegiant.utils.Pool;
import java.nio.ByteOrder;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class MemMediaQueue
implements IMediaQueue<RecycleMediaData> {
    @NonNull
    private final LinkedBlockingQueue<RecycleMediaData> mQueue;
    @NonNull
    private final IRecycleBuffer.Factory<RecycleMediaData> mFactory;
    @NonNull
    private final Pool<RecycleMediaData> mPool;

    public MemMediaQueue(int initNum, int maxNumInPool) {
        this(initNum, maxNumInPool, maxNumInPool, null);
    }

    public MemMediaQueue(int initNum, int maxNumInPool, int maxQueueSz) {
        this(initNum, maxNumInPool, maxQueueSz, null);
    }

    public MemMediaQueue(int initNum, int maxNumInPool, int maxQueueSz, @Nullable IRecycleBuffer.Factory<RecycleMediaData> factory) {
        this.mQueue = new LinkedBlockingQueue(maxQueueSz);
        this.mFactory = factory != null ? factory : new DefaultFactory();
        this.mPool = new Pool<RecycleMediaData>(initNum, maxNumInPool, new Object[0]){

            @Override
            @NonNull
            protected RecycleMediaData createObject(Object ... args) {
                return MemMediaQueue.this.mFactory.create(MemMediaQueue.this, args);
            }
        };
    }

    @Override
    public void init(Object ... args) {
        this.clear();
        this.mPool.init(args);
    }

    @Override
    public void clear() {
        this.mQueue.clear();
        this.mPool.clear();
    }

    @Override
    @Nullable
    public RecycleMediaData obtain(Object ... args) {
        return this.mPool.obtain(args);
    }

    @Override
    public boolean queueFrame(@NonNull RecycleMediaData buffer) {
        return this.mQueue.offer(buffer);
    }

    @Override
    @Nullable
    public RecycleMediaData peek() {
        return this.mQueue.peek();
    }

    @Override
    @Nullable
    public RecycleMediaData poll() {
        return this.mQueue.poll();
    }

    @Override
    @Nullable
    public RecycleMediaData poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.mQueue.poll(timeout, unit);
    }

    @Override
    public int count() {
        return this.mQueue.size();
    }

    @Override
    public boolean recycle(@NonNull RecycleMediaData buffer) {
        return this.mPool.recycle(buffer);
    }

    public static class DefaultFactory
    implements IRecycleBuffer.Factory<RecycleMediaData> {
        @Override
        @NonNull
        public RecycleMediaData create(@NonNull IRecycleParent<RecycleMediaData> parent, Object ... args) {
            int sz = 0;
            ByteOrder order = null;
            if (args != null && args.length > 0) {
                for (Object arg : args) {
                    if (arg instanceof Integer) {
                        sz = (Integer)arg;
                        continue;
                    }
                    if (!(arg instanceof ByteOrder)) continue;
                    order = (ByteOrder)arg;
                }
            }
            if (sz > 0 && order != null) {
                return new RecycleMediaData(parent, sz, order);
            }
            if (sz > 0) {
                return new RecycleMediaData(parent, sz);
            }
            if (order != null) {
                return new RecycleMediaData(parent, order);
            }
            return new RecycleMediaData(parent);
        }
    }
}

