/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.gl;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.opengl.GLES20;
import android.opengl.GLES30;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.serenegiant.egl.EGLBase;
import com.serenegiant.egl.EGLConst;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.SysPropReader;

public class GLContext
implements EGLConst {
    private static final boolean DEBUG = false;
    private static final String TAG = GLContext.class.getSimpleName();
    private static boolean isOutputVersionInfo = false;
    @NonNull
    private final Object mSync = new Object();
    private final int mMaxClientVersion;
    @Nullable
    private final EGLBase.IContext<?> mSharedContext;
    private final int mFlags;
    @Nullable
    private EGLBase mEgl = null;
    @Nullable
    private EGLBase.IEglSurface mEglMasterSurface;
    private long mGLThreadId;
    @Nullable
    private String mGlExtensions;

    public GLContext() {
        this(GLUtils.getSupportedGLVersion(), null, 0);
    }

    public GLContext(@NonNull GLContext src) {
        this(src.getMaxClientVersion(), src.getContext(), src.getFlags());
    }

    public GLContext(int maxClientVersion, @Nullable EGLBase.IContext<?> sharedContext, int flags) {
        this.mMaxClientVersion = maxClientVersion;
        this.mSharedContext = sharedContext;
        this.mFlags = flags;
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void release() {
        Object object = this.mSync;
        synchronized (object) {
            this.mGLThreadId = 0L;
            if (this.mEglMasterSurface != null) {
                this.mEglMasterSurface.release();
                this.mEglMasterSurface = null;
            }
            if (this.mEgl != null) {
                this.mEgl.release();
                this.mEgl = null;
            }
        }
    }

    @WorkerThread
    public void initialize() throws IllegalArgumentException {
        this.initialize(null, 1, 1);
    }

    @WorkerThread
    public void initialize(@Nullable Object surface, int width, int height) throws IllegalArgumentException {
        int masterHeight;
        int masterWidth;
        if (this.mEgl == null && (this.mSharedContext == null || this.mSharedContext instanceof EGLBase.IContext)) {
            int stencilBits = (this.mFlags & 4) == 4 ? 1 : ((this.mFlags & 0x20) == 32 ? 8 : 0);
            this.mEgl = EGLBase.createFrom(this.mMaxClientVersion, this.mSharedContext, (this.mFlags & 1) == 1, stencilBits, (this.mFlags & 2) == 2);
        }
        if (this.mEgl != null) {
            this.mGlExtensions = null;
            masterWidth = Math.max(width, 1);
            masterHeight = Math.max(height, 1);
            if (width <= 0 && height <= 0 && this.mEglMasterSurface != null) {
                masterWidth = Math.max(masterWidth, this.mEglMasterSurface.getWidth());
                masterHeight = Math.max(masterHeight, this.mEglMasterSurface.getHeight());
            }
            if (this.mEglMasterSurface != null) {
                this.mEglMasterSurface.release();
                this.mEglMasterSurface = null;
            }
        } else {
            throw new IllegalArgumentException("failed to create EGLBase");
        }
        this.mEglMasterSurface = GLUtils.isSupportedSurface(surface) ? this.mEgl.createFromSurface(surface) : this.mEgl.createOffscreen(masterWidth, masterHeight);
        this.mGLThreadId = Thread.currentThread().getId();
        this.makeDefault();
        if (!isOutputVersionInfo) {
            isOutputVersionInfo = true;
            GLContext.logVersionInfo();
        }
        this.isOES3Supported();
    }

    @NonNull
    public EGLBase getEgl() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mEgl != null) {
                return this.mEgl;
            }
            throw new IllegalStateException();
        }
    }

    public EGLBase.IConfig<?> getConfig() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mEgl != null) {
                return this.mEgl.getConfig();
            }
            throw new IllegalStateException();
        }
    }

    public int getMaxClientVersion() {
        return this.mMaxClientVersion;
    }

    public int getFlags() {
        return this.mFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMasterWidth() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mEglMasterSurface != null ? this.mEglMasterSurface.getWidth() : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMasterHeight() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mEglMasterSurface != null ? this.mEglMasterSurface.getHeight() : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public EGLBase.IContext<?> getContext() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            EGLBase.IContext<?> result;
            EGLBase.IContext<?> iContext = result = this.mEgl != null ? this.mEgl.getContext() : null;
            if (result == null) {
                throw new IllegalStateException();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void makeDefault() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mEgl == null || this.mEglMasterSurface == null) {
                throw new IllegalStateException();
            }
            this.mEglMasterSurface.makeCurrent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void swap() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mEgl == null || this.mEglMasterSurface == null) {
                throw new IllegalStateException();
            }
            this.mEglMasterSurface.swap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=18)
    @WorkerThread
    public void swap(long presentationTimeNs) throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mEgl == null || this.mEglMasterSurface == null) {
                throw new IllegalStateException();
            }
            this.mEglMasterSurface.swap(presentationTimeNs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void sync() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mEgl == null) {
                throw new IllegalStateException();
            }
            this.mEgl.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void waitGL() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mEgl == null) {
                throw new IllegalStateException();
            }
            this.mEgl.waitGL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void waitNative() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mEgl == null) {
                throw new IllegalStateException();
            }
            this.mEgl.waitNative();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getGLThreadId() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mGLThreadId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inGLThread() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mGLThreadId == Thread.currentThread().getId();
        }
    }

    public boolean isGLES2() {
        return this.getGlVersion() > 1;
    }

    public boolean isGLES3() {
        return this.getGlVersion() > 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGlVersion() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mEgl != null ? this.mEgl.getGlVersion() : 0;
        }
    }

    @WorkerThread
    public boolean hasExtension(@NonNull String extension) {
        if (TextUtils.isEmpty((CharSequence)this.mGlExtensions)) {
            this.mGlExtensions = GLES20.glGetString((int)7939);
        }
        return this.mGlExtensions != null && this.mGlExtensions.contains(extension);
    }

    public boolean isOES2Supported() {
        return this.isGLES2() && this.hasExtension("GL_OES_EGL_image_external");
    }

    public boolean isOES3Supported() {
        return this.isGLES3() && this.hasExtension("GL_OES_EGL_image_external_essl3");
    }

    private void checkGLThread() throws IllegalStateException {
        if (!this.inGLThread()) {
            throw new IllegalThreadStateException("Not a GL thread");
        }
    }

    @SuppressLint(value={"InlinedApi"})
    @WorkerThread
    public static void logVersionInfo() {
        Log.i((String)TAG, (String)("vendor:" + GLES20.glGetString((int)7936)));
        Log.i((String)TAG, (String)("renderer:" + GLES20.glGetString((int)7937)));
        Log.i((String)TAG, (String)("version:" + GLES20.glGetString((int)7938)));
        Log.i((String)TAG, (String)("supported version:" + GLContext.supportedGLESVersion()));
        Log.i((String)TAG, (String)("extensions:" + GLES20.glGetString((int)7939)));
    }

    @SuppressLint(value={"InlinedApi"})
    @WorkerThread
    public static float supportedGLESVersion() {
        String openGLESVersionString;
        float result = 0.0f;
        if (BuildCheck.isAndroid4_3()) {
            int[] values = new int[1];
            GLES30.glGetIntegerv((int)33307, (int[])values, (int)0);
            int majorVersion = values[0];
            GLES30.glGetIntegerv((int)33308, (int[])values, (int)0);
            int minorVersion = values[0];
            if (GLES30.glGetError() == 0) {
                result = (float)majorVersion + (float)minorVersion * 0.1f;
            }
        }
        if (result <= 0.0f && !TextUtils.isEmpty((CharSequence)(openGLESVersionString = SysPropReader.read("ro.opengles.version")))) {
            try {
                int openGLESVersion = Integer.parseInt(openGLESVersionString);
                result = (float)((openGLESVersion & 0xFFFF0000) >> 16) + 0.1f * (float)(openGLESVersion & 0xFFFF);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }
}

