/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.app;

import android.app.ActivityManager;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresPermission;
import com.serenegiant.system.ContextUtils;
import java.util.List;

public class ActivityUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = ActivityUtils.class.getSimpleName();

    private ActivityUtils() {
    }

    public static int getAppId(@NonNull Context context) {
        int id = -1;
        ActivityManager activityManager = ContextUtils.requireSystemService(context, ActivityManager.class);
        List recentTasks = activityManager.getRunningTasks(Integer.MAX_VALUE);
        for (int i = 0; i < recentTasks.size(); ++i) {
            if (!((ActivityManager.RunningTaskInfo)recentTasks.get((int)i)).baseActivity.getPackageName().equals(context.getPackageName())) continue;
            id = ((ActivityManager.RunningTaskInfo)recentTasks.get((int)i)).id;
            break;
        }
        return id;
    }

    @RequiresPermission(value="android.permission.REORDER_TASKS")
    public static void moveTaskToFront(@NonNull Context context) {
        int id = ActivityUtils.getAppId(context);
        if (id > 0) {
            ActivityManager activityManager = ContextUtils.requireSystemService(context, ActivityManager.class);
            activityManager.moveTaskToFront(id, 1);
        }
    }
}

