/*
 * Decompiled with CFR 0.152.
 */
package androidx.documentfile.provider;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.provider.DocumentsContract;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;
import androidx.documentfile.provider.SAFTreeDocumentFile;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.SAFUtils;
import java.util.ArrayList;
import java.util.Map;

@TargetApi(value=21)
public class SAFRootTreeDocumentFile
extends DocumentFile {
    @NonNull
    private final Context mContext;

    public static DocumentFile fromContext(@NonNull Context context) {
        return new SAFRootTreeDocumentFile(context);
    }

    SAFRootTreeDocumentFile(@NonNull Context context) {
        super(null);
        this.mContext = context;
    }

    @Nullable
    public DocumentFile createFile(@NonNull String mimeType, @NonNull String displayName) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public DocumentFile createDirectory(@NonNull String displayName) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public Uri getUri() {
        return Uri.parse((String)"content://com.serenegiant.SAFRootTreeDocumentFile");
    }

    @Nullable
    public String getName() {
        return "SAFRootDir";
    }

    @Nullable
    public String getType() {
        return null;
    }

    public boolean isDirectory() {
        return true;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isVirtual() {
        return true;
    }

    public long lastModified() {
        return 0L;
    }

    public long length() {
        return 0L;
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return false;
    }

    public boolean delete() {
        return false;
    }

    public boolean exists() {
        return false;
    }

    @NonNull
    public DocumentFile[] listFiles() {
        ArrayList<SAFTreeDocumentFile> result = new ArrayList<SAFTreeDocumentFile>();
        if (BuildCheck.isLollipop()) {
            Map<Integer, Uri> list = SAFUtils.getStorageUriAll(this.mContext);
            for (Map.Entry<Integer, Uri> item : list.entrySet()) {
                result.add(new SAFTreeDocumentFile(this, this.mContext, DocumentsContract.buildDocumentUriUsingTree((Uri)item.getValue(), (String)DocumentsContract.getTreeDocumentId((Uri)item.getValue())), item.getKey()));
            }
        }
        return result.toArray(new DocumentFile[0]);
    }

    public boolean renameTo(@NonNull String displayName) {
        return false;
    }
}

