/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.RelativeLayout;
import com.serenegiant.widget.CheckableEx;
import com.serenegiant.widget.Touchable;

public class CheckableRelativeLayout
extends RelativeLayout
implements CheckableEx,
Touchable {
    private boolean mIsChecked;
    private float mTouchX;
    private float mTouchY;

    public CheckableRelativeLayout(Context context) {
        this(context, null);
    }

    public CheckableRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean isChecked() {
        return this.mIsChecked;
    }

    public void setChecked(boolean checked) {
        if (this.mIsChecked != checked) {
            this.mIsChecked = checked;
            this.updateChildState((ViewGroup)this, checked);
            this.refreshDrawableState();
        }
    }

    protected void updateChildState(ViewGroup group, boolean checked) {
        int n = group.getChildCount();
        for (int i = 0; i < n; ++i) {
            View child = group.getChildAt(i);
            if (!(child instanceof Checkable)) continue;
            ((Checkable)child).setChecked(checked);
        }
    }

    public void toggle() {
        this.setChecked(!this.mIsChecked);
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            CheckableRelativeLayout.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.mTouchX = ev.getX();
        this.mTouchY = ev.getY();
        return super.onInterceptTouchEvent(ev);
    }

    @Override
    public float touchX() {
        return this.mTouchX;
    }

    @Override
    public float touchY() {
        return this.mTouchY;
    }
}

