/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.view;

import android.util.Log;
import android.view.View;
import android.view.animation.Animation;
import androidx.annotation.IdRes;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.serenegiant.common.R;
import com.serenegiant.view.ViewUtils;
import com.serenegiant.view.animation.ResizeAnimation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ViewSlider {
    private static final boolean DEBUG = false;
    private static final String TAG = ViewSlider.class.getSimpleName();
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int DEFAULT_DURATION_RESIZE_MS = 300;
    @NonNull
    private final View mParent;
    @NonNull
    private final View mTarget;
    private final int mDurationResizeMs;
    private int mTargetMaxWidth;
    private int mTargetMaxHeight;
    private int mTargetMinWidth;
    private int mTargetMinHeight;
    private int mOrientation;
    private final View.OnLayoutChangeListener mOnLayoutChangeListener = new View.OnLayoutChangeListener(){

        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            if (v == ViewSlider.this.mTarget) {
                if (ViewSlider.this.mTargetMaxWidth <= 0) {
                    ViewSlider.this.mTargetMaxWidth = v.getWidth();
                }
                if (ViewSlider.this.mTargetMaxHeight <= 0) {
                    ViewSlider.this.mTargetMaxHeight = v.getHeight();
                }
            }
        }
    };
    private final Animation.AnimationListener mAnimationListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            Object visibility = ViewSlider.this.mTarget.getTag(R.id.visibility);
            if (visibility instanceof Integer && (Integer)visibility == 1) {
                long duration;
                ViewSlider.this.mTarget.setTag(R.id.visibility, (Object)0);
                Object durationObj = ViewSlider.this.mTarget.getTag(R.id.auto_hide_duration);
                long l = duration = durationObj instanceof Long ? (Long)durationObj : 0L;
                if (duration > 0L) {
                    ViewSlider.this.mTarget.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ViewSlider.this.hide(ViewSlider.this.mDurationResizeMs);
                        }
                    }, duration);
                }
            } else {
                ViewSlider.this.mTarget.setVisibility(4);
            }
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };

    public ViewSlider(@NonNull View parent, @IdRes int viewId) throws IllegalArgumentException {
        this(parent, viewId, 0, 300);
    }

    public ViewSlider(@NonNull View parent, @IdRes int viewId, int orientation) throws IllegalArgumentException {
        this(parent, viewId, orientation, 300);
    }

    public ViewSlider(@NonNull View parent, @IdRes int viewId, int orientation, int resizeDuration) throws IllegalArgumentException {
        this(parent, parent.findViewById(viewId), orientation, resizeDuration);
    }

    public ViewSlider(@NonNull View parent, @NonNull View target, int orientation, int resizeDuration) throws IllegalArgumentException {
        this.mParent = parent;
        if (parent.getClass().getSimpleName().equals("ConstraintLayout")) {
            Log.w((String)TAG, (String)"If parent is ConstraintLayout, ViewSlider will not work well.");
        }
        this.mTarget = target;
        if (this.mTarget == null) {
            throw new IllegalArgumentException("Target view not found");
        }
        this.mDurationResizeMs = resizeDuration > 0 ? resizeDuration : 300;
        this.mOrientation = orientation;
        this.mTargetMaxWidth = this.mTarget.getWidth();
        this.mTargetMaxHeight = this.mTarget.getHeight();
        this.mTargetMinHeight = 0;
        this.mTargetMinWidth = 0;
        this.mParent.addOnLayoutChangeListener(this.mOnLayoutChangeListener);
        this.mTarget.addOnLayoutChangeListener(this.mOnLayoutChangeListener);
        if (this.mTarget.getVisibility() == 8) {
            this.mTarget.setVisibility(4);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public void release() {
        this.mTarget.clearAnimation();
        this.mTarget.removeOnLayoutChangeListener(this.mOnLayoutChangeListener);
        this.mParent.removeOnLayoutChangeListener(this.mOnLayoutChangeListener);
    }

    @NonNull
    public View getTargetView() {
        return this.mTarget;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    public void setTargetWidth(@IntRange(from=0L) int width) throws IllegalArgumentException {
        if (width < 0) {
            throw new IllegalArgumentException();
        }
        this.mTargetMaxWidth = width;
    }

    public void setTargetHeight(@IntRange(from=0L) int height) throws IllegalArgumentException {
        if (height < 0) {
            throw new IllegalArgumentException();
        }
        this.mTargetMaxHeight = height;
    }

    public void resetTargetSize() {
        this.setTargetSize(this.mTarget.getWidth(), this.mTarget.getHeight());
    }

    public void setTargetSize(@IntRange(from=0L) int width, @IntRange(from=0L) int height) throws IllegalArgumentException {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException();
        }
        this.mTargetMaxWidth = width;
        this.mTargetMaxHeight = height;
    }

    public void setMinSize(@IntRange(from=0L) int width, @IntRange(from=0L) int height) throws IllegalArgumentException {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException();
        }
        this.mTargetMinWidth = width;
        this.mTargetMinHeight = height;
    }

    public int getVisibility() {
        return this.mTarget.getVisibility();
    }

    public boolean isVisible() {
        return this.mTarget.getVisibility() == 0 && this.mTarget.getWidth() > 0 && this.mTarget.getHeight() > 0;
    }

    public void show(final long autoHideDurationMs) {
        this.mTarget.post(new Runnable(){

            @Override
            public void run() {
                ViewSlider.this.mTarget.clearAnimation();
                final ResizeAnimation expandAnimation = ViewSlider.this.mOrientation == 0 ? new ResizeAnimation(ViewSlider.this.mTarget, ViewSlider.this.mTargetMaxWidth, ViewSlider.this.mTargetMinHeight, ViewSlider.this.mTargetMaxWidth, ViewSlider.this.mTargetMaxHeight) : new ResizeAnimation(ViewSlider.this.mTarget, ViewSlider.this.mTargetMinWidth, ViewSlider.this.mTargetMaxHeight, ViewSlider.this.mTargetMaxWidth, ViewSlider.this.mTargetMaxHeight);
                expandAnimation.setDuration(ViewSlider.this.mDurationResizeMs);
                expandAnimation.setAnimationListener(ViewSlider.this.mAnimationListener);
                ViewSlider.this.mTarget.setTag(R.id.visibility, (Object)1);
                ViewSlider.this.mTarget.setTag(R.id.auto_hide_duration, (Object)autoHideDurationMs);
                ViewSlider.this.mTarget.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ViewSlider.this.mTarget.setVisibility(0);
                        ViewSlider.this.mTarget.startAnimation((Animation)expandAnimation);
                    }
                }, 50L);
            }
        });
    }

    public void hide() {
        this.hide(this.mDurationResizeMs);
    }

    public void hide(final long durationMs) {
        this.mTarget.post(new Runnable(){

            @Override
            public void run() {
                if (ViewSlider.this.mTarget.getVisibility() == 0) {
                    ViewSlider.this.mTarget.clearAnimation();
                    if (durationMs > 0L) {
                        ResizeAnimation collapseAnimation = ViewSlider.this.mOrientation == 0 ? new ResizeAnimation(ViewSlider.this.mTarget, ViewSlider.this.mTargetMaxWidth, ViewSlider.this.mTarget.getHeight(), ViewSlider.this.mTargetMaxWidth, ViewSlider.this.mTargetMinHeight) : new ResizeAnimation(ViewSlider.this.mTarget, ViewSlider.this.mTarget.getWidth(), ViewSlider.this.mTargetMaxHeight, ViewSlider.this.mTargetMinWidth, ViewSlider.this.mTargetMaxHeight);
                        collapseAnimation.setDuration(durationMs);
                        collapseAnimation.setAnimationListener(ViewSlider.this.mAnimationListener);
                        ViewSlider.this.mTarget.setTag(R.id.visibility, (Object)0);
                        ViewSlider.this.mTarget.startAnimation((Animation)collapseAnimation);
                    } else {
                        if (ViewSlider.this.mOrientation == 0) {
                            ViewUtils.requestResize(ViewSlider.this.mTarget, ViewSlider.this.mTargetMaxWidth, ViewSlider.this.mTargetMinHeight);
                        } else {
                            ViewUtils.requestResize(ViewSlider.this.mTarget, ViewSlider.this.mTargetMinWidth, ViewSlider.this.mTargetMaxHeight);
                        }
                        ViewSlider.this.mTarget.setVisibility(4);
                    }
                }
            }
        });
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }
}

