/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb;

import android.annotation.SuppressLint;
import android.content.Context;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.ContextUtils;
import com.serenegiant.usb.Const;
import com.serenegiant.usb.UsbUtils;
import com.serenegiant.usb.UsbVendorId;

public class UsbDeviceInfo
implements Const,
Parcelable {
    private static final boolean DEBUG = false;
    private static final String TAG = UsbDeviceInfo.class.getSimpleName();
    @Nullable
    public UsbDevice device;
    @Nullable
    public String usb_version;
    @Nullable
    public String manufacturer;
    @Nullable
    public String product;
    @Nullable
    public String version;
    @Nullable
    public String serial;
    public int configCounts;
    public static final Parcelable.Creator<UsbDeviceInfo> CREATOR = new Parcelable.Creator<UsbDeviceInfo>(){

        public UsbDeviceInfo createFromParcel(@NonNull Parcel in) {
            return new UsbDeviceInfo(in);
        }

        public UsbDeviceInfo[] newArray(int size) {
            return new UsbDeviceInfo[size];
        }
    };

    @NonNull
    public static UsbDeviceInfo getDeviceInfo(@NonNull Context context, @Nullable UsbDevice device) {
        return UsbDeviceInfo.getDeviceInfo(ContextUtils.requireSystemService(context, UsbManager.class), device, new UsbDeviceInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static UsbDeviceInfo getDeviceInfo(@NonNull UsbManager manager, @Nullable UsbDevice device, @Nullable UsbDeviceInfo out) {
        try (UsbDeviceConnection connection = device != null && manager.hasPermission(device) ? manager.openDevice(device) : null;){
            UsbDeviceInfo usbDeviceInfo = UsbDeviceInfo.getDeviceInfo(connection, device, out);
            return usbDeviceInfo;
        }
    }

    @SuppressLint(value={"NewApi"})
    @NonNull
    public static UsbDeviceInfo getDeviceInfo(@Nullable UsbDeviceConnection connection, @Nullable UsbDevice device, @Nullable UsbDeviceInfo out) {
        UsbDeviceInfo result = out != null ? out : new UsbDeviceInfo();
        result.clear();
        result.device = device;
        if (device != null) {
            byte[] desc;
            if (BuildCheck.isAPI29() && connection != null) {
                result.manufacturer = device.getManufacturerName();
                result.product = device.getProductName();
                result.configCounts = device.getConfigurationCount();
            } else if (BuildCheck.isLollipop()) {
                result.manufacturer = device.getManufacturerName();
                result.product = device.getProductName();
                result.serial = device.getSerialNumber();
                result.configCounts = device.getConfigurationCount();
            }
            if (BuildCheck.isMarshmallow()) {
                result.version = device.getVersion();
            }
            if (connection != null && (desc = connection.getRawDescriptors()) != null) {
                if (TextUtils.isEmpty((CharSequence)result.usb_version)) {
                    result.usb_version = String.format("%x.%02x", desc[3] & 0xFF, desc[2] & 0xFF);
                }
                if (TextUtils.isEmpty((CharSequence)result.version)) {
                    result.version = String.format("%x.%02x", desc[13] & 0xFF, desc[12] & 0xFF);
                }
                if (BuildCheck.isAPI29()) {
                    try {
                        result.serial = device.getSerialNumber();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (TextUtils.isEmpty((CharSequence)result.serial)) {
                    result.serial = connection.getSerial();
                }
                if (result.configCounts < 0) {
                    result.configCounts = 1;
                }
                byte[] languages = new byte[256];
                int languageCount = 0;
                int res = connection.controlTransfer(128, 6, 768, 0, languages, 256, 0);
                if (res > 0) {
                    languageCount = (res - 2) / 2;
                }
                if (languageCount > 0) {
                    if (TextUtils.isEmpty((CharSequence)result.manufacturer)) {
                        result.manufacturer = UsbUtils.getString(connection, desc[14], languageCount, languages);
                    }
                    if (TextUtils.isEmpty((CharSequence)result.product)) {
                        result.product = UsbUtils.getString(connection, desc[15], languageCount, languages);
                    }
                    if (TextUtils.isEmpty((CharSequence)result.serial)) {
                        result.serial = UsbUtils.getString(connection, desc[16], languageCount, languages);
                    }
                }
            }
            if (TextUtils.isEmpty((CharSequence)result.manufacturer)) {
                result.manufacturer = UsbVendorId.vendorName(device.getVendorId());
            }
            if (TextUtils.isEmpty((CharSequence)result.manufacturer)) {
                result.manufacturer = String.format("%04x", device.getVendorId());
            }
            if (TextUtils.isEmpty((CharSequence)result.product)) {
                result.product = String.format("%04x", device.getProductId());
            }
        }
        return result;
    }

    public UsbDeviceInfo() {
        this.configCounts = -1;
    }

    public UsbDeviceInfo(@NonNull Parcel in) {
        this.device = (UsbDevice)in.readParcelable(UsbDevice.class.getClassLoader());
        this.usb_version = in.readString();
        this.manufacturer = in.readString();
        this.product = in.readString();
        this.version = in.readString();
        this.serial = in.readString();
        this.configCounts = in.readInt();
    }

    private void clear() {
        this.device = null;
        this.serial = null;
        this.version = null;
        this.product = null;
        this.manufacturer = null;
        this.usb_version = null;
        this.configCounts = -1;
    }

    @NonNull
    public String toString() {
        return String.format("UsbDeviceInfo:usb_version=%s,manufacturer=%s,product=%s,version=%s,serial=%s,configCounts=%s", this.usb_version != null ? this.usb_version : "", this.manufacturer != null ? this.manufacturer : "", this.product != null ? this.product : "", this.version != null ? this.version : "", this.serial != null ? this.serial : "", this.configCounts >= 0 ? Integer.toString(this.configCounts) : "");
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.device, flags);
        dest.writeString(this.usb_version);
        dest.writeString(this.manufacturer);
        dest.writeString(this.product);
        dest.writeString(this.version);
        dest.writeString(this.serial);
        dest.writeInt(this.configCounts);
    }
}

