/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.system;

import android.util.Log;
import androidx.annotation.NonNull;

public class Stacktrace {
    private static final String TAG = "Stacktrace";

    private Stacktrace() {
    }

    public static void print() {
        Throwable t = new Throwable();
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] elms = t.getStackTrace();
        boolean top = true;
        if (elms != null) {
            for (StackTraceElement elm : elms) {
                if (!top && elm != null) {
                    sb.append(elm.toString()).append("\n");
                    continue;
                }
                top = false;
            }
        }
        Log.i((String)TAG, (String)sb.toString());
    }

    public static String asString() {
        return Stacktrace.asString(new Throwable());
    }

    public static String asString(Throwable t) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] elms = t.getStackTrace();
        boolean top = true;
        if (elms != null) {
            for (StackTraceElement elm : elms) {
                if (!top && elm != null) {
                    sb.append(elm.toString()).append("\n");
                    continue;
                }
                top = false;
            }
        }
        return sb.toString();
    }

    @NonNull
    public static String callFrom() {
        Throwable t = new Throwable();
        StackTraceElement[] elms = t.getStackTrace();
        int level = 0;
        if (elms != null) {
            for (StackTraceElement elm : elms) {
                if (level > 1 && elm != null) {
                    return elm.toString();
                }
                ++level;
            }
        }
        return "unknown method";
    }
}

