/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.service;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleService;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.serenegiant.common.R;
import com.serenegiant.notification.NotificationFactory;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.ContextUtils;
import com.serenegiant.utils.HandlerThreadHandler;

public abstract class BaseService
extends LifecycleService {
    private static final boolean DEBUG = false;
    private static final String TAG = BaseService.class.getSimpleName();
    private static final int NOTIFICATION_ID = R.string.service_name;
    protected final Object mSync = new Object();
    private final Handler mUIHandler = new Handler(Looper.getMainLooper());
    private Handler mAsyncHandler;
    private LocalBroadcastManager mLocalBroadcastManager;
    private volatile boolean mDestroyed;
    private final BroadcastReceiver mLocalBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                BaseService.this.onReceiveLocalBroadcast(context, intent);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCreate() {
        super.onCreate();
        Context app_context = this.getApplicationContext();
        Object object = this.mSync;
        synchronized (object) {
            this.mLocalBroadcastManager = LocalBroadcastManager.getInstance((Context)this.getApplicationContext());
            IntentFilter filter = this.createIntentFilter();
            if (filter != null && filter.countActions() > 0) {
                this.mLocalBroadcastManager.registerReceiver(this.mLocalBroadcastReceiver, filter);
            }
            if (this.mAsyncHandler == null) {
                this.mAsyncHandler = HandlerThreadHandler.createHandler(((Object)((Object)this)).getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        this.mDestroyed = true;
        Object object = this.mSync;
        synchronized (object) {
            this.mUIHandler.removeCallbacksAndMessages(null);
            if (this.mAsyncHandler != null) {
                this.mAsyncHandler.removeCallbacksAndMessages(null);
                try {
                    this.mAsyncHandler.getLooper().quit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mAsyncHandler = null;
            }
            if (this.mLocalBroadcastManager != null) {
                try {
                    this.mLocalBroadcastManager.unregisterReceiver(this.mLocalBroadcastReceiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mLocalBroadcastManager = null;
            }
        }
        super.onDestroy();
    }

    protected boolean isDestroyed() {
        return this.mDestroyed;
    }

    protected abstract IntentFilter createIntentFilter();

    protected abstract void onReceiveLocalBroadcast(Context var1, Intent var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendLocalBroadcast(Intent intent) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mLocalBroadcastManager != null) {
                this.mLocalBroadcastManager.sendBroadcast(intent);
            }
        }
    }

    protected void showNotification(@DrawableRes int smallIconId, @NonNull CharSequence title, @NonNull CharSequence content, PendingIntent intent) {
        this.showNotification(NOTIFICATION_ID, this.getString(R.string.service_name), null, null, smallIconId, R.drawable.ic_notification, title, content, true, intent);
    }

    protected void showNotification(@DrawableRes int smallIconId, @NonNull CharSequence title, @NonNull CharSequence content, boolean isForegroundService, PendingIntent intent) {
        this.showNotification(NOTIFICATION_ID, this.getString(R.string.service_name), null, null, smallIconId, R.drawable.ic_notification, title, content, isForegroundService, intent);
    }

    protected void showNotification(int notificationId, @NonNull String channelId, @DrawableRes int smallIconId, @DrawableRes int largeIconId, @NonNull CharSequence title, @NonNull CharSequence content, PendingIntent intent) {
        this.showNotification(notificationId, channelId, null, null, smallIconId, largeIconId, title, content, true, intent);
    }

    protected void showNotification(int notificationId, @NonNull String channelId, @Nullable String groupId, @Nullable String groupName, @DrawableRes int smallIconId, @DrawableRes int largeIconId, @NonNull CharSequence title, @NonNull CharSequence content, PendingIntent intent) {
        this.showNotification(notificationId, channelId, groupId, groupName, smallIconId, largeIconId, title, content, true, intent);
    }

    protected void showNotification(int notificationId, @NonNull String channelId, @Nullable String groupId, @Nullable String groupName, @DrawableRes int smallIconId, @DrawableRes int largeIconId, @NonNull CharSequence title, @NonNull CharSequence content, final boolean isForegroundService, final PendingIntent intent) {
        this.showNotification(notificationId, title, content, new NotificationFactory((Context)this, channelId, channelId, 0, groupId, groupName, smallIconId, largeIconId){

            @Override
            public boolean isForegroundService() {
                return isForegroundService;
            }

            @Override
            @Nullable
            protected PendingIntent createContentIntent() {
                return intent;
            }
        });
    }

    protected void showNotification(int notificationId, @NonNull CharSequence title, @NonNull CharSequence content, @NonNull NotificationFactory factory) {
        NotificationManager manager = ContextUtils.requireSystemService((Context)this, NotificationManager.class);
        Notification notification = factory.createNotification(content, title);
        if (factory.isForegroundService()) {
            this.startForeground(notificationId, notification);
        }
        manager.notify(notificationId, notification);
    }

    protected void releaseNotification() {
        this.releaseNotification(NOTIFICATION_ID, this.getString(R.string.service_name), R.drawable.ic_notification, R.drawable.ic_notification, this.getString(R.string.service_name), this.getString(R.string.service_stop));
    }

    @SuppressLint(value={"NewApi"})
    protected void releaseNotification(int notificationId, @NonNull String channelId, @DrawableRes int smallIconId, @DrawableRes int largeIconId, @NonNull CharSequence title, @NonNull CharSequence content) {
        this.showNotification(notificationId, channelId, smallIconId, largeIconId, title, content, null);
        this.releaseNotification(notificationId, channelId);
    }

    @SuppressLint(value={"NewApi"})
    protected void releaseNotification(int notificationId, @NonNull String channelId) {
        this.stopForeground(true);
        this.cancelNotification(notificationId, channelId);
    }

    @SuppressLint(value={"NewApi"})
    protected void cancelNotification(int notificationId, @Nullable String channelId) {
        NotificationManager manager = ContextUtils.requireSystemService((Context)this, NotificationManager.class);
        manager.cancel(notificationId);
        this.releaseNotificationChannel(channelId);
    }

    @SuppressLint(value={"NewApi"})
    protected void cancelNotification(int notificationId) {
        this.cancelNotification(notificationId, null);
    }

    @SuppressLint(value={"NewApi"})
    protected void releaseNotificationChannel(@Nullable String channelId) {
        if (!TextUtils.isEmpty((CharSequence)channelId) && BuildCheck.isOreo()) {
            NotificationManager manager = ContextUtils.requireSystemService((Context)this, NotificationManager.class);
            try {
                manager.deleteNotificationChannel(channelId);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    protected void releaseNotificationGroup(@NonNull String groupId) {
        if (!TextUtils.isEmpty((CharSequence)groupId) && BuildCheck.isOreo()) {
            NotificationManager manager = ContextUtils.requireSystemService((Context)this, NotificationManager.class);
            try {
                manager.deleteNotificationChannelGroup(groupId);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    protected abstract PendingIntent contextIntent();

    protected void runOnUiThread(Runnable task) throws IllegalStateException {
        if (task == null) {
            return;
        }
        if (this.mDestroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mUIHandler.removeCallbacks(task);
        this.mUIHandler.post(task);
    }

    protected void runOnUiThread(@Nullable Runnable task, long delay) throws IllegalStateException {
        if (task == null) {
            return;
        }
        if (this.mDestroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mUIHandler.removeCallbacks(task);
        if (delay > 0L) {
            this.mUIHandler.postDelayed(task, delay);
        } else {
            this.mUIHandler.post(task);
        }
    }

    protected void removeFromUiThread(@Nullable Runnable task) {
        this.mUIHandler.removeCallbacks(task);
    }

    protected void removeFromUiThreadAll(@Nullable Object token) {
        this.mUIHandler.removeCallbacksAndMessages(token);
    }

    protected void queueEvent(@Nullable Runnable task) throws IllegalStateException {
        if (task == null) {
            return;
        }
        if (this.mDestroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.queueEvent(task, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueEvent(@Nullable Runnable task, long delay) throws IllegalStateException {
        if (task == null) {
            return;
        }
        if (this.mDestroyed) {
            throw new IllegalStateException("already destroyed");
        }
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAsyncHandler != null) {
                this.mAsyncHandler.removeCallbacks(task);
                if (delay > 0L) {
                    this.mAsyncHandler.postDelayed(task, delay);
                } else {
                    this.mAsyncHandler.post(task);
                }
            } else {
                throw new IllegalStateException("worker thread is not ready");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEvent(@Nullable Runnable task) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAsyncHandler != null) {
                this.mAsyncHandler.removeCallbacks(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEventAll(@Nullable Object token) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAsyncHandler != null) {
                this.mAsyncHandler.removeCallbacksAndMessages(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Handler getAsyncHandler() throws IllegalStateException {
        if (this.mDestroyed) {
            throw new IllegalStateException("already destroyed");
        }
        Object object = this.mSync;
        synchronized (object) {
            return this.mAsyncHandler;
        }
    }
}

