/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediastore;

import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.mediastore.MediaStoreUtils;
import java.io.IOException;
import java.util.Locale;

public class MediaInfo
implements Parcelable {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaInfo.class.getSimpleName();
    public static final Parcelable.Creator<MediaInfo> CREATOR = new Parcelable.Creator<MediaInfo>(){

        public MediaInfo createFromParcel(Parcel in) {
            return new MediaInfo(in);
        }

        public MediaInfo[] newArray(int size) {
            return new MediaInfo[size];
        }
    };
    public long id;
    public String data;
    public String title;
    public String mime;
    public String displayName;
    public int mediaType;
    public int width;
    public int height;
    public int orientation;

    public MediaInfo() {
    }

    public MediaInfo(@NonNull MediaInfo src) {
        this.id = src.id;
        this.data = src.data;
        this.title = src.title;
        this.mime = src.mime;
        this.displayName = src.displayName;
        this.mediaType = src.mediaType;
        this.width = src.width;
        this.height = src.height;
        this.orientation = src.orientation;
    }

    protected MediaInfo(@NonNull Parcel in) {
        this.id = in.readLong();
        this.data = in.readString();
        this.title = in.readString();
        this.mime = in.readString();
        this.displayName = in.readString();
        this.mediaType = in.readInt();
        this.width = in.readInt();
        this.height = in.readInt();
        this.orientation = in.readInt();
    }

    MediaInfo(@NonNull Cursor cursor) {
        this(cursor, cursor.getInt(7));
    }

    MediaInfo(@NonNull Cursor cursor, int mediaType) {
        this.id = cursor.getLong(0);
        this.data = cursor.getString(3);
        this.title = cursor.getString(1);
        this.mime = cursor.getString(2);
        this.displayName = cursor.getString(4);
        this.mediaType = mediaType;
        try {
            this.width = cursor.getInt(5);
            this.height = cursor.getInt(6);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    MediaInfo loadFromCursor(@NonNull Cursor cursor) {
        return this.loadFromCursor(cursor, cursor.getInt(7));
    }

    MediaInfo loadFromCursor(@NonNull Cursor cursor, int mediaType) {
        this.id = cursor.getLong(0);
        this.data = cursor.getString(3);
        this.title = cursor.getString(1);
        this.mime = cursor.getString(2);
        this.displayName = cursor.getString(4);
        this.mediaType = mediaType;
        try {
            this.width = cursor.getInt(5);
            this.height = cursor.getInt(6);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public MediaInfo set(@NonNull MediaInfo src) {
        this.id = src.id;
        this.data = src.data;
        this.title = src.title;
        this.mime = src.mime;
        this.displayName = src.displayName;
        this.mediaType = src.mediaType;
        this.width = src.width;
        this.height = src.height;
        this.orientation = src.orientation;
        return this;
    }

    @Nullable
    public Uri getUri() {
        return MediaStoreUtils.getUri(this.mediaType, this.id);
    }

    public boolean canRead(@NonNull ContentResolver cr) {
        Uri uri = this.getUri();
        if (uri != null) {
            try {
                ParcelFileDescriptor pfd = cr.openFileDescriptor(uri, "r");
                if (pfd != null) {
                    pfd.close();
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkError(@NonNull ContentResolver cr) throws IOException {
        Uri uri = this.getUri();
        if (uri == null) throw new IOException("Wrong uri");
        ParcelFileDescriptor pfd = cr.openFileDescriptor(uri, "r");
        if (pfd == null) throw new IOException("Failed to open uri");
        try {
            if (pfd.getFd() == 0) {
                throw new IOException("Failed to get fd");
            }
            if (Build.VERSION.SDK_INT < 19) return;
            pfd.checkError();
            return;
        }
        finally {
            pfd.close();
        }
    }

    @NonNull
    public String toString() {
        return "MediaInfo{id=" + this.id + ", data='" + this.data + '\'' + ", title='" + this.title + '\'' + ", mime='" + this.mime + '\'' + ", displayName='" + this.displayName + '\'' + ", mediaType=" + this.mediaType + "(" + MediaInfo.mediaType(this.mediaType) + "), width=" + this.width + ", height=" + this.height + ", orientation=" + this.orientation + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)o;
        if (this.id != mediaInfo.id) {
            return false;
        }
        if (this.mediaType != mediaInfo.mediaType) {
            return false;
        }
        if (this.width != mediaInfo.width) {
            return false;
        }
        if (this.height != mediaInfo.height) {
            return false;
        }
        if (this.orientation != mediaInfo.orientation) {
            return false;
        }
        if (this.data != null ? !this.data.equals(mediaInfo.data) : mediaInfo.data != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(mediaInfo.title) : mediaInfo.title != null) {
            return false;
        }
        if (this.mime != null ? !this.mime.equals(mediaInfo.mime) : mediaInfo.mime != null) {
            return false;
        }
        return this.displayName != null ? this.displayName.equals(mediaInfo.displayName) : mediaInfo.displayName == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.mime != null ? this.mime.hashCode() : 0);
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        result = 31 * result + this.mediaType;
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.orientation;
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeString(this.data);
        dest.writeString(this.title);
        dest.writeString(this.mime);
        dest.writeString(this.displayName);
        dest.writeInt(this.mediaType);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeInt(this.orientation);
    }

    private static String mediaType(int mediaType) {
        switch (mediaType) {
            case 0: {
                return "none";
            }
            case 1: {
                return "image";
            }
            case 2: {
                return "audio";
            }
            case 3: {
                return "video";
            }
            case 4: {
                return "playlist";
            }
            case 5: {
                return "subtitle";
            }
            case 6: {
                return "document";
            }
        }
        return String.format(Locale.US, "unknown:%d", mediaType);
    }
}

