/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediaeffect;

import androidx.annotation.NonNull;
import com.serenegiant.gl.GLSurface;
import com.serenegiant.mediaeffect.ISource;
import com.serenegiant.mediaeffect.MediaEffectGLBase;
import com.serenegiant.mediaeffect.MediaEffectKernel3x3Drawer;

public class MediaEffectGLTwoPassBase
extends MediaEffectGLBase {
    protected final MediaEffectKernel3x3Drawer mDrawer2;
    protected GLSurface mOutputOffscreen2;

    public MediaEffectGLTwoPassBase(int numTex, boolean isOES, String fss) {
        super(numTex, isOES, fss);
        this.mDrawer2 = null;
    }

    public MediaEffectGLTwoPassBase(int numTex, String vss, String fss) {
        super(numTex, false, vss, fss);
        this.mDrawer2 = null;
    }

    public MediaEffectGLTwoPassBase(int numTex, boolean isOES, String vss, String fss) {
        super(numTex, isOES, vss, fss);
        this.mDrawer2 = null;
    }

    public MediaEffectGLTwoPassBase(int numTex, boolean isOES, String vss1, String fss1, String vss2, String fss2) {
        super(numTex, isOES, vss1, fss1);
        this.mDrawer2 = !vss1.equals(vss2) || !fss1.equals(fss2) ? new MediaEffectKernel3x3Drawer(isOES, vss2, fss2) : null;
    }

    @Override
    public void release() {
        if (this.mDrawer2 != null) {
            this.mDrawer2.release();
        }
        if (this.mOutputOffscreen2 != null) {
            this.mOutputOffscreen2.release();
            this.mOutputOffscreen2 = null;
        }
        super.release();
    }

    @Override
    public MediaEffectGLBase resize(int width, int height) {
        super.resize(width, height);
        if (this.mDrawer2 != null) {
            this.mDrawer2.setTexSize(width, height);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(@NonNull int[] src_tex_ids, int width, int height, int out_tex_id) {
        if (!this.mEnabled) {
            return;
        }
        if (this.mOutputOffscreen == null) {
            this.mOutputOffscreen = GLSurface.newInstance(false, width, height, false);
        }
        this.mOutputOffscreen.makeCurrent();
        try {
            this.mDrawer.apply(src_tex_ids, this.mOutputOffscreen.copyTexMatrix(), 0);
        }
        finally {
            this.mOutputOffscreen.swap();
        }
        if (this.mOutputOffscreen2 == null) {
            this.mOutputOffscreen2 = GLSurface.newInstance(false, width, height, false);
        }
        if (out_tex_id != this.mOutputOffscreen2.getTexId() || width != this.mOutputOffscreen2.getWidth() || height != this.mOutputOffscreen2.getHeight()) {
            this.mOutputOffscreen2.assignTexture(out_tex_id, width, height);
        }
        this.mOutputOffscreen2.makeCurrent();
        int[] ids = new int[]{this.mOutputOffscreen.getTexId()};
        try {
            if (this.mDrawer2 != null) {
                this.mDrawer2.apply(ids, this.mOutputOffscreen2.copyTexMatrix(), 0);
            } else {
                this.mDrawer.apply(ids, this.mOutputOffscreen2.copyTexMatrix(), 0);
            }
        }
        finally {
            this.mOutputOffscreen2.swap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(@NonNull int[] src_tex_ids, @NonNull GLSurface output) {
        if (!this.mEnabled) {
            return;
        }
        if (this.mOutputOffscreen == null) {
            this.mOutputOffscreen = GLSurface.newInstance(false, output.getWidth(), output.getHeight(), false);
        }
        this.mOutputOffscreen.makeCurrent();
        try {
            this.mDrawer.apply(src_tex_ids, this.mOutputOffscreen.copyTexMatrix(), 0);
        }
        finally {
            this.mOutputOffscreen.swap();
        }
        output.makeCurrent();
        int[] ids = new int[]{this.mOutputOffscreen.getTexId()};
        try {
            if (this.mDrawer2 != null) {
                this.mDrawer2.apply(ids, output.copyTexMatrix(), 0);
            } else {
                this.mDrawer.apply(ids, output.copyTexMatrix(), 0);
            }
        }
        finally {
            output.swap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(ISource src) {
        if (!this.mEnabled) {
            return;
        }
        GLSurface output_tex = src.getOutputTexture();
        int[] src_tex_ids = src.getSourceTexId();
        int width = src.getWidth();
        int height = src.getHeight();
        if (this.mOutputOffscreen == null) {
            this.mOutputOffscreen = GLSurface.newInstance(false, width, height, false);
        }
        this.mOutputOffscreen.makeCurrent();
        try {
            this.mDrawer.apply(src_tex_ids, this.mOutputOffscreen.copyTexMatrix(), 0);
        }
        finally {
            this.mOutputOffscreen.swap();
        }
        output_tex.makeCurrent();
        int[] ids = new int[]{this.mOutputOffscreen.getTexId()};
        try {
            if (this.mDrawer2 != null) {
                this.mDrawer2.apply(ids, output_tex.copyTexMatrix(), 0);
            } else {
                this.mDrawer.apply(ids, output_tex.copyTexMatrix(), 0);
            }
        }
        finally {
            output_tex.swap();
        }
    }
}

