/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.serenegiant.media.IRecycleBuffer;
import com.serenegiant.media.IRecycleParent;
import com.serenegiant.media.MediaData;
import java.lang.ref.WeakReference;
import java.nio.ByteOrder;

public class RecycleMediaData
extends MediaData
implements IRecycleBuffer {
    @NonNull
    private final WeakReference<IRecycleParent<RecycleMediaData>> mWeakParent;

    public RecycleMediaData(@NonNull IRecycleParent<RecycleMediaData> parent) {
        this.mWeakParent = new WeakReference<IRecycleParent<RecycleMediaData>>(parent);
    }

    public RecycleMediaData(@NonNull IRecycleParent<RecycleMediaData> parent, @IntRange(from=1L) int size) {
        super(size);
        this.mWeakParent = new WeakReference<IRecycleParent<RecycleMediaData>>(parent);
    }

    public RecycleMediaData(@NonNull IRecycleParent<RecycleMediaData> parent, @NonNull ByteOrder order) {
        super(order);
        this.mWeakParent = new WeakReference<IRecycleParent<RecycleMediaData>>(parent);
    }

    public RecycleMediaData(@NonNull IRecycleParent<RecycleMediaData> parent, int size, @NonNull ByteOrder order) {
        super(size, order);
        this.mWeakParent = new WeakReference<IRecycleParent<RecycleMediaData>>(parent);
    }

    public RecycleMediaData(@NonNull RecycleMediaData src) {
        super(src);
        this.mWeakParent = new WeakReference<IRecycleParent>((IRecycleParent)src.mWeakParent.get());
    }

    @Override
    public void recycle() {
        IRecycleParent parent = (IRecycleParent)this.mWeakParent.get();
        if (parent != null) {
            parent.recycle(this);
        }
    }
}

