/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.MediaCodec;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;
import com.serenegiant.media.Encoder;
import com.serenegiant.media.IAudioEncoder;
import com.serenegiant.media.IMuxer;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.Recorder;
import com.serenegiant.media.VideoConfig;
import com.serenegiant.system.StorageInfo;
import com.serenegiant.system.StorageUtils;
import com.serenegiant.utils.FileUtils;
import com.serenegiant.utils.UriHelper;
import java.io.IOException;
import java.nio.ByteBuffer;

@SuppressLint(value={"NewApi"})
public class MediaAVTimelapseRecorder
extends Recorder {
    private static final boolean DEBUG = true;
    private static final String TAG = MediaAVTimelapseRecorder.class.getSimpleName();
    private static final long DEFAULT_FRAME_INTERVALS_US = 33333L;
    private final String mOutputPath;
    @NonNull
    private final DocumentFile mOutputFile;
    private long mFrameIntervalsUs = 33333L;
    private long mFrameCounts;

    public MediaAVTimelapseRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, @NonNull DocumentFile output) throws IOException {
        this(context, callback, null, null, output);
    }

    public MediaAVTimelapseRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, @Nullable IMuxer.IMuxerFactory factory, @NonNull DocumentFile output) throws IOException {
        this(context, callback, null, factory, output);
    }

    public MediaAVTimelapseRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, @Nullable VideoConfig config, @Nullable IMuxer.IMuxerFactory factory, @NonNull DocumentFile output) throws IOException {
        super(context, callback, config, factory);
        this.mOutputFile = output;
        this.mOutputPath = UriHelper.getPath(context, output.getUri());
        VideoConfig _config = this.getConfig();
        if (_config.getCaptureFps().asDouble() >= 0.0) {
            this.mFrameIntervalsUs = Math.round(1000000.0 / _config.getCaptureFps().asDouble());
        }
        if (this.mFrameIntervalsUs < 0L) {
            this.mFrameIntervalsUs = 33333L;
        }
        this.setMuxer(this.getMuxerFactory().createMuxer(context, this.getConfig().useMediaMuxer(), output));
    }

    @Override
    public synchronized void addEncoder(Encoder encoder) throws UnsupportedOperationException {
        if (encoder instanceof IAudioEncoder || encoder.isAudio()) {
            throw new UnsupportedOperationException("MediaAVTimelapseRecorder only support video encoder!");
        }
        super.addEncoder(encoder);
    }

    @Override
    @Deprecated
    @Nullable
    public String getOutputPath() {
        return this.mOutputPath;
    }

    @Override
    @Nullable
    public DocumentFile getOutputFile() {
        return this.mOutputFile;
    }

    @Override
    protected boolean check() {
        Context context = this.requireContext();
        try {
            StorageInfo info = StorageUtils.getStorageInfo(context, this.mOutputFile);
            if (info.totalBytes != 0L) {
                return (float)info.freeBytes / (float)info.totalBytes < FileUtils.FREE_RATIO || (float)info.freeBytes < FileUtils.FREE_SIZE;
            }
        }
        catch (IOException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        return context == null || !FileUtils.checkFreeSpace(context, this.getConfig().maxDuration(), this.mStartTime, 0);
    }

    @Override
    public void writeSampleData(int trackIndex, @NonNull ByteBuffer byteBuf, @NonNull MediaCodec.BufferInfo bufferInfo) {
        bufferInfo.presentationTimeUs = this.getInputPTSUs(trackIndex);
        super.writeSampleData(trackIndex, byteBuf, bufferInfo);
    }

    private long getInputPTSUs(int trackIndex) {
        if (this.mFrameCounts % 100L == 0L) {
            Log.v((String)TAG, (String)("getInputPTSUs:" + this.mFrameCounts));
        }
        if (this.mFrameIntervalsUs <= 0L) {
            this.mFrameIntervalsUs = 33333L;
        }
        return this.mFrameCounts++ * this.mFrameIntervalsUs;
    }
}

