/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.AudioTrack;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.media.AbstractDecoder;
import com.serenegiant.media.DecoderListener;
import com.serenegiant.system.BuildCheck;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AudioDecoder
extends AbstractDecoder {
    private static final boolean DEBUG = false;
    private static final String TAG = AudioDecoder.class.getSimpleName();
    private boolean mHasAudio;
    @Nullable
    protected AudioTrack mAudioTrack;
    protected int mAudioInputBufSize;

    @NonNull
    public static AudioDecoder createDecoder(@NonNull DecoderListener listener) {
        if (BuildCheck.isAPI21()) {
            return new AudioDecoderAPI21(listener);
        }
        return new AudioDecoderAPI16(listener);
    }

    private AudioDecoder(@NonNull DecoderListener listener) {
        super("audio/", listener);
    }

    @Override
    protected void internalPrepare(int trackIndex, @NonNull MediaFormat format) {
        int audioChannels = format.getInteger("channel-count");
        int audioSampleRate = format.getInteger("sample-rate");
        int min_buf_size = AudioTrack.getMinBufferSize((int)audioSampleRate, (int)(audioChannels == 1 ? 4 : 12), (int)2);
        int max_input_size = format.getInteger("max-input-size");
        int n = this.mAudioInputBufSize = min_buf_size > 0 ? min_buf_size * 4 : max_input_size;
        if (this.mAudioInputBufSize > max_input_size) {
            this.mAudioInputBufSize = max_input_size;
        }
        int frameSizeInBytes = audioChannels * 2;
        this.mAudioInputBufSize = this.mAudioInputBufSize / frameSizeInBytes * frameSizeInBytes;
        this.mAudioTrack = new AudioTrack(3, audioSampleRate, audioChannels == 1 ? 4 : 12, 2, this.mAudioInputBufSize, 1);
        try {
            this.mAudioTrack.play();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"failed to start audio track playing", (Throwable)e);
            this.mAudioTrack.release();
            this.mAudioTrack = null;
        }
    }

    @Override
    protected MediaCodec createDecoder(int trackIndex, @NonNull MediaFormat format) throws IOException {
        MediaCodec codec = null;
        if (trackIndex >= 0) {
            String mime = format.getString("mime");
            try {
                codec = MediaCodec.createDecoderByType((String)mime);
                codec.configure(format, null, null, 0);
                codec.start();
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        return codec;
    }

    @TargetApi(value=21)
    private static class AudioDecoderAPI21
    extends AudioDecoder {
        private static final String TAG = AudioDecoderAPI21.class.getSimpleName();

        private AudioDecoderAPI21(@NonNull DecoderListener listener) {
            super(listener);
        }

        @Override
        public void decode(@NonNull MediaExtractor extractor) {
            if (this.mDecoder != null) {
                this.decodeAPI21(extractor, this.mDecoder);
            }
        }

        @Override
        protected AbstractDecoder.OutputTask createOutputTask(int trackIndex) {
            return new AbstractDecoder.OutputTask(trackIndex){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void handleOutput(@NonNull MediaCodec decoder) {
                    while (this.isRunning() && !mOutputDone) {
                        int decoderStatus = decoder.dequeueOutputBuffer(mBufferInfo, 10000L);
                        if (decoderStatus == -1) {
                            return;
                        }
                        if (decoderStatus == -3 || decoderStatus == -2) continue;
                        if (decoderStatus < 0) {
                            throw new RuntimeException("unexpected result from audio decoder.dequeueOutputBuffer: " + decoderStatus);
                        }
                        int size = mBufferInfo.size;
                        if (size > 0) {
                            ByteBuffer out = decoder.getOutputBuffer(decoderStatus);
                            out.clear();
                            if (mAudioTrack != null) {
                                mAudioTrack.write(out, size, 0);
                            }
                            if (!this.onFrameAvailable(mBufferInfo.presentationTimeUs)) {
                                this.adjustPresentationTime(mBufferInfo.presentationTimeUs);
                            }
                        }
                        decoder.releaseOutputBuffer(decoderStatus, false);
                        if ((mBufferInfo.flags & 4) == 0) continue;
                        Object object = mSync;
                        synchronized (object) {
                            mOutputDone = true;
                            mSync.notifyAll();
                        }
                    }
                }
            };
        }
    }

    private static class AudioDecoderAPI16
    extends AudioDecoder {
        private static final String TAG = AudioDecoderAPI16.class.getSimpleName();
        @Nullable
        private ByteBuffer[] mInputBuffers;
        @Nullable
        private ByteBuffer[] mOutputBuffers;
        protected byte[] mAudioOutTempBuf;

        private AudioDecoderAPI16(@NonNull DecoderListener listener) {
            super(listener);
        }

        @Override
        protected MediaCodec createDecoder(int trackIndex, @NonNull MediaFormat format) throws IOException {
            MediaCodec codec = super.createDecoder(trackIndex, format);
            this.mInputBuffers = codec.getInputBuffers();
            this.mOutputBuffers = codec.getOutputBuffers();
            int sz = this.mOutputBuffers[0].capacity();
            if (sz <= 0) {
                sz = this.mAudioInputBufSize;
            }
            this.mAudioOutTempBuf = new byte[sz];
            return codec;
        }

        @Override
        public void decode(@NonNull MediaExtractor extractor) {
            if (this.mDecoder != null) {
                this.decodeAPI16(extractor, this.mDecoder, this.mInputBuffers);
            }
        }

        @Override
        protected AbstractDecoder.OutputTask createOutputTask(int trackIndex) {
            return new AbstractDecoder.OutputTask(trackIndex){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void handleOutput(@NonNull MediaCodec decoder) {
                    while (this.isRunning() && !mOutputDone) {
                        int decoderStatus = decoder.dequeueOutputBuffer(mBufferInfo, 10000L);
                        if (decoderStatus == -1) {
                            return;
                        }
                        if (decoderStatus == -3) {
                            AudioDecoderAPI16.access$302(this, decoder.getOutputBuffers());
                            continue;
                        }
                        if (decoderStatus == -2) continue;
                        if (decoderStatus < 0) {
                            throw new RuntimeException("unexpected result from audio decoder.dequeueOutputBuffer: " + decoderStatus);
                        }
                        int size = mBufferInfo.size;
                        if (size > 0) {
                            ByteBuffer buffer = mOutputBuffers[decoderStatus];
                            if (mAudioOutTempBuf == null || mAudioOutTempBuf.length < size) {
                                mAudioOutTempBuf = new byte[size * 3 / 2];
                            }
                            buffer.position(0);
                            buffer.get(mAudioOutTempBuf, 0, size);
                            buffer.clear();
                            if (mAudioTrack != null) {
                                mAudioTrack.write(mAudioOutTempBuf, 0, size);
                            }
                            if (!this.onFrameAvailable(mBufferInfo.presentationTimeUs)) {
                                this.adjustPresentationTime(mBufferInfo.presentationTimeUs);
                            }
                        }
                        decoder.releaseOutputBuffer(decoderStatus, false);
                        if ((mBufferInfo.flags & 4) == 0) continue;
                        Object object = mSync;
                        synchronized (object) {
                            mOutputDone = true;
                            mSync.notifyAll();
                        }
                    }
                }
            };
        }

        static /* synthetic */ ByteBuffer[] access$302(AudioDecoderAPI16 x0, ByteBuffer[] x1) {
            x0.mOutputBuffers = x1;
            return x1;
        }
    }
}

