/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glpipeline;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.view.Surface;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLManager;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.gl.RendererTarget;
import com.serenegiant.glpipeline.DistributePipeline;
import com.serenegiant.glpipeline.GLPipeline;
import com.serenegiant.math.Fraction;
import com.serenegiant.media.AbstractVideoEncoder;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.MediaCodecUtils;
import com.serenegiant.media.MediaReaper;

@TargetApi(value=18)
public class EncodePipeline
extends AbstractVideoEncoder
implements GLPipeline {
    private static final boolean DEBUG = false;
    private static final String TAG = EncodePipeline.class.getSimpleName();
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final GLManager mManager;
    @Nullable
    private GLPipeline mParent;
    @Nullable
    private GLPipeline mPipeline;
    private volatile boolean mReleased;
    @Nullable
    private GLDrawer2D mDrawer;
    @Nullable
    private RendererTarget mRendererTarget;
    private int cnt;

    public EncodePipeline(@NonNull GLManager manager, @NonNull IRecorder recorder, @NonNull EncoderListener listener) {
        super("video/avc", recorder, listener);
        this.mManager = manager;
    }

    @Override
    public final void release() {
        if (!this.mReleased) {
            this.mReleased = true;
            this.internalRelease();
        }
        super.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallSuper
    protected void internalRelease() {
        GLPipeline pipeline;
        this.mReleased = true;
        this.releaseTarget();
        Object object = this.mSync;
        synchronized (object) {
            pipeline = this.mPipeline;
            this.mPipeline = null;
            this.mParent = null;
        }
        if (pipeline != null) {
            pipeline.release();
        }
    }

    @Override
    public void resize(int width, int height) throws IllegalStateException {
        this.setVideoSize(width, height);
        GLPipeline pipeline = this.getPipeline();
        if (pipeline != null) {
            pipeline.resize(width, height);
        }
    }

    @Override
    public boolean isValid() {
        return !this.mReleased && this.mManager.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        Object object = this.mSync;
        synchronized (object) {
            return !this.mReleased && this.mParent != null || this.mPipeline != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParent(@Nullable GLPipeline parent) {
        Object object = this.mSync;
        synchronized (object) {
            this.mParent = parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public GLPipeline getParent() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mParent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPipeline(@Nullable GLPipeline pipeline) {
        Object object = this.mSync;
        synchronized (object) {
            this.mPipeline = pipeline;
        }
        if (pipeline != null) {
            pipeline.setParent(this);
            pipeline.resize(this.mWidth, this.mHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public GLPipeline getPipeline() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mPipeline;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        GLPipeline parent;
        Object object = this.mSync;
        synchronized (object) {
            parent = this.mParent;
            if (this.mParent instanceof DistributePipeline) {
                ((DistributePipeline)this.mParent).removePipeline(this);
            } else if (this.mParent != null) {
                this.mParent.setPipeline(this.mPipeline);
            }
            this.mParent = null;
            this.mPipeline = null;
        }
        if (parent != null) {
            parent = GLPipeline.findFirst(parent);
            parent.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void onFrameAvailable(boolean isOES, int texId, @NonNull @Size(min=16L) float[] texMatrix) {
        RendererTarget target;
        GLDrawer2D drawer;
        GLPipeline pipeline;
        Object object = this.mSync;
        synchronized (object) {
            pipeline = this.mPipeline;
            if (this.mDrawer == null || isOES != this.mDrawer.isOES()) {
                if (this.mDrawer != null) {
                    this.mDrawer.release();
                }
                this.mDrawer = GLDrawer2D.create(this.mManager.isGLES3(), isOES);
            }
            drawer = this.mDrawer;
            target = this.mRendererTarget;
        }
        if (pipeline != null) {
            pipeline.onFrameAvailable(isOES, texId, texMatrix);
        }
        if (!this.mReleased && !this.mRequestStop && target != null && target.canDraw()) {
            target.draw(drawer, 33984, texId, texMatrix);
        }
        this.frameAvailableSoon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        GLPipeline pipeline;
        Object object = this.mSync;
        synchronized (object) {
            pipeline = this.mPipeline;
        }
        if (pipeline != null) {
            pipeline.refresh();
        }
    }

    private void createTarget(final @NonNull Surface surface, final @Nullable Fraction maxFps) {
        this.mManager.runOnGLThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = EncodePipeline.this.mSync;
                synchronized (object) {
                    if (EncodePipeline.this.mRendererTarget != null && EncodePipeline.this.mRendererTarget.getSurface() != surface) {
                        EncodePipeline.this.mRendererTarget.release();
                        EncodePipeline.this.mRendererTarget = null;
                    }
                    if (EncodePipeline.this.mRendererTarget == null && GLUtils.isSupportedSurface(surface)) {
                        EncodePipeline.this.mRendererTarget = RendererTarget.newInstance(EncodePipeline.this.mManager.getEgl(), surface, maxFps != null ? maxFps.asFloat() : 0.0f);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseTarget() {
        RendererTarget target;
        GLDrawer2D drawer;
        Object object = this.mSync;
        synchronized (object) {
            drawer = this.mDrawer;
            this.mDrawer = null;
            target = this.mRendererTarget;
            this.mRendererTarget = null;
        }
        if ((drawer != null || target != null) && this.mManager.isValid()) {
            try {
                this.mManager.runOnGLThread(new Runnable(){

                    @Override
                    @WorkerThread
                    public void run() {
                        if (drawer != null) {
                            drawer.release();
                        }
                        if (target != null) {
                            target.release();
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void stop() {
        this.releaseTarget();
        super.stop();
    }

    @Override
    public int getCaptureFormat() {
        return 0;
    }

    @Override
    protected boolean internalPrepare(@NonNull MediaReaper.ReaperListener listener) throws Exception {
        this.mTrackIndex = -1;
        this.mIsCapturing = true;
        MediaCodecInfo codecInfo = MediaCodecUtils.selectVideoEncoder("video/avc");
        if (codecInfo == null) {
            return true;
        }
        boolean mayFail = this.mWidth >= 1000 || this.mHeight >= 1000;
        MediaFormat format = MediaFormat.createVideoFormat((String)"video/avc", (int)this.mWidth, (int)this.mHeight);
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", this.mBitRate > 0 ? this.mBitRate : this.getConfig().getBitrate(this.mWidth, this.mHeight));
        format.setInteger("frame-rate", this.mFramerate > 0 ? this.mFramerate : this.getConfig().captureFps());
        format.setInteger("i-frame-interval", this.mIFrameIntervals > 0 ? this.mIFrameIntervals : this.getConfig().calcIFrameIntervals());
        this.mMediaCodec = MediaCodec.createEncoderByType((String)"video/avc");
        this.mMediaCodec.configure(format, null, null, 1);
        Surface surface = this.mMediaCodec.createInputSurface();
        this.mMediaCodec.start();
        this.mReaper = new MediaReaper.VideoReaper(this.mMediaCodec, listener, this.mWidth, this.mHeight);
        this.createTarget(surface, this.getConfig().getCaptureFps());
        return mayFail;
    }

    @Override
    public void signalEndOfInputStream() {
        if (this.mMediaCodec != null) {
            this.mMediaCodec.signalEndOfInputStream();
        }
    }
}

