/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.egl;

import android.annotation.SuppressLint;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.opengl.GLES10;
import android.opengl.GLES20;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.serenegiant.egl.EGLBase;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.system.BuildCheck;

@RequiresApi(value=17)
class EGLBase14
extends EGLBase {
    private static final boolean DEBUG = false;
    private static final String TAG = EGLBase14.class.getSimpleName();
    @NonNull
    private static final Context EGL_NO_CONTEXT = EGLBase14.wrap(EGL14.EGL_NO_CONTEXT);
    @NonNull
    private Context mContext = EGL_NO_CONTEXT;
    @NonNull
    private EGLDisplay mEglDisplay = EGL14.EGL_NO_DISPLAY;
    @Nullable
    private Config mEglConfig = null;
    private int mGlVersion = 2;
    private EGLContext mDefaultContext = EGL14.EGL_NO_CONTEXT;
    @NonNull
    private final int[] mSurfaceDimension = new int[2];

    static Context wrap(@NonNull EGLContext context) {
        return new Context(context);
    }

    static Config wrap(@NonNull EGLConfig eglConfig) {
        return new Config(eglConfig);
    }

    static EGLBase createFromCurrentImpl(int maxClientVersion, boolean withDepthBuffer, int stencilBits, boolean isRecordable) {
        Context context = null;
        EGLContext currentContext = EGL14.eglGetCurrentContext();
        EGLSurface currentSurface = EGL14.eglGetCurrentSurface((int)12377);
        if (currentContext != null && currentSurface != null) {
            context = EGLBase14.wrap(currentContext);
        }
        return new EGLBase14(maxClientVersion, context, withDepthBuffer, stencilBits, isRecordable);
    }

    static boolean hasGLThreadImpl() {
        EGLContext currentContext = EGL14.eglGetCurrentContext();
        EGLSurface currentSurface = EGL14.eglGetCurrentSurface((int)12377);
        return currentContext != null && currentSurface != null;
    }

    @Nullable
    static EGLBase.IContext<?> wrapCurrentContextImpl() {
        EGLContext currentContext = EGL14.eglGetCurrentContext();
        EGLSurface currentSurface = EGL14.eglGetCurrentSurface((int)12377);
        if (currentContext != null && currentSurface != null) {
            return EGLBase14.wrapContext(currentContext);
        }
        return null;
    }

    EGLBase14(int maxClientVersion, @Nullable Context sharedContext, boolean withDepthBuffer, int stencilBits, boolean isRecordable) {
        this.init(maxClientVersion, sharedContext, withDepthBuffer, stencilBits, isRecordable);
    }

    EGLBase14(int maxClientVersion, boolean withDepthBuffer, int stencilBits, boolean isRecordable) {
        this.init(maxClientVersion, EGLBase14.wrap(EGL14.eglGetCurrentContext()), withDepthBuffer, stencilBits, isRecordable);
    }

    @Override
    public void release() {
        if (this.mEglDisplay != EGL14.EGL_NO_DISPLAY) {
            this.destroyContext();
            EGL14.eglTerminate((EGLDisplay)this.mEglDisplay);
            EGL14.eglReleaseThread();
        }
        this.mEglDisplay = EGL14.EGL_NO_DISPLAY;
        this.mContext = EGL_NO_CONTEXT;
    }

    @Override
    public EGLBase.IEglSurface createFromSurface(Object nativeWindow) {
        EglSurface result = new EglSurface(this, nativeWindow);
        result.makeCurrent();
        return result;
    }

    @Override
    public EGLBase.IEglSurface createOffscreen(int width, int height) {
        EglSurface result = new EglSurface(this, width, height);
        result.makeCurrent();
        return result;
    }

    @Override
    public EGLBase.IEglSurface wrapCurrent() {
        EglSurface result = new EglSurface(this);
        result.makeCurrent();
        return result;
    }

    @Override
    public String queryString(int what) {
        return EGL14.eglQueryString((EGLDisplay)this.mEglDisplay, (int)what);
    }

    @Override
    public int getGlVersion() {
        return this.mGlVersion;
    }

    @Override
    public boolean isValidContext() {
        return this.mContext.eglContext != EGL14.EGL_NO_CONTEXT;
    }

    @NonNull
    public Context getContext() throws IllegalStateException {
        if (!this.isValidContext()) {
            throw new IllegalStateException();
        }
        return this.mContext;
    }

    @NonNull
    public Config getConfig() {
        if (!this.isValidContext()) {
            throw new IllegalStateException();
        }
        return this.mEglConfig;
    }

    @Override
    public void makeDefault() {
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT)) {
            Log.w((String)"TAG", (String)("makeDefault" + EGL14.eglGetError()));
        }
    }

    @Override
    public void sync() {
        EGL14.eglWaitGL();
        EGL14.eglWaitNative((int)12379);
    }

    @Override
    public void waitGL() {
        EGL14.eglWaitGL();
    }

    @Override
    public void waitNative() {
        EGL14.eglWaitNative((int)12379);
    }

    private void init(int maxClientVersion, @Nullable Context sharedContext, boolean withDepthBuffer, int stencilBits, boolean isRecordable) {
        EGLContext context;
        EGLConfig config;
        block13: {
            if (this.mEglDisplay != EGL14.EGL_NO_DISPLAY) {
                throw new RuntimeException("EGL already set up");
            }
            this.mEglDisplay = EGL14.eglGetDisplay((int)0);
            if (this.mEglDisplay == EGL14.EGL_NO_DISPLAY) {
                throw new RuntimeException("eglGetDisplay failed");
            }
            int[] version = new int[2];
            if (!EGL14.eglInitialize((EGLDisplay)this.mEglDisplay, (int[])version, (int)0, (int[])version, (int)1)) {
                this.mEglDisplay = EGL14.EGL_NO_DISPLAY;
                throw new RuntimeException("eglInitialize failed");
            }
            Context context2 = sharedContext = sharedContext != null ? sharedContext : EGL_NO_CONTEXT;
            if (maxClientVersion >= 3 && (config = this.getConfig(3, withDepthBuffer, stencilBits, isRecordable)) != null) {
                context = this.createContext(sharedContext, config, 3);
                if (EGL14.eglGetError() == 12288) {
                    this.mEglConfig = EGLBase14.wrap(config);
                    this.mContext = EGLBase14.wrap(context);
                    this.mGlVersion = 3;
                }
            }
            if (maxClientVersion >= 2 && !this.isValidContext()) {
                config = this.getConfig(2, withDepthBuffer, stencilBits, isRecordable);
                if (config == null) {
                    throw new RuntimeException("chooseConfig failed");
                }
                try {
                    context = this.createContext(sharedContext, config, 2);
                    this.checkEglError("eglCreateContext");
                    this.mEglConfig = EGLBase14.wrap(config);
                    this.mContext = EGLBase14.wrap(context);
                    this.mGlVersion = 2;
                }
                catch (Exception e) {
                    if (!isRecordable) break block13;
                    config = this.getConfig(2, withDepthBuffer, stencilBits, false);
                    if (config == null) {
                        throw new RuntimeException("chooseConfig failed");
                    }
                    EGLContext context3 = this.createContext(sharedContext, config, 2);
                    this.checkEglError("eglCreateContext");
                    this.mEglConfig = EGLBase14.wrap(config);
                    this.mContext = EGLBase14.wrap(context3);
                    this.mGlVersion = 2;
                }
            }
        }
        if (!this.isValidContext()) {
            config = this.getConfig(1, withDepthBuffer, stencilBits, isRecordable);
            if (config == null) {
                throw new RuntimeException("chooseConfig failed");
            }
            context = this.createContext(sharedContext, config, 1);
            this.checkEglError("eglCreateContext");
            this.mEglConfig = EGLBase14.wrap(config);
            this.mContext = EGLBase14.wrap(context);
            this.mGlVersion = 1;
        }
        int[] values = new int[1];
        EGL14.eglQueryContext((EGLDisplay)this.mEglDisplay, (EGLContext)((EGLContext)this.mContext.eglContext), (int)12440, (int[])values, (int)0);
        if (EGL14.eglGetError() == 12288) {
            Log.d((String)TAG, (String)String.format("EGLContext created, client version %d(request %d) ", values[0], maxClientVersion));
        }
        this.makeDefault();
    }

    private boolean makeCurrent(EGLSurface surface) {
        if (surface == null || surface == EGL14.EGL_NO_SURFACE) {
            int error = EGL14.eglGetError();
            if (error == 12299) {
                Log.e((String)TAG, (String)"makeCurrent:returned EGL_BAD_NATIVE_WINDOW.");
            }
            return false;
        }
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)surface, (EGLSurface)surface, (EGLContext)((EGLContext)this.mContext.eglContext))) {
            Log.w((String)"TAG", (String)("eglMakeCurrent" + EGL14.eglGetError()));
            return false;
        }
        return true;
    }

    private int swap(EGLSurface surface) {
        if (!EGL14.eglSwapBuffers((EGLDisplay)this.mEglDisplay, (EGLSurface)surface)) {
            int err = EGL14.eglGetError();
            return err;
        }
        return 12288;
    }

    @RequiresApi(api=18)
    private int swap(EGLSurface surface, long presentationTimeNs) {
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEglDisplay, (EGLSurface)surface, (long)presentationTimeNs);
        if (!EGL14.eglSwapBuffers((EGLDisplay)this.mEglDisplay, (EGLSurface)surface)) {
            int err = EGL14.eglGetError();
            return err;
        }
        return 12288;
    }

    private EGLContext createContext(Context sharedContext, EGLConfig config, int version) {
        int[] attrib_list = new int[]{12440, version, 12344};
        EGLContext context = EGL14.eglCreateContext((EGLDisplay)this.mEglDisplay, (EGLConfig)config, (EGLContext)((EGLContext)sharedContext.eglContext), (int[])attrib_list, (int)0);
        return context;
    }

    private void destroyContext() {
        EGLContext ctx = (EGLContext)this.mContext.eglContext;
        this.mContext = EGL_NO_CONTEXT;
        if (ctx != EGL14.EGL_NO_CONTEXT && !EGL14.eglDestroyContext((EGLDisplay)this.mEglDisplay, (EGLContext)ctx)) {
            Log.e((String)"destroyContext", (String)("display:" + this.mEglDisplay + " context: " + ctx));
            Log.e((String)TAG, (String)("eglDestroyContext:" + EGL14.eglGetError()));
        }
        if (this.mDefaultContext != EGL14.EGL_NO_CONTEXT) {
            if (!EGL14.eglDestroyContext((EGLDisplay)this.mEglDisplay, (EGLContext)this.mDefaultContext)) {
                Log.e((String)"destroyContext", (String)("display:" + this.mEglDisplay + " context: " + this.mDefaultContext));
                Log.e((String)TAG, (String)("eglDestroyContext:" + EGL14.eglGetError()));
            }
            this.mDefaultContext = EGL14.EGL_NO_CONTEXT;
        }
    }

    private final int getSurfaceWidth(EGLSurface surface) {
        boolean ret = EGL14.eglQuerySurface((EGLDisplay)this.mEglDisplay, (EGLSurface)surface, (int)12375, (int[])this.mSurfaceDimension, (int)0);
        if (!ret) {
            this.mSurfaceDimension[0] = 0;
        }
        return this.mSurfaceDimension[0];
    }

    private final int getSurfaceHeight(EGLSurface surface) {
        boolean ret = EGL14.eglQuerySurface((EGLDisplay)this.mEglDisplay, (EGLSurface)surface, (int)12374, (int[])this.mSurfaceDimension, (int)1);
        if (!ret) {
            this.mSurfaceDimension[1] = 0;
        }
        return this.mSurfaceDimension[1];
    }

    @NonNull
    private final EGLSurface createWindowSurface(Object nativeWindow) throws IllegalArgumentException {
        EGLSurface result;
        int[] surfaceAttribs = new int[]{12344};
        try {
            result = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEglDisplay, (EGLConfig)((EGLConfig)this.mEglConfig.eglConfig), (Object)nativeWindow, (int[])surfaceAttribs, (int)0);
            if (result == null || result == EGL14.EGL_NO_SURFACE) {
                int error = EGL14.eglGetError();
                if (error == 12299) {
                    Log.e((String)TAG, (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                }
                throw new RuntimeException("createWindowSurface failed error=" + error);
            }
            this.makeCurrent(result);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"eglCreateWindowSurface", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    @NonNull
    private final EGLSurface createOffscreenSurface(@IntRange(from=1L) int width, @IntRange(from=1L) int height) throws IllegalArgumentException {
        EGLSurface result;
        int[] surfaceAttribs = new int[]{12375, width, 12374, height, 12344};
        try {
            result = EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEglDisplay, (EGLConfig)((EGLConfig)this.mEglConfig.eglConfig), (int[])surfaceAttribs, (int)0);
            this.checkEglError("eglCreatePbufferSurface");
            if (result == null || result == EGL14.EGL_NO_SURFACE) {
                int error = EGL14.eglGetError();
                throw new RuntimeException("createOffscreenSurface failed error=" + error);
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"createOffscreenSurface", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    private void destroySurface(EGLSurface surface) {
        if (surface != EGL14.EGL_NO_SURFACE) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
            EGL14.eglDestroySurface((EGLDisplay)this.mEglDisplay, (EGLSurface)surface);
        }
    }

    private void checkEglError(String msg) {
        int error = EGL14.eglGetError();
        if (error != 12288) {
            throw new RuntimeException(msg + ": EGL error: 0x" + Integer.toHexString(error));
        }
    }

    private EGLConfig getConfig(int version, boolean hasDepthBuffer, int stencilBits, boolean isRecordable) {
        int renderableType = 4;
        if (version >= 3) {
            renderableType |= 0x40;
        }
        int[] attribList = new int[]{12352, renderableType, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12344, 12344, 12344, 12344, 12344, 12344, 12344};
        int offset = 10;
        if (stencilBits > 0) {
            attribList[offset++] = 12326;
            attribList[offset++] = stencilBits;
        }
        if (hasDepthBuffer) {
            attribList[offset++] = 12325;
            attribList[offset++] = 16;
        }
        if (isRecordable && BuildCheck.isAndroid4_3()) {
            attribList[offset++] = 12610;
            attribList[offset++] = 1;
        }
        for (int i = attribList.length - 1; i >= offset; --i) {
            attribList[i] = 12344;
        }
        EGLConfig config = this.internalGetConfig(attribList);
        if (config == null && version == 2 && isRecordable) {
            int n = attribList.length;
            for (int i = 10; i < n - 1; i += 2) {
                if (attribList[i] != 12610) continue;
                for (int j = i; j < n; ++j) {
                    attribList[j] = 12344;
                }
                break;
            }
            config = this.internalGetConfig(attribList);
        }
        if (config == null) {
            Log.w((String)TAG, (String)"try to fallback to RGB565");
            attribList[3] = 5;
            attribList[5] = 6;
            attribList[7] = 5;
            attribList[9] = 0;
            config = this.internalGetConfig(attribList);
        }
        return config;
    }

    private EGLConfig internalGetConfig(int[] attribList) {
        EGLConfig[] configs = new EGLConfig[1];
        int[] numConfigs = new int[1];
        if (!EGL14.eglChooseConfig((EGLDisplay)this.mEglDisplay, (int[])attribList, (int)0, (EGLConfig[])configs, (int)0, (int)configs.length, (int[])numConfigs, (int)0)) {
            return null;
        }
        return configs[0];
    }

    private static class EglSurface
    implements EGLBase.IEglSurface {
        @NonNull
        private final EGLBase14 mEglBase;
        private final int mGLVersion;
        private final boolean mOwnSurface;
        @NonNull
        private EGLSurface mEglSurface;
        private int viewPortX;
        private int viewPortY;
        private int viewPortWidth;
        private int viewPortHeight;

        private EglSurface(@NonNull EGLBase14 eglBase, Object surface) throws IllegalArgumentException {
            this.mEglBase = eglBase;
            this.mGLVersion = eglBase.getGlVersion();
            if (!GLUtils.isSupportedSurface(surface)) {
                throw new IllegalArgumentException("unsupported surface");
            }
            this.mEglSurface = this.mEglBase.createWindowSurface(surface);
            this.mOwnSurface = true;
            this.setViewPort(0, 0, this.getWidth(), this.getHeight());
        }

        private EglSurface(@NonNull EGLBase14 eglBase, int width, int height) {
            this.mEglBase = eglBase;
            this.mGLVersion = eglBase.getGlVersion();
            this.mEglSurface = width <= 0 || height <= 0 ? this.mEglBase.createOffscreenSurface(1, 1) : this.mEglBase.createOffscreenSurface(width, height);
            this.mOwnSurface = true;
            this.setViewPort(0, 0, this.getWidth(), this.getHeight());
        }

        private EglSurface(@NonNull EGLBase14 eglBase) {
            this(eglBase, 12377);
        }

        private EglSurface(@NonNull EGLBase14 eglBase, int readDraw) {
            this.mEglBase = eglBase;
            this.mGLVersion = eglBase.getGlVersion();
            this.mEglSurface = EGL14.eglGetCurrentSurface((int)readDraw);
            this.mOwnSurface = false;
            this.setViewPort(0, 0, this.getWidth(), this.getHeight());
        }

        @Override
        public void release() {
            this.mEglBase.makeDefault();
            if (this.mOwnSurface) {
                this.mEglBase.destroySurface(this.mEglSurface);
            }
            this.mEglSurface = EGL14.EGL_NO_SURFACE;
        }

        @Override
        public void makeCurrent() {
            this.mEglBase.makeCurrent(this.mEglSurface);
            this.setViewPort(this.viewPortX, this.viewPortY, this.viewPortWidth, this.viewPortHeight);
        }

        @Override
        public void setViewPort(int x, int y, int width, int height) {
            this.viewPortX = x;
            this.viewPortY = y;
            this.viewPortWidth = width;
            this.viewPortHeight = height;
            if (this.mGLVersion >= 2) {
                GLES20.glViewport((int)x, (int)y, (int)width, (int)height);
            } else {
                GLES10.glViewport((int)x, (int)y, (int)width, (int)height);
            }
        }

        @Override
        public void swap() {
            this.mEglBase.swap(this.mEglSurface);
        }

        @Override
        @RequiresApi(value=18)
        public void swap(long presentationTimeNs) {
            this.mEglBase.swap(this.mEglSurface, presentationTimeNs);
        }

        @RequiresApi(value=18)
        public void setPresentationTime(long presentationTimeNs) {
            EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEglBase.mEglDisplay, (EGLSurface)this.mEglSurface, (long)presentationTimeNs);
        }

        @Override
        public boolean isValid() {
            return this.mEglSurface != EGL14.EGL_NO_SURFACE && this.mEglBase.getSurfaceWidth(this.mEglSurface) > 0 && this.mEglBase.getSurfaceHeight(this.mEglSurface) > 0;
        }

        @Override
        public int getWidth() {
            return this.mEglBase.getSurfaceWidth(this.mEglSurface);
        }

        @Override
        public int getHeight() {
            return this.mEglBase.getSurfaceHeight(this.mEglSurface);
        }

        @NonNull
        public String toString() {
            return "EglSurface{mEglBase=" + this.mEglBase + ", mEglSurface=" + this.mEglSurface + ", mOwnSurface=" + this.mOwnSurface + ", viewPortX=" + this.viewPortX + ", viewPortY=" + this.viewPortY + ", viewPortWidth=" + this.viewPortWidth + ", viewPortHeight=" + this.viewPortHeight + '}';
        }
    }

    private static class Config
    extends EGLBase.IConfig<EGLConfig> {
        private Config(@NonNull EGLConfig eglConfig) {
            super(eglConfig);
        }
    }

    static class Context
    extends EGLBase.IContext<EGLContext> {
        private Context(EGLContext context) {
            super(context);
        }

        @Override
        @SuppressLint(value={"NewApi"})
        public long getNativeHandle() {
            return this.eglContext != null ? (BuildCheck.isLollipop() ? ((EGLContext)this.eglContext).getNativeHandle() : (long)((EGLContext)this.eglContext).getHandle()) : 0L;
        }
    }
}

