/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.collections;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ReentrantReadWriteList<V>
implements List<V> {
    @NonNull
    private final ReentrantReadWriteLock mSensorLock = new ReentrantReadWriteLock();
    @NonNull
    private final Lock mReadLock = this.mSensorLock.readLock();
    @NonNull
    private final Lock mWriteLock = this.mSensorLock.writeLock();
    @NonNull
    private final List<V> mList = new ArrayList<V>();

    @Override
    @Nullable
    public V get(int ix) throws IndexOutOfBoundsException {
        this.mReadLock.lock();
        try {
            V v = this.mList.get(ix);
            return v;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Nullable
    public V tryGet(int ix) {
        if (this.mReadLock.tryLock()) {
            try {
                V v = ix >= 0 && ix < this.mList.size() ? (V)this.mList.get(ix) : null;
                return v;
            }
            finally {
                this.mReadLock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public V set(int ix, V value) throws IndexOutOfBoundsException {
        this.mWriteLock.lock();
        try {
            V v = this.mList.set(ix, value);
            return v;
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    @Override
    public int indexOf(Object o) {
        this.mReadLock.lock();
        try {
            int n = this.mList.indexOf(o);
            return n;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        this.mReadLock.lock();
        try {
            int n = this.mList.lastIndexOf(o);
            return n;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    @NonNull
    public ListIterator<V> listIterator() {
        this.mReadLock.lock();
        try {
            ListIterator<V> listIterator = Collections.unmodifiableList(this.mList).listIterator();
            return listIterator;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    @NonNull
    public ListIterator<V> listIterator(int ix) {
        this.mReadLock.lock();
        try {
            ListIterator<V> listIterator = Collections.unmodifiableList(this.mList).listIterator(ix);
            return listIterator;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public List<V> subList(int fromIx, int toIx) {
        List<V> result;
        this.mReadLock.lock();
        try {
            result = Collections.unmodifiableList(this.mList).subList(fromIx, toIx);
        }
        finally {
            this.mReadLock.unlock();
        }
        return result;
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> collection) {
        boolean result;
        this.mReadLock.lock();
        try {
            result = this.mList.containsAll(collection);
        }
        finally {
            this.mReadLock.unlock();
        }
        return result;
    }

    @Override
    public boolean add(@NonNull V value) {
        boolean result;
        this.mWriteLock.lock();
        try {
            result = this.mList.add(value);
        }
        finally {
            this.mWriteLock.unlock();
        }
        return result;
    }

    @Override
    public void add(int ix, V value) throws IndexOutOfBoundsException {
        this.mWriteLock.lock();
        try {
            this.mList.add(ix, value);
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    public boolean addIfAbsent(V value) {
        boolean result;
        this.mWriteLock.lock();
        try {
            boolean bl = result = !this.mList.contains(value);
            if (!result) {
                this.mList.add(value);
            }
        }
        finally {
            this.mWriteLock.unlock();
        }
        return result;
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends V> collection) {
        boolean result;
        this.mWriteLock.lock();
        try {
            result = this.mList.addAll(collection);
        }
        finally {
            this.mWriteLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int ix, @NonNull Collection<? extends V> collection) {
        boolean result;
        this.mWriteLock.lock();
        try {
            result = this.mList.addAll(ix, collection);
        }
        finally {
            this.mWriteLock.unlock();
        }
        return result;
    }

    @Override
    @Nullable
    public V remove(int ix) {
        this.mWriteLock.lock();
        try {
            V v = ix >= 0 && ix < this.mList.size() ? (V)this.mList.remove(ix) : null;
            return v;
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    @Override
    @Nullable
    public V removeLast() {
        this.mWriteLock.lock();
        try {
            V v = !this.mList.isEmpty() ? (V)this.mList.remove(this.mList.size() - 1) : null;
            return v;
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    @Override
    public boolean remove(Object value) {
        boolean result;
        this.mWriteLock.lock();
        try {
            result = this.mList.remove(value);
        }
        finally {
            this.mWriteLock.unlock();
        }
        return result;
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> collection) {
        boolean result;
        this.mWriteLock.lock();
        try {
            result = this.mList.removeAll(collection);
        }
        finally {
            this.mWriteLock.unlock();
        }
        return result;
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> collection) {
        boolean result;
        this.mWriteLock.lock();
        try {
            result = this.mList.retainAll(collection);
        }
        finally {
            this.mWriteLock.unlock();
        }
        return result;
    }

    @Override
    public void clear() {
        this.mWriteLock.lock();
        try {
            this.mList.clear();
        }
        finally {
            this.mWriteLock.unlock();
        }
    }

    @Override
    public int size() {
        this.mReadLock.lock();
        try {
            int n = this.mList.size();
            return n;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public boolean contains(Object value) {
        this.mReadLock.lock();
        try {
            boolean bl = this.mList.contains(value);
            return bl;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.mReadLock.lock();
        try {
            boolean bl = this.mList.isEmpty();
            return bl;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    @NonNull
    public Iterator<V> iterator() {
        this.mReadLock.lock();
        try {
            Iterator<V> iterator = Collections.unmodifiableList(this.mList).iterator();
            return iterator;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Object[] toArray() {
        this.mReadLock.lock();
        try {
            if (this.mList.isEmpty()) {
                Object[] objectArray = new Object[]{};
                return objectArray;
            }
            Object[] values = new Object[this.mList.size()];
            int ix = 0;
            for (V value : this.mList) {
                values[ix++] = value;
            }
            Object[] objectArray = values;
            return objectArray;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @Override
    @NonNull
    public <T> T[] toArray(@NonNull T[] ts) {
        this.mReadLock.lock();
        try {
            T[] TArray = this.mList.toArray(ts);
            return TArray;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    @NonNull
    public Collection<V> values() {
        this.mReadLock.lock();
        try {
            Collection<V> collection = Collections.unmodifiableCollection(this.mList);
            return collection;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    private static final boolean isEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    protected void readLock() {
        this.mReadLock.lock();
    }

    protected void readUnlock() {
        this.mReadLock.unlock();
    }

    protected void writeLock() {
        this.mWriteLock.lock();
    }

    protected void writeUnlock() {
        this.mWriteLock.unlock();
    }

    protected List<V> Locked() {
        return this.mList;
    }
}

