/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.bluetooth;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.serenegiant.bluetooth.BluetoothDeviceInfo;
import com.serenegiant.common.R;
import com.serenegiant.view.ViewUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class BluetoothDeviceInfoRecyclerAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final boolean DEBUG = false;
    private static final String TAG = BluetoothDeviceInfoRecyclerAdapter.class.getSimpleName();
    private final int mLayoutId;
    @NonNull
    private final List<BluetoothDeviceInfo> mValues;
    @Nullable
    private final OnItemClickListener mListener;

    public BluetoothDeviceInfoRecyclerAdapter(@LayoutRes int resource, @Nullable OnItemClickListener listener) {
        this(resource, null, listener);
    }

    public BluetoothDeviceInfoRecyclerAdapter(@LayoutRes int resource, @Nullable List<BluetoothDeviceInfo> list, @Nullable OnItemClickListener listener) {
        this.mLayoutId = resource;
        this.mValues = list != null ? list : new ArrayList();
        this.mListener = listener;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(this.mLayoutId, parent, false);
        return new ViewHolder(view);
    }

    @SuppressLint(value={"RecyclerView"})
    public void onBindViewHolder(final @NonNull ViewHolder holder, int position) {
        holder.position = position;
        holder.mItem = this.mValues.get(position);
        if (holder.addressTv != null) {
            holder.addressTv.setText((CharSequence)this.mValues.get((int)position).address);
        }
        if (holder.nameTv != null) {
            holder.nameTv.setText((CharSequence)this.mValues.get((int)position).name);
        }
        holder.mView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BluetoothDeviceInfoRecyclerAdapter.this.mListener != null) {
                    BluetoothDeviceInfoRecyclerAdapter.this.mListener.onClick(holder.position, holder.mItem);
                }
            }
        });
    }

    public int getItemCount() {
        return this.mValues.size();
    }

    public BluetoothDeviceInfo getItem(int index) throws IndexOutOfBoundsException {
        return this.mValues.get(index);
    }

    public void add(@NonNull BluetoothDeviceInfo info) {
        this.mValues.add(info);
        this.notifyDataSetChanged();
    }

    public void add(int index, @NonNull BluetoothDeviceInfo info) {
        this.mValues.add(index, info);
        this.notifyDataSetChanged();
    }

    public void addAll(@NonNull Collection<? extends BluetoothDeviceInfo> collection) {
        this.mValues.addAll(collection);
        this.notifyDataSetChanged();
    }

    public void remove(BluetoothDeviceInfo info) {
        this.mValues.remove(info);
        this.notifyDataSetChanged();
    }

    public void remove(int index) {
        this.mValues.remove(index);
        this.notifyDataSetChanged();
    }

    public void removeAll(@NonNull Collection<? extends BluetoothDeviceInfo> collection) {
        this.mValues.removeAll(collection);
        this.notifyDataSetChanged();
    }

    public void retainAll(@NonNull Collection<? extends BluetoothDeviceInfo> collection) {
        this.mValues.retainAll(collection);
        this.notifyDataSetChanged();
    }

    public void clear() {
        this.mValues.clear();
        this.notifyDataSetChanged();
    }

    public void sort(Comparator<? super BluetoothDeviceInfo> comparator) {
        Collections.sort(this.mValues, comparator);
        this.notifyDataSetChanged();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        public final View mView;
        public final ImageView icon;
        public final TextView nameTv;
        public final TextView addressTv;
        public BluetoothDeviceInfo mItem;
        public int position;

        public ViewHolder(View view) {
            super(view);
            this.mView = view;
            this.nameTv = (TextView)view.findViewById(R.id.name);
            this.addressTv = (TextView)view.findViewById(R.id.address);
            this.icon = ViewUtils.findIconView(view);
        }
    }

    public static interface OnItemClickListener {
        public void onClick(int var1, BluetoothDeviceInfo var2);
    }
}

