/*
 * Decompiled with CFR 0.152.
 */
package arp.camera;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;

public class MyTextureView
extends TextureView {
    private int mRatioWidth = 0;
    private int mRatioHeight = 0;
    private MyTextureViewTouchEvent mMyTextureViewTouchEvent;
    private FocusPositionTouchEvent mFocusPositionTouchEvent;

    public MyTextureView(Context context) {
        super(context);
    }

    public MyTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public MyTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (0 == this.mRatioWidth || 0 == this.mRatioHeight) {
            this.setMeasuredDimension(width, height);
        } else if (width < height * this.mRatioWidth / this.mRatioHeight) {
            this.setMeasuredDimension(width, width * this.mRatioHeight / this.mRatioWidth);
        } else {
            this.setMeasuredDimension(height * this.mRatioWidth / this.mRatioHeight, height);
        }
    }

    public void fitWindow(int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Size cannot be negative.");
        }
        this.mRatioWidth = width;
        this.mRatioHeight = height;
        this.requestLayout();
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mFocusPositionTouchEvent.getPosition(event);
        return this.mMyTextureViewTouchEvent.onAreaTouchEvent(event);
    }

    public void setmMyTextureViewTouchEvent(MyTextureViewTouchEvent myTextureViewTouchEvent) {
        this.mMyTextureViewTouchEvent = myTextureViewTouchEvent;
    }

    public void setmFocusPositionTouchEvent(FocusPositionTouchEvent mFocusPositionTouchEvent) {
        this.mFocusPositionTouchEvent = mFocusPositionTouchEvent;
    }

    public static interface FocusPositionTouchEvent {
        public void getPosition(MotionEvent var1);
    }

    public static interface MyTextureViewTouchEvent {
        public boolean onAreaTouchEvent(MotionEvent var1);
    }
}

