/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.common.R;
import com.serenegiant.glutils.IMirror;
import com.serenegiant.view.ViewTransformDelegater;
import com.serenegiant.view.ViewUtils;
import com.serenegiant.widget.AspectScaledTextureView;

public class ZoomAspectScaledTextureView
extends AspectScaledTextureView
implements IMirror {
    private static final boolean DEBUG = false;
    private static final String TAG = ZoomAspectScaledTextureView.class.getSimpleName();
    private int mHandleTouchEvent;
    private float mManualScale = 1.0f;
    private float mManualRotate = Float.MAX_VALUE;
    protected final Matrix mDefaultMatrix = new Matrix();
    protected boolean mImageMatrixChanged;
    protected final float[] mMatrixCache = new float[9];
    private final Matrix mSavedImageMatrix = new Matrix();
    private final RectF mLimitRect = new RectF();
    private final ViewUtils.LineSegment[] mLimitSegments = new ViewUtils.LineSegment[4];
    private final RectF mContentRect = new RectF();
    private final float[] mTransCoords = new float[8];
    private int mPrimaryId;
    private int mSecondaryId;
    private float mPrimaryX;
    private float mPrimaryY;
    private float mSecondX;
    private float mSecondY;
    private float mPivotX;
    private float mPivotY;
    private float mTransX;
    private float mTransY;
    private float mTouchDistance;
    private float mCurrentDegrees;
    private boolean mIsRotating;
    protected final float mMaxScale = 10.0f;
    private float mMinScale = 0.05f;
    private int mState = 0;
    private Runnable mWaitImageReset;
    private Runnable mStartCheckRotate;
    private int mMirrorMode = 0;

    public ZoomAspectScaledTextureView(Context context) {
        this(context, null, 0);
    }

    public ZoomAspectScaledTextureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZoomAspectScaledTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ZoomAspectScaledTextureView, defStyleAttr, 0);
        try {
            this.mHandleTouchEvent = a.getInteger(R.styleable.ZoomAspectScaledTextureView_handle_touch_event, 7);
        }
        catch (UnsupportedOperationException e) {
            Log.d((String)TAG, (String)TAG, (Throwable)e);
            boolean b = a.getBoolean(R.styleable.ZoomAspectScaledTextureView_handle_touch_event, true);
            this.mHandleTouchEvent = b ? 7 : 0;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * Unable to fully structure code
     */
    @SuppressLint(value={"ClickableViewAccessibility", "SwitchIntDef"})
    public boolean onTouchEvent(MotionEvent event) {
        if (this.handleOnTouchEvent(event)) {
            return true;
        }
        if (this.mHandleTouchEvent == 0) {
            return super.onTouchEvent(event);
        }
        actionCode = event.getActionMasked();
        switch (actionCode) {
            case 0: {
                this.startWaiting(event);
                return true;
            }
            case 5: {
                switch (this.mState) {
                    case 1: {
                        this.removeCallbacks(this.mWaitImageReset);
                    }
                    case 2: {
                        if (event.getPointerCount() <= 1) break;
                        this.startCheck(event);
                        return true;
                    }
                }
                break;
            }
            case 2: {
                switch (this.mState) {
                    case 1: {
                        if ((this.mHandleTouchEvent & 1) != 1 || !this.checkTouchMoved(event)) break;
                        this.removeCallbacks(this.mWaitImageReset);
                        this.setState(2);
                        return true;
                    }
                    case 2: {
                        if (!this.processDrag(event)) break;
                        return true;
                    }
                    case 3: {
                        if (!this.checkTouchMoved(event) || (this.mHandleTouchEvent & 2) != 2) break;
                        this.startZoom(event);
                        return true;
                    }
                    case 4: {
                        if (!this.processZoom(event)) break;
                        return true;
                    }
                    case 5: {
                        if (!this.processRotate(event)) break;
                        return true;
                    }
                }
                break;
            }
            case 1: 
            case 3: {
                this.removeCallbacks(this.mWaitImageReset);
                this.removeCallbacks(this.mStartCheckRotate);
                if (actionCode != 1 || this.mState != 1) ** GOTO lbl56
                downTime = SystemClock.uptimeMillis() - event.getDownTime();
                if (downTime <= (long)ViewTransformDelegater.LONG_PRESS_TIMEOUT) ** GOTO lbl53
                this.performLongClick();
                ** GOTO lbl56
lbl53:
                // 1 sources

                if (downTime < (long)ViewTransformDelegater.TAP_TIMEOUT) {
                    this.performClick();
                }
            }
lbl56:
            // 6 sources

            case 6: {
                this.setState(0);
            }
        }
        return super.onTouchEvent(event);
    }

    protected boolean handleOnTouchEvent(MotionEvent event) {
        return false;
    }

    protected void onReset() {
    }

    @Override
    public void onSurfaceTextureAvailable(@NonNull SurfaceTexture surface, int width, int height) {
        super.onSurfaceTextureAvailable(surface, width, height);
        this.setMirror(0);
    }

    @Override
    public void onSurfaceTextureSizeChanged(@NonNull SurfaceTexture surface, int width, int height) {
        super.onSurfaceTextureSizeChanged(surface, width, height);
        this.applyMirrorMode();
    }

    @Override
    public void setMirror(int mirror) {
        if (this.mMirrorMode != mirror) {
            this.mMirrorMode = mirror;
            this.applyMirrorMode();
        }
    }

    @Override
    public int getMirror() {
        return this.mMirrorMode;
    }

    public void setEnableHandleTouchEvent(int enabled) {
        this.mHandleTouchEvent = enabled;
    }

    public void reset() {
        this.init();
        this.onReset();
    }

    @Override
    protected void init() {
        this.mState = -1;
        this.setState(0);
        this.mMinScale = 0.05f;
        this.mCurrentDegrees = 0.0f;
        this.mIsRotating = Math.abs((float)((int)(this.mCurrentDegrees / 360.0f)) * 360.0f - this.mCurrentDegrees) > 0.1f;
        Rect tmp = new Rect();
        this.getDrawingRect(tmp);
        this.mLimitRect.set(tmp);
        RectF bounds = this.getContentBounds();
        if (bounds != null && !bounds.isEmpty()) {
            this.mContentRect.set(bounds);
        } else {
            this.mContentRect.set(this.mLimitRect);
        }
        this.mLimitRect.inset(0.2f * (float)this.getWidth(), 0.2f * (float)this.getHeight());
        this.mLimitSegments[0] = null;
        this.mTransY = 0.0f;
        this.mTransX = 0.0f;
        super.init();
        this.mDefaultMatrix.set(this.mImageMatrix);
    }

    @Nullable
    protected RectF getContentBounds() {
        return null;
    }

    private final void setState(int state) {
        if (this.mState != state) {
            this.mState = state;
            this.getTransform(this.mSavedImageMatrix);
            if (!this.mImageMatrix.equals((Object)this.mSavedImageMatrix)) {
                this.mImageMatrix.set(this.mSavedImageMatrix);
                this.mImageMatrixChanged = true;
            }
        }
    }

    private final void startWaiting(MotionEvent event) {
        this.mPrimaryId = 0;
        this.mSecondaryId = -1;
        this.mPrimaryX = this.mSecondX = event.getX();
        this.mPrimaryY = this.mSecondY = event.getY();
        if (this.mWaitImageReset == null) {
            this.mWaitImageReset = new WaitImageReset();
        }
        this.postDelayed(this.mWaitImageReset, ViewTransformDelegater.CHECK_TIMEOUT);
        this.setState(1);
    }

    private final boolean processDrag(MotionEvent event) {
        boolean canMove;
        float dx = event.getX() - this.mPrimaryX;
        float dy = event.getY() - this.mPrimaryY;
        this.mTransCoords[0] = this.mTransCoords[6] = this.mContentRect.left;
        this.mTransCoords[1] = this.mTransCoords[3] = this.mContentRect.top;
        this.mTransCoords[5] = this.mTransCoords[7] = this.mContentRect.bottom;
        this.mTransCoords[2] = this.mTransCoords[4] = this.mContentRect.right;
        this.mImageMatrix.mapPoints(this.mTransCoords);
        for (int i = 0; i < 8; i += 2) {
            int n = i;
            this.mTransCoords[n] = this.mTransCoords[n] + dx;
            int n2 = i + 1;
            this.mTransCoords[n2] = this.mTransCoords[n2] + dy;
        }
        boolean bl = canMove = this.mLimitRect.contains(this.mTransCoords[0], this.mTransCoords[1]) || this.mLimitRect.contains(this.mTransCoords[2], this.mTransCoords[3]) || this.mLimitRect.contains(this.mTransCoords[4], this.mTransCoords[5]) || this.mLimitRect.contains(this.mTransCoords[6], this.mTransCoords[7]) || ViewUtils.ptInPoly(this.mLimitRect.left, this.mLimitRect.top, this.mTransCoords) || ViewUtils.ptInPoly(this.mLimitRect.right, this.mLimitRect.top, this.mTransCoords) || ViewUtils.ptInPoly(this.mLimitRect.right, this.mLimitRect.bottom, this.mTransCoords) || ViewUtils.ptInPoly(this.mLimitRect.left, this.mLimitRect.bottom, this.mTransCoords);
        if (!canMove) {
            ViewUtils.LineSegment side;
            if (this.mLimitSegments[0] == null) {
                this.mLimitSegments[0] = new ViewUtils.LineSegment(this.mLimitRect.left, this.mLimitRect.top, this.mLimitRect.right, this.mLimitRect.top);
                this.mLimitSegments[1] = new ViewUtils.LineSegment(this.mLimitRect.right, this.mLimitRect.top, this.mLimitRect.right, this.mLimitRect.bottom);
                this.mLimitSegments[2] = new ViewUtils.LineSegment(this.mLimitRect.right, this.mLimitRect.bottom, this.mLimitRect.left, this.mLimitRect.bottom);
                this.mLimitSegments[3] = new ViewUtils.LineSegment(this.mLimitRect.left, this.mLimitRect.bottom, this.mLimitRect.left, this.mLimitRect.top);
            }
            if (!(canMove = ViewUtils.checkIntersect(side = new ViewUtils.LineSegment(this.mTransCoords[0], this.mTransCoords[1], this.mTransCoords[2], this.mTransCoords[3]), this.mLimitSegments))) {
                side.set(this.mTransCoords[2], this.mTransCoords[3], this.mTransCoords[4], this.mTransCoords[5]);
                canMove = ViewUtils.checkIntersect(side, this.mLimitSegments);
                if (!canMove) {
                    side.set(this.mTransCoords[4], this.mTransCoords[5], this.mTransCoords[6], this.mTransCoords[7]);
                    canMove = ViewUtils.checkIntersect(side, this.mLimitSegments);
                    if (!canMove) {
                        side.set(this.mTransCoords[6], this.mTransCoords[7], this.mTransCoords[0], this.mTransCoords[1]);
                        canMove = ViewUtils.checkIntersect(side, this.mLimitSegments);
                    }
                }
            }
        }
        if (canMove) {
            if (!this.mIsRotating) {
                float left = Math.min(Math.min(this.mTransCoords[0], this.mTransCoords[2]), Math.min(this.mTransCoords[4], this.mTransCoords[6]));
                float right = Math.max(Math.max(this.mTransCoords[0], this.mTransCoords[2]), Math.max(this.mTransCoords[4], this.mTransCoords[6]));
                float top = Math.min(Math.min(this.mTransCoords[1], this.mTransCoords[3]), Math.min(this.mTransCoords[5], this.mTransCoords[7]));
                float bottom = Math.max(Math.max(this.mTransCoords[1], this.mTransCoords[3]), Math.max(this.mTransCoords[5], this.mTransCoords[7]));
                if (right < this.mLimitRect.left) {
                    dx = this.mLimitRect.left - right;
                } else if (left + 0.1f > this.mLimitRect.right) {
                    dx = this.mLimitRect.right - left - 0.1f;
                }
                if (bottom < this.mLimitRect.top) {
                    dy = this.mLimitRect.top - bottom;
                } else if (top + 0.1f > this.mLimitRect.bottom) {
                    dy = this.mLimitRect.bottom - top - 0.1f;
                }
            }
            if ((dx != 0.0f || dy != 0.0f) && this.mImageMatrix.postTranslate(dx, dy)) {
                this.mTransX += dx;
                this.mTransY += dy;
                this.mImageMatrixChanged = true;
                this.setTransform(this.mImageMatrix);
            }
        }
        this.mPrimaryX = event.getX();
        this.mPrimaryY = event.getY();
        return canMove;
    }

    private final void startCheck(MotionEvent event) {
        if (event.getPointerCount() > 1) {
            this.mPrimaryId = event.getPointerId(0);
            this.mPrimaryX = event.getX(0);
            this.mPrimaryY = event.getY(0);
            this.mSecondaryId = event.getPointerId(1);
            this.mSecondX = event.getX(1);
            this.mSecondY = event.getY(1);
            float dx = this.mSecondX - this.mPrimaryX;
            float dy = this.mSecondY - this.mPrimaryY;
            float distance = (float)Math.hypot(dx, dy);
            if (distance < 15.0f) {
                return;
            }
            this.mTouchDistance = distance;
            this.mPivotX = (this.mPrimaryX + this.mSecondX) / 2.0f;
            this.mPivotY = (this.mPrimaryY + this.mSecondY) / 2.0f;
            if ((this.mHandleTouchEvent & 4) == 4) {
                if (this.mStartCheckRotate == null) {
                    this.mStartCheckRotate = new StartCheckRotate();
                }
                this.postDelayed(this.mStartCheckRotate, ViewTransformDelegater.CHECK_TIMEOUT);
            }
            this.setState(3);
        }
    }

    private final void startZoom(MotionEvent event) {
        this.removeCallbacks(this.mStartCheckRotate);
        this.setState(4);
    }

    private final boolean processZoom(MotionEvent event) {
        this.restoreMatrix();
        float currentScale = this.getMatrixScale();
        float scale = this.calcScale(event);
        float tmpScale = scale * currentScale;
        if (tmpScale < this.mMinScale) {
            return false;
        }
        if (tmpScale > 10.0f) {
            return false;
        }
        if (this.mImageMatrix.postScale(scale, scale, this.mPivotX, this.mPivotY)) {
            this.mImageMatrixChanged = true;
            this.setTransform(this.mImageMatrix);
        }
        return true;
    }

    private final float calcScale(MotionEvent event) {
        float dx = event.getX(0) - event.getX(1);
        float dy = event.getY(0) - event.getY(1);
        float distance = (float)Math.hypot(dx, dy);
        return distance / this.mTouchDistance;
    }

    private final boolean checkTouchMoved(MotionEvent event) {
        float y;
        float x;
        boolean result = true;
        int ix0 = event.findPointerIndex(this.mPrimaryId);
        int ix1 = event.findPointerIndex(this.mSecondaryId);
        if (ix0 >= 0 && (x = event.getX(ix0) - this.mPrimaryX) * x + (y = event.getY(ix0) - this.mPrimaryY) * y < 225.0f) {
            if (ix1 >= 0) {
                x = event.getX(ix1) - this.mSecondX;
                if (x * x + (y = event.getY(ix1) - this.mSecondY) * y < 225.0f) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private final boolean processRotate(MotionEvent event) {
        if (this.checkTouchMoved(event)) {
            this.restoreMatrix();
            this.mCurrentDegrees = this.calcAngle(event);
            boolean bl = this.mIsRotating = Math.abs((float)((int)(this.mCurrentDegrees / 360.0f)) * 360.0f - this.mCurrentDegrees) > 0.1f;
            if (this.mIsRotating && this.mImageMatrix.postRotate(this.mCurrentDegrees, this.mPivotX, this.mPivotY)) {
                this.mImageMatrixChanged = true;
                this.setTransform(this.mImageMatrix);
                return true;
            }
        }
        return false;
    }

    private final float calcAngle(MotionEvent event) {
        int ix0 = event.findPointerIndex(this.mPrimaryId);
        int ix1 = event.findPointerIndex(this.mSecondaryId);
        float angle = 0.0f;
        if (ix0 >= 0 && ix1 >= 0) {
            float x0 = this.mSecondX - this.mPrimaryX;
            float y0 = this.mSecondY - this.mPrimaryY;
            float x1 = event.getX(ix1) - event.getX(ix0);
            float y1 = event.getY(ix1) - event.getY(ix0);
            double s = (x0 * x0 + y0 * y0) * (x1 * x1 + y1 * y1);
            double cos = (double)ViewUtils.dotProduct(x0, y0, x1, y1) / Math.sqrt(s);
            angle = 57.29578f * (float)Math.acos(cos) * Math.signum(ViewUtils.crossProduct(x0, y0, x1, y1));
        }
        return angle;
    }

    private final float getMatrixScale() {
        this.updateMatrixCache();
        float scale = Math.min(this.mMatrixCache[0], this.mMatrixCache[0]);
        if (scale <= 0.0f) {
            return 1.0f;
        }
        return scale;
    }

    private final void restoreMatrix() {
        this.mImageMatrix.set(this.mSavedImageMatrix);
        this.mImageMatrixChanged = true;
    }

    private final boolean updateMatrixCache() {
        if (this.mImageMatrixChanged) {
            this.mImageMatrix.getValues(this.mMatrixCache);
            this.mImageMatrixChanged = false;
            return true;
        }
        return false;
    }

    private void applyMirrorMode() {
        switch (this.mMirrorMode) {
            case 1: {
                this.setScaleX(-1.0f);
                this.setScaleY(1.0f);
                break;
            }
            case 2: {
                this.setScaleX(1.0f);
                this.setScaleY(-1.0f);
                break;
            }
            case 3: {
                this.setScaleX(-1.0f);
                this.setScaleY(-1.0f);
                break;
            }
            default: {
                this.setScaleX(1.0f);
                this.setScaleY(1.0f);
            }
        }
    }

    public void setManualScale(float scale) {
        this.setMatrix(this.mTransX, this.mTransY, scale, this.mManualRotate);
    }

    public float getManualScale() {
        return this.mManualScale;
    }

    public PointF getTranslate(@NonNull PointF result) {
        result.set(this.mManualScale, this.mTransX);
        return result;
    }

    public float getTranslateX() {
        return this.mTransX;
    }

    public float getTranslateY() {
        return this.mTransY;
    }

    public void setTranslate(float dx, float dy) {
        this.setMatrix(dx, dy, this.mManualScale, this.mManualRotate);
    }

    public void setRotate(float degrees) {
        this.setMatrix(this.mTransX, this.mTransY, this.mManualScale, degrees);
    }

    public float getRotate() {
        return this.mManualRotate;
    }

    public void setMatrix(float dx, float dy, float scale) {
        this.setMatrix(dx, dy, scale, Float.MAX_VALUE);
    }

    public void setMatrix(float dx, float dy, float scale, float degrees) {
        if (this.mTransX != dx || this.mTransY != dy || this.mManualScale != scale || this.mCurrentDegrees != degrees) {
            this.mManualScale = scale <= 0.0f ? this.mManualScale : scale;
            this.mTransX = dx;
            this.mTransY = dy;
            this.mManualRotate = degrees;
            if (degrees != Float.MAX_VALUE) {
                while (this.mManualRotate > 360.0f) {
                    this.mManualRotate -= 360.0f;
                }
                while (this.mManualRotate < -360.0f) {
                    this.mManualRotate += 360.0f;
                }
            }
            float[] work = new float[9];
            this.mDefaultMatrix.getValues(work);
            int w2 = this.getWidth() >> 1;
            int h2 = this.getHeight() >> 1;
            this.mImageMatrix.reset();
            this.mImageMatrix.postTranslate(dx, dy);
            this.mImageMatrix.postScale(work[0] * this.mManualScale, work[4] * this.mManualScale, (float)w2, (float)h2);
            if (degrees != Float.MAX_VALUE) {
                this.mImageMatrix.postRotate(this.mManualRotate, (float)w2, (float)h2);
            }
            this.mImageMatrixChanged = true;
            this.setTransform(this.mImageMatrix);
        }
    }

    private final class StartCheckRotate
    implements Runnable {
        private StartCheckRotate() {
        }

        @Override
        public void run() {
            if (ZoomAspectScaledTextureView.this.mState == 3) {
                ZoomAspectScaledTextureView.this.setState(5);
            }
        }
    }

    private final class WaitImageReset
    implements Runnable {
        private WaitImageReset() {
        }

        @Override
        public void run() {
            ZoomAspectScaledTextureView.this.init();
        }
    }
}

