/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.serenegiant.view.IViewTransformer;
import com.serenegiant.view.ViewTransformer;

public class TransformImageView
extends AppCompatImageView {
    private static final boolean DEBUG = false;
    private static final String TAG = TransformImageView.class.getSimpleName();
    @Nullable
    private IViewTransformer mViewTransformer;

    public TransformImageView(Context context) {
        this(context, null, 0);
    }

    public TransformImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TransformImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        super.setScaleType(ImageView.ScaleType.MATRIX);
    }

    protected void superSetScaleType(ImageView.ScaleType scaleType) {
        super.setScaleType(scaleType);
    }

    protected void superSetImageMatrix(@Nullable Matrix transform) {
        super.setImageMatrix(transform);
    }

    protected Matrix superGetImageMatrix(@Nullable Matrix transform) {
        Matrix result = transform;
        if (result != null) {
            result.set(super.getImageMatrix());
        } else {
            result = new Matrix(super.getImageMatrix());
        }
        return result;
    }

    public void setViewTransformer(@Nullable IViewTransformer transformer) {
        this.mViewTransformer = transformer;
    }

    @NonNull
    public IViewTransformer getViewTransformer() {
        if (this.mViewTransformer == null) {
            this.mViewTransformer = new DefaultViewTransformer(this);
        }
        return this.mViewTransformer;
    }

    public void setTransform(@Nullable Matrix transform) {
        this.getViewTransformer().setTransform(transform);
    }

    public Matrix getTransform(@Nullable Matrix transform) {
        return this.getViewTransformer().getTransform(transform);
    }

    public static class DefaultViewTransformer
    extends ViewTransformer {
        public DefaultViewTransformer(@NonNull TransformImageView view) {
            super((View)view);
        }

        @Override
        protected void setTransform(@NonNull View view, @Nullable Matrix transform) {
            ((TransformImageView)this.getTargetView()).superSetImageMatrix(transform);
        }

        @Override
        @NonNull
        protected Matrix getTransform(@NonNull View view, @Nullable Matrix transform) {
            return ((TransformImageView)this.getTargetView()).superGetImageMatrix(transform);
        }
    }
}

