/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import com.serenegiant.common.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ProgressView
extends View {
    private static final boolean DEBUG = false;
    private static final String TAG = ProgressView.class.getSimpleName();
    @Deprecated
    public static final int DIRECTION_LEFT_TO_RIGHT = 0;
    @Deprecated
    public static final int DIRECTION_RIGHT_TO_LEFT = 180;
    public static final int DIRECTION_BOTTOM_TO_TOP = 90;
    @Deprecated
    public static final int DIRECTION_TOP_TO_BOTTOM = 270;
    private final Object mSync = new Object();
    private int mDirectionDegrees = 90;
    private int mMin = 0;
    private int mMax = 100;
    private float mScale = 100.0f;
    private int mProgress = 40;
    private int mProgressColor = -65536;
    @Nullable
    private Drawable mDrawable;
    @Nullable
    private ClipDrawable mClipDrawable;
    private final Runnable mUpdateProgressOnUITask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int progress;
            Object object = ProgressView.this.mSync;
            synchronized (object) {
                progress = ProgressView.this.mProgress;
            }
            if (ProgressView.this.mClipDrawable != null) {
                int level = (int)((float)progress * ProgressView.this.mScale) + ProgressView.this.mMin;
                if (level < 0) {
                    level = 0;
                }
                if (level > 10000) {
                    level = 10000;
                }
                ProgressView.this.mClipDrawable.setLevel(level);
            }
            ProgressView.this.invalidate();
        }
    };
    private static final int CLIP_HORIZONTAL = 8;
    private static final int CLIP_VERTICAL = 128;

    public ProgressView(Context context) {
        this(context, null, 0);
    }

    public ProgressView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int bkDrawableId;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ProgressView, defStyleAttr, 0);
        int drawableId = a.getResourceId(R.styleable.ProgressView_drawableCompat, 0);
        if (drawableId != 0) {
            this.mDrawable = DrawableCompat.wrap((Drawable)ContextCompat.getDrawable((Context)context, (int)drawableId));
        }
        if ((bkDrawableId = a.getResourceId(R.styleable.ProgressView_backgroundCompat, 0)) != 0) {
            Drawable bk = DrawableCompat.wrap((Drawable)ContextCompat.getDrawable((Context)context, (int)bkDrawableId));
            int bkTintColor = a.getColor(R.styleable.ProgressView_backgroundTintCompat, 0);
            if (bkTintColor != 0) {
                DrawableCompat.setTint((Drawable)bk, (int)bkTintColor);
                DrawableCompat.setTintMode((Drawable)bk, (PorterDuff.Mode)PorterDuff.Mode.SRC_IN);
            }
            this.setBackground(bk);
        }
        this.mProgressColor = a.getColor(R.styleable.ProgressView_android_color, this.mProgressColor);
        this.mDirectionDegrees = ProgressView.checkDirection(a.getInt(R.styleable.ProgressView_direction, this.mDirectionDegrees));
        this.mMin = a.getInt(R.styleable.ProgressView_android_min, this.mMin);
        this.mMax = a.getInt(R.styleable.ProgressView_android_min, this.mMax);
        if (this.mMin == this.mMax) {
            throw new IllegalArgumentException("min and max should be different");
        }
        if (this.mMin > this.mMax) {
            int w = this.mMin;
            this.mMin = this.mMax;
            this.mMax = w;
        }
        this.mProgress = a.getInt(R.styleable.ProgressView_android_progress, this.mProgress);
        a.recycle();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mClipDrawable != null) {
            this.mClipDrawable.draw(canvas);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.resize();
    }

    public void setMinMax(int min, int max) {
        if ((this.mMin != min || this.mMax != max) && min != max) {
            this.mMin = Math.min(min, max);
            this.mMax = Math.max(min, max);
            this.resize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgress(int progress) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mProgress != progress) {
                this.mProgress = progress;
                this.removeCallbacks(this.mUpdateProgressOnUITask);
                this.post(this.mUpdateProgressOnUITask);
            }
        }
    }

    @Deprecated
    public void setDirection(int directionDegrees) {
        if (this.mDirectionDegrees != (directionDegrees = ProgressView.checkDirection(directionDegrees / 90 * 90 % 360))) {
            this.mDirectionDegrees = directionDegrees;
            this.resize();
        }
    }

    public int getDirection() {
        return this.mDirectionDegrees;
    }

    public void setColor(int color2) {
        if (this.mProgressColor != color2) {
            this.mProgressColor = color2;
            this.refreshDrawable(null);
        }
    }

    public void setDrawable(Drawable drawable2) {
        if (this.mDrawable != drawable2) {
            this.refreshDrawable(drawable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resize() {
        Object object = this.mSync;
        synchronized (object) {
            float progress = (float)this.mProgress * this.mScale + (float)this.mMin;
            this.mScale = 10000.0f / (float)(this.mMax - this.mMin);
            this.mProgress = (int)((progress - (float)this.mMin) / this.mScale);
        }
        this.refreshDrawable(this.mDrawable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"RtlHardcoded"})
    protected void refreshDrawable(@Nullable Drawable drawable2) {
        int level;
        Object object = this.mSync;
        synchronized (object) {
            level = (int)((float)this.mProgress * this.mScale) + this.mMin;
        }
        Drawable drawable3 = this.mDrawable = drawable2 != null ? DrawableCompat.wrap((Drawable)drawable2) : null;
        if (this.mDrawable == null) {
            this.setLayerType(2, null);
            this.mDrawable = new ColorDrawable(this.mProgressColor);
        } else {
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mDrawable instanceof VectorDrawable) {
                    this.setLayerType(1, null);
                }
            } else if (this.mDrawable instanceof VectorDrawableCompat) {
                this.setLayerType(1, null);
            }
            DrawableCompat.setTint((Drawable)this.mDrawable, (int)this.mProgressColor);
            DrawableCompat.setTintMode((Drawable)this.mDrawable, (PorterDuff.Mode)PorterDuff.Mode.SRC_IN);
        }
        int gravity = 123;
        int orientation = 1;
        switch (this.mDirectionDegrees) {
            case 0: {
                break;
            }
            case 90: {
                gravity = 215;
                orientation = 2;
                break;
            }
            case 180: {
                gravity = 125;
                orientation = 1;
                break;
            }
            case 270: {
                gravity = 183;
                orientation = 2;
                break;
            }
        }
        this.mClipDrawable = new ClipDrawable(this.mDrawable, gravity, orientation);
        Rect outRect = new Rect();
        this.getDrawingRect(outRect);
        this.mClipDrawable.setBounds(outRect);
        this.mClipDrawable.setLevel(level);
        this.postInvalidate();
    }

    private static int checkDirection(int directionDegrees) {
        while (directionDegrees < 0) {
            directionDegrees += 360;
        }
        return directionDegrees %= 360;
    }

    static {
        if (Build.VERSION.SDK_INT < 21) {
            AppCompatDelegate.setCompatVectorFromResourcesEnabled((boolean)true);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Direction {
    }
}

