/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatImageView;
import com.serenegiant.widget.CheckableEx;

public class CheckableImageView
extends AppCompatImageView
implements CheckableEx {
    private static final boolean DEBUG = false;
    private static final String TAG = CheckableImageView.class.getSimpleName();
    private boolean mIsChecked;

    public CheckableImageView(Context context) {
        this(context, null, 0);
    }

    public CheckableImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CheckableImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setChecked(boolean checked) {
        if (this.mIsChecked != checked) {
            this.mIsChecked = checked;
            this.refreshDrawableState();
        }
    }

    public boolean isChecked() {
        return this.mIsChecked;
    }

    public void toggle() {
        this.setChecked(!this.mIsChecked);
    }

    public int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            CheckableImageView.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }
}

