/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.GestureDetectorCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.tabs.TabLayout;

public class CenteredTabLayout
extends TabLayout {
    private static final boolean DEBUG = false;
    private static final String TAG = CenteredTabLayout.class.getSimpleName();
    private final GestureDetectorCompat mGestureDetector;
    private boolean mIsLocked = false;

    public CenteredTabLayout(@NonNull Context context) {
        this(context, null, 0);
    }

    public CenteredTabLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CenteredTabLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        super.setTabMode(0);
        this.mGestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                if (!CenteredTabLayout.this.mIsLocked) {
                    final int current = CenteredTabLayout.this.getSelectedTabPosition();
                    if (velocityX < 0.0f) {
                        int lastIx = CenteredTabLayout.this.getTabCount() - 1;
                        if (current < lastIx) {
                            CenteredTabLayout.this.post(new Runnable(){

                                @Override
                                public void run() {
                                    CenteredTabLayout.this.selectTab(CenteredTabLayout.this.getTabAt(current + 1), true);
                                }
                            });
                        }
                    } else if (current > 0) {
                        CenteredTabLayout.this.post(new Runnable(){

                            @Override
                            public void run() {
                                CenteredTabLayout.this.selectTab(CenteredTabLayout.this.getTabAt(current - 1), true);
                            }
                        });
                    }
                }
                return false;
            }
        });
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int numTabs;
        super.onLayout(changed, left, top, right, bottom);
        View ch = this.getChildAt(0);
        ViewGroup children = ch instanceof ViewGroup ? (ViewGroup)ch : null;
        int n = numTabs = children != null ? children.getChildCount() : 0;
        if (this.getTabMode() == 0 && numTabs > 0) {
            View firstTab = children.getChildAt(0);
            View lastTab = children.getChildAt(numTabs - 1);
            ViewCompat.setPaddingRelative((View)children, (int)(this.getWidth() / 2 - firstTab.getWidth() / 2), (int)0, (int)(this.getWidth() / 2 - lastTab.getWidth() / 2), (int)0);
        } else {
            ViewCompat.setPaddingRelative((View)children, (int)0, (int)0, (int)0, (int)0);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        this.mGestureDetector.onTouchEvent(event);
        return true;
    }

    public void selectTab(@Nullable TabLayout.Tab tab, boolean updateIndicator) {
        TabLayout.Tab current = this.getSelectedTab();
        if (!this.mIsLocked || tab != null && tab.equals(current)) {
            super.selectTab(tab, updateIndicator);
        }
    }

    @Nullable
    public TabLayout.Tab getSelectedTab() {
        return this.getTabAt(this.getSelectedTabPosition());
    }

    public void setLock(boolean lock) {
        this.mIsLocked = lock;
        this.postInvalidate();
    }

    public boolean getLock() {
        return this.mIsLocked;
    }

    public void setTabMode(int mode) {
        throw new UnsupportedOperationException("CenteredTabLayout does not support #setTabMode.");
    }
}

