/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.view;

import android.view.View;
import androidx.annotation.NonNull;

public class MeasureSpecDelegater {
    private MeasureSpecDelegater() {
    }

    public static MeasureSpec onMeasure(@NonNull View target, double requestedAspect, int scaleMode, boolean needResizeToKeepAspect, int widthMeasureSpec, int heightMeasureSpec) {
        MeasureSpec result = new MeasureSpec(widthMeasureSpec, heightMeasureSpec);
        if (requestedAspect > 0.0 && scaleMode == 0 && needResizeToKeepAspect) {
            int vertPadding;
            int initialWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int initialHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int horizPadding = target.getPaddingLeft() + target.getPaddingRight();
            double viewAspectRatio = (double)(initialWidth -= horizPadding) / (double)(initialHeight -= (vertPadding = target.getPaddingTop() + target.getPaddingBottom()));
            double aspectDiff = requestedAspect / viewAspectRatio - 1.0;
            if (Math.abs(aspectDiff) > 0.005) {
                if (aspectDiff > 0.0) {
                    initialHeight = (int)((double)initialWidth / requestedAspect);
                } else {
                    initialWidth = (int)((double)initialHeight * requestedAspect);
                }
                result.widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialWidth += horizPadding), (int)0x40000000);
                result.heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialHeight += vertPadding), (int)0x40000000);
            }
        }
        return result;
    }

    public static class MeasureSpec {
        public int widthMeasureSpec;
        public int heightMeasureSpec;

        private MeasureSpec(int widthMeasureSpec, int heightMeasureSpec) {
            this.widthMeasureSpec = widthMeasureSpec;
            this.heightMeasureSpec = heightMeasureSpec;
        }
    }
}

