/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.serenegiant.utils.ResourceHelper;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;

public class XmlHelper {
    private XmlHelper() {
    }

    public static final int getAttribute(@NonNull Context context, @NonNull XmlPullParser parser, String namespace, String name, int defaultValue) {
        try {
            return ResourceHelper.get(context, parser.getAttributeValue(namespace, name), defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static final boolean getAttribute(@NonNull Context context, @NonNull XmlPullParser parser, String namespace, String name, boolean defaultValue) {
        try {
            return ResourceHelper.get(context, parser.getAttributeValue(namespace, name), defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static final String getAttribute(@NonNull Context context, @NonNull XmlPullParser parser, String namespace, String name, String defaultValue) {
        try {
            return ResourceHelper.get(context, parser.getAttributeValue(namespace, name), defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static final CharSequence getAttribute(@NonNull Context context, @NonNull XmlPullParser parser, String namespace, String name, CharSequence defaultValue) {
        try {
            return ResourceHelper.get(context, (CharSequence)parser.getAttributeValue(namespace, name), defaultValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static final int[] getAttribute(@NonNull Context context, @NonNull XmlPullParser parser, String namespace, String name, int[] defaultValue) {
        int[] result = defaultValue;
        String valueString = XmlHelper.getAttribute(context, parser, namespace, name, "");
        if (!TextUtils.isEmpty((CharSequence)valueString)) {
            String[] values = valueString.split(",");
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (String value : values) {
                try {
                    list.add(ResourceHelper.get(context, value.trim(), 0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (list.size() > 0) {
                result = new int[list.size()];
                int i = 0;
                for (Integer value : list) {
                    result[i++] = value;
                }
            }
        }
        return result;
    }

    public static final boolean[] getAttribute(@NonNull Context context, @NonNull XmlPullParser parser, String namespace, String name, boolean[] defaultValue) {
        boolean[] result = defaultValue;
        String valueString = XmlHelper.getAttribute(context, parser, namespace, name, "");
        if (!TextUtils.isEmpty((CharSequence)valueString)) {
            String[] values = valueString.split(",");
            ArrayList<Boolean> list = new ArrayList<Boolean>();
            for (String value : values) {
                try {
                    list.add(ResourceHelper.get(context, value.trim(), false));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (list.size() > 0) {
                result = new boolean[list.size()];
                int i = 0;
                for (Boolean value : list) {
                    result[i++] = value;
                }
            }
        }
        return result;
    }
}

