/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.system;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.net.Uri;
import android.util.Log;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PermissionUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = PermissionUtils.class.getSimpleName();
    private static final String PREF_NAME_NOT_ASK_AGAIN = TAG + "_NOT_ASK_AGAIN";
    @NonNull
    private final WeakReference<ComponentActivity> mWeakActivity;
    @NonNull
    private final Map<String, ActivityResultLauncher<String>> mLaunchers = new HashMap<String, ActivityResultLauncher<String>>();
    @NonNull
    private final Map<String[], ActivityResultLauncher<String[]>> mMultiLaunchers = new HashMap<String[], ActivityResultLauncher<String[]>>();
    @NonNull
    private final PermissionCallback mCallback;

    public PermissionUtils(@NonNull ComponentActivity activity, @NonNull PermissionCallback callback) {
        this.mWeakActivity = new WeakReference<ComponentActivity>(activity);
        this.mCallback = callback;
        this.mLaunchers.putAll(PermissionUtils.prepare(activity, callback));
    }

    public PermissionUtils(@NonNull Fragment fragment, @NonNull PermissionCallback callback) {
        FragmentActivity activity = fragment.requireActivity();
        this.mWeakActivity = new WeakReference<FragmentActivity>(activity);
        this.mCallback = callback;
        this.mLaunchers.putAll(PermissionUtils.prepare(fragment, callback));
    }

    public PermissionUtils prepare(@NonNull ComponentActivity activity, @NonNull String[] permissions) {
        this.mMultiLaunchers.put(permissions, PermissionUtils.prepare(activity, permissions, this.mCallback));
        return this;
    }

    public PermissionUtils prepare(@NonNull Fragment fragment, @NonNull String[] permissions) {
        this.mMultiLaunchers.put(permissions, PermissionUtils.prepare(fragment, permissions, this.mCallback));
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean requestPermission(@NonNull String permission2, boolean canShowRational) throws IllegalArgumentException {
        ComponentActivity activity = (ComponentActivity)this.mWeakActivity.get();
        if (activity == null || activity.isFinishing()) {
            return false;
        }
        boolean hasPermission = PermissionUtils.hasPermission((Context)activity, permission2);
        if (hasPermission) {
            PermissionUtils.setNeverAskAgain((Context)activity, permission2, false);
            return true;
        }
        if (canShowRational && ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2)) {
            this.mCallback.onPermissionShowRational(permission2);
            return hasPermission;
        } else if (!PermissionUtils.isNeverAskAgain((Context)activity, permission2)) {
            ActivityResultLauncher<String> launcher;
            ActivityResultLauncher<String> activityResultLauncher = launcher = this.mLaunchers.containsKey(permission2) ? this.mLaunchers.get(permission2) : null;
            if (launcher == null) throw new IllegalArgumentException("has no ActivityResultLauncher for " + permission2);
            launcher.launch((Object)permission2);
            return hasPermission;
        } else {
            this.mCallback.onPermissionNeverAskAgain(permission2);
        }
        return hasPermission;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean requestPermission(@NonNull String[] permissions, boolean canShowRational) throws IllegalArgumentException {
        if (permissions.length == 1) {
            return this.requestPermission(permissions[0], canShowRational);
        }
        ComponentActivity activity = (ComponentActivity)this.mWeakActivity.get();
        if (activity == null || activity.isFinishing()) {
            return false;
        }
        boolean hasPermission = PermissionUtils.hasPermissionAll((Context)activity, permissions);
        if (hasPermission) {
            for (String permission2 : permissions) {
                PermissionUtils.setNeverAskAgain((Context)activity, permission2, false);
            }
            return true;
        }
        if (canShowRational && PermissionUtils.shouldShowRequestPermissionRationale((Activity)activity, permissions)) {
            this.mCallback.onPermissionShowRational(permissions);
            return hasPermission;
        } else if (!PermissionUtils.isNeverAskAgain((Context)activity, permissions)) {
            ActivityResultLauncher<String[]> launcher;
            ActivityResultLauncher<String[]> activityResultLauncher = launcher = this.mMultiLaunchers.containsKey(permissions) ? this.mMultiLaunchers.get(permissions) : null;
            if (launcher == null) throw new IllegalArgumentException("has no ActivityResultLauncher for " + Arrays.toString(permissions));
            launcher.launch((Object)permissions);
            return hasPermission;
        } else {
            this.mCallback.onPermissionNeverAskAgain(permissions);
        }
        return hasPermission;
    }

    public static Map<String, ActivityResultLauncher<String>> prepare(@NonNull ComponentActivity activity, @NonNull PermissionCallback callback) {
        String[] requestedPermissions;
        HashMap<String, ActivityResultLauncher<String>> result = new HashMap<String, ActivityResultLauncher<String>>();
        ComponentActivity context = activity;
        for (String permission2 : requestedPermissions = PermissionUtils.requestedPermissions((Context)context)) {
            ActivityResultLauncher requestPermissionLauncher = activity.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), arg_0 -> PermissionUtils.lambda$prepare$0(permission2, (Context)context, callback, activity, arg_0));
            result.put(permission2, (ActivityResultLauncher<String>)requestPermissionLauncher);
        }
        return result;
    }

    public static Map<String, ActivityResultLauncher<String>> prepare(@NonNull Fragment fragment, @NonNull PermissionCallback callback) {
        String[] requestedPermissions;
        HashMap<String, ActivityResultLauncher<String>> result = new HashMap<String, ActivityResultLauncher<String>>();
        FragmentActivity activity = fragment.requireActivity();
        for (String permission2 : requestedPermissions = PermissionUtils.requestedPermissions((Context)activity)) {
            ActivityResultLauncher requestPermissionLauncher = fragment.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), arg_0 -> PermissionUtils.lambda$prepare$1(permission2, (ComponentActivity)activity, callback, arg_0));
            result.put(permission2, (ActivityResultLauncher<String>)requestPermissionLauncher);
        }
        return result;
    }

    public static ActivityResultLauncher<String[]> prepare(@NonNull ComponentActivity activity, @NonNull String[] permissions, @NonNull PermissionCallback callback) {
        return activity.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestMultiplePermissions(), result -> {
            for (Map.Entry entry : result.entrySet()) {
                String permission2 = (String)entry.getKey();
                if (((Boolean)entry.getValue()).booleanValue()) {
                    PermissionUtils.setNeverAskAgain((Context)activity, permission2, false);
                    callback.onPermission(permission2);
                    continue;
                }
                if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2)) {
                    PermissionUtils.setNeverAskAgain((Context)activity, permission2, true);
                }
                callback.onPermissionDenied(permission2);
            }
        });
    }

    public static ActivityResultLauncher<String[]> prepare(@NonNull Fragment fragment, @NonNull String[] permissions, @NonNull PermissionCallback callback) {
        FragmentActivity activity = fragment.requireActivity();
        return fragment.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestMultiplePermissions(), arg_0 -> PermissionUtils.lambda$prepare$3((ComponentActivity)activity, callback, arg_0));
    }

    public static boolean shouldShowRequestPermissionRationale(@NonNull Activity activity, @NonNull String[] permissions) {
        for (String permission2 : permissions) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNeverAskAgain(@NonNull Context context, @NonNull String[] permissions) {
        SharedPreferences preferences = context.getSharedPreferences(PREF_NAME_NOT_ASK_AGAIN, 0);
        for (String permission2 : permissions) {
            if (!preferences.getBoolean(permission2, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNeverAskAgain(@NonNull Context context, @NonNull String permission2) {
        SharedPreferences preferences = context.getSharedPreferences(PREF_NAME_NOT_ASK_AGAIN, 0);
        return preferences.getBoolean(permission2, false);
    }

    private static void setNeverAskAgain(@NonNull Context context, @NonNull String permission2, boolean neverAskAgain) {
        SharedPreferences.Editor editor = context.getSharedPreferences(PREF_NAME_NOT_ASK_AGAIN, 0).edit();
        if (neverAskAgain) {
            editor.putBoolean(permission2, true).apply();
        } else {
            editor.remove(permission2).apply();
        }
    }

    public static final void dumpPermissions(@Nullable Context context) {
        if (context == null) {
            return;
        }
        try {
            PackageManager pm = context.getPackageManager();
            List list = pm.getAllPermissionGroups(128);
            for (PermissionGroupInfo info : list) {
                Log.d((String)TAG, (String)("dumpPermissions:" + info.name + "=" + info));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NonNull
    public static String[] requestedPermissions(@NonNull Context context) {
        PackageInfo info = null;
        try {
            info = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return info != null && info.requestedPermissions != null ? info.requestedPermissions : new String[]{};
    }

    public static int checkSelfPermission(@Nullable Context context, String permissionName) {
        if (context == null) {
            return -1;
        }
        int result = -1;
        try {
            result = ContextCompat.checkSelfPermission((Context)context, (String)permissionName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean hasPermission(@Nullable Context context, String permissionName) {
        if (context == null) {
            return false;
        }
        boolean result = false;
        try {
            result = ContextCompat.checkSelfPermission((Context)context, (String)permissionName) == 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @NonNull
    public static String[] hasPermission(@Nullable Context context, @NonNull String[] permissions) {
        ArrayList<String> result = new ArrayList<String>();
        if (context != null) {
            for (String permission2 : permissions) {
                if (ContextCompat.checkSelfPermission((Context)context, (String)permission2) != 0) continue;
                result.add(permission2);
            }
        }
        return result.toArray(new String[0]);
    }

    public static boolean hasPermissionAll(@Nullable Context context, @NonNull String[] permissions) {
        boolean result = true;
        if (context != null) {
            for (String permission2 : permissions) {
                if (ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static boolean hasPermissionAll(@Nullable Context context) {
        boolean result = false;
        if (context != null) {
            result = PermissionUtils.hasPermissionAll(context, PermissionUtils.requestedPermissions(context));
        }
        return result;
    }

    public static boolean hasAudio(@Nullable Context context) {
        return PermissionUtils.hasPermission(context, "android.permission.RECORD_AUDIO");
    }

    public static boolean hasNetwork(@Nullable Context context) {
        return PermissionUtils.hasPermission(context, "android.permission.INTERNET");
    }

    public static boolean hasNetworkState(@Nullable Context context) {
        return PermissionUtils.hasPermission(context, "android.permission.ACCESS_NETWORK_STATE");
    }

    public static boolean hasWriteExternalStorage(@Nullable Context context) {
        return PermissionUtils.hasPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    public static boolean hasReadExternalStorage(@Nullable Context context) {
        return PermissionUtils.hasPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    public static boolean hasAccessLocation(@Nullable Context context) {
        return PermissionUtils.hasPermission(context, "android.permission.ACCESS_COARSE_LOCATION") && PermissionUtils.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION");
    }

    public static boolean hasAccessCoarseLocation(@Nullable Context context) {
        return PermissionUtils.hasPermission(context, "android.permission.ACCESS_COARSE_LOCATION");
    }

    public static boolean hasAccessFineLocation(@Nullable Context context) {
        return PermissionUtils.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION");
    }

    public static boolean hasCamera(@Nullable Context context) {
        return PermissionUtils.hasPermission(context, "android.permission.CAMERA");
    }

    public static void openSettings(@NonNull Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)context.getPackageName(), null);
        intent.setData(uri);
        context.startActivity(intent);
    }

    @NonNull
    public static List<String> missingPermissions(@NonNull Context context) throws IllegalArgumentException, PackageManager.NameNotFoundException {
        return PermissionUtils.missingPermissions(context, PermissionUtils.requestedPermissions(context));
    }

    @NonNull
    public static List<String> missingPermissions(@NonNull Context context, @NonNull String[] expectations) throws IllegalArgumentException, PackageManager.NameNotFoundException {
        return PermissionUtils.missingPermissions(context, Arrays.asList(expectations));
    }

    @NonNull
    public static List<String> missingPermissions(@NonNull Context context, @NonNull Collection<String> expectations) throws IllegalArgumentException, PackageManager.NameNotFoundException {
        PackageManager pm = context.getPackageManager();
        PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 4096);
        ArrayList<String> result = new ArrayList<String>(expectations);
        String[] permissions = pi.requestedPermissions;
        if (permissions != null && permissions.length > 0) {
            for (String permission2 : permissions) {
                if (!PermissionUtils.hasPermission(context, permission2)) continue;
                result.remove(permission2);
            }
        }
        return result;
    }

    private static /* synthetic */ void lambda$prepare$3(ComponentActivity activity, PermissionCallback callback, Map result) {
        for (Map.Entry entry : result.entrySet()) {
            String permission2 = (String)entry.getKey();
            if (((Boolean)entry.getValue()).booleanValue()) {
                PermissionUtils.setNeverAskAgain((Context)activity, permission2, false);
                callback.onPermission(permission2);
                continue;
            }
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2)) {
                PermissionUtils.setNeverAskAgain((Context)activity, permission2, true);
            }
            callback.onPermissionDenied(permission2);
        }
    }

    private static /* synthetic */ void lambda$prepare$1(String permission2, ComponentActivity activity, PermissionCallback callback, Boolean isGranted) {
        if (isGranted.booleanValue()) {
            PermissionUtils.setNeverAskAgain((Context)activity, permission2, false);
            callback.onPermission(permission2);
        } else {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2)) {
                PermissionUtils.setNeverAskAgain((Context)activity, permission2, true);
            }
            callback.onPermissionDenied(permission2);
        }
    }

    private static /* synthetic */ void lambda$prepare$0(String permission2, Context context, PermissionCallback callback, ComponentActivity activity, Boolean isGranted) {
        if (isGranted.booleanValue()) {
            PermissionUtils.setNeverAskAgain(context, permission2, false);
            callback.onPermission(permission2);
        } else {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2)) {
                PermissionUtils.setNeverAskAgain(context, permission2, true);
            }
            callback.onPermissionDenied(permission2);
        }
    }

    public static abstract class SinglePermissionCallback
    implements PermissionCallback {
        @Override
        public void onPermissionShowRational(@NonNull String[] permissions) {
        }

        @Override
        public void onPermissionNeverAskAgain(@NonNull String[] permissions) {
        }
    }

    public static interface PermissionCallback {
        public void onPermissionShowRational(@NonNull String var1);

        public void onPermissionShowRational(@NonNull String[] var1);

        public void onPermissionDenied(@NonNull String var1);

        public void onPermission(@NonNull String var1);

        public void onPermissionNeverAskAgain(@NonNull String var1);

        public void onPermissionNeverAskAgain(@NonNull String[] var1);
    }
}

