/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.system;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.Printer;
import android.util.StringBuilderPrinter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class AppInfoUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = AppInfoUtils.class.getSimpleName();

    private AppInfoUtils() {
    }

    public static boolean isSystemAppOrUpdatedSystemApp(@NonNull ApplicationInfo info) {
        return (info.flags & 1) != 0 || (info.flags & 0x80) != 0;
    }

    public static boolean isSystemApp(@NonNull ApplicationInfo info) {
        return (info.flags & 1) != 0;
    }

    public static boolean isUpdatedSystemApp(@NonNull ApplicationInfo info) {
        return (info.flags & 0x80) != 0;
    }

    public static boolean hasFeature(@NonNull Context context, @NonNull ApplicationInfo info, @NonNull String feature) {
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo pi = pm.getPackageInfo(info.packageName, 16384);
            if (pi.reqFeatures != null && pi.reqFeatures.length > 0) {
                for (FeatureInfo fi : pi.reqFeatures) {
                    if (!feature.equals(fi.name)) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static List<ApplicationInfo> getInstalledApplications(@NonNull Context context, @Nullable AppInfoFilterCallback filter) {
        ArrayList<ApplicationInfo> result = new ArrayList<ApplicationInfo>();
        PackageManager pm = context.getPackageManager();
        List apps = pm.getInstalledApplications(128);
        for (ApplicationInfo app : apps) {
            if (filter != null && !filter.onFilter(app)) continue;
            result.add(app);
        }
        return result;
    }

    @NonNull
    public static Drawable getApplicationIcon(@NonNull Context context, @NonNull ApplicationInfo info) {
        return info.loadIcon(context.getPackageManager());
    }

    @NonNull
    public static CharSequence getDisplayName(@NonNull Context context, @NonNull ApplicationInfo info) {
        return info.loadLabel(context.getPackageManager());
    }

    @NonNull
    public static String toString(@NonNull ApplicationInfo info) {
        StringBuilder sb = new StringBuilder();
        StringBuilderPrinter printer = new StringBuilderPrinter(sb);
        info.dump((Printer)printer, "");
        return sb.toString();
    }

    @Nullable
    public static String getDefaultActivity(@NonNull Context context, @NonNull String packageName) {
        ComponentName componentName;
        String activityFQCN = null;
        PackageManager pm = context.getPackageManager();
        Intent intent = pm.getLaunchIntentForPackage(packageName);
        ComponentName componentName2 = componentName = intent != null ? intent.getComponent() : null;
        if (componentName != null) {
            activityFQCN = componentName.getClassName();
        }
        return activityFQCN;
    }

    @Nullable
    public static ActivityInfo findLauncherActivity(@NonNull Context context, @Nullable AppInfoFilterCallback filter) {
        return AppInfoUtils.findActivity(context, new Intent("android.intent.action.MAIN").addCategory("android.intent.category.LAUNCHER"), filter);
    }

    @Nullable
    public static ActivityInfo findActivity(@NonNull Context context, @NonNull Intent intent, @Nullable AppInfoFilterCallback filter) {
        PackageManager pm = context.getPackageManager();
        List list = Build.VERSION.SDK_INT >= 23 ? pm.queryIntentActivities(intent, 131200) : pm.queryIntentActivities(intent, 128);
        ActivityInfo found = null;
        for (ResolveInfo item : list) {
            ActivityInfo info = item.activityInfo;
            if (filter != null && !filter.onFilter(info.applicationInfo)) continue;
            if (TextUtils.isEmpty((CharSequence)info.packageName)) {
                try {
                    info.packageName = info.applicationInfo.packageName;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (TextUtils.isEmpty((CharSequence)info.targetActivity)) {
                info.targetActivity = info.name.startsWith(".") ? info.packageName + info.name : info.name;
            }
            found = info;
            break;
        }
        return found;
    }

    @NonNull
    public static List<ActivityInfo> getLauncherActivities(@NonNull Context context, @Nullable AppInfoFilterCallback filter) {
        return AppInfoUtils.getActivities(context, new Intent("android.intent.action.MAIN").addCategory("android.intent.category.LAUNCHER"), filter);
    }

    @NonNull
    public static List<ActivityInfo> getActivities(@NonNull Context context, @NonNull Intent intent, @Nullable AppInfoFilterCallback filter) {
        ArrayList<ActivityInfo> result = new ArrayList<ActivityInfo>();
        PackageManager pm = context.getPackageManager();
        List list = Build.VERSION.SDK_INT >= 23 ? pm.queryIntentActivities(intent, 131200) : pm.queryIntentActivities(intent, 128);
        for (ResolveInfo item : list) {
            ActivityInfo info = item.activityInfo;
            if (filter != null && !filter.onFilter(info.applicationInfo)) continue;
            if (TextUtils.isEmpty((CharSequence)info.packageName)) {
                try {
                    info.packageName = info.applicationInfo.packageName;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (TextUtils.isEmpty((CharSequence)info.targetActivity)) {
                info.targetActivity = info.name.startsWith(".") ? info.packageName + info.name : info.name;
            }
            result.add(info);
        }
        return result;
    }

    @NonNull
    public static List<String> getInstalledPackages(@NonNull Context context) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Process p = Runtime.getRuntime().exec("pm list packages -u");
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = reader.readLine()) != null) {
                line = line.replace("package:", "");
                result.add(line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @NonNull
    public static List<String> getLauncherPackages(@NonNull Context context) {
        ArrayList<String> result = new ArrayList<String>();
        PackageManager pm = context.getPackageManager();
        Intent intent = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.LAUNCHER");
        List list = Build.VERSION.SDK_INT >= 23 ? pm.queryIntentActivities(intent, 131072) : pm.queryIntentActivities(intent, 0);
        for (ResolveInfo item : list) {
            ApplicationInfo app = item.activityInfo.applicationInfo;
            result.add(app.packageName);
        }
        return result;
    }

    public static interface AppInfoFilterCallback {
        public boolean onFilter(@NonNull ApplicationInfo var1);
    }
}

