/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.net;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.ContextUtils;
import com.serenegiant.utils.HandlerThreadHandler;
import com.serenegiant.utils.HandlerUtils;
import java.lang.ref.WeakReference;
import java.util.Locale;

public class ConnectivityHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = ConnectivityHelper.class.getSimpleName();
    private static final int NETWORK_TYPE_UNKNOWN = -1;
    public static final int NETWORK_TYPE_NON = 0;
    public static final int NETWORK_TYPE_MOBILE = 1;
    public static final int NETWORK_TYPE_WIFI = 2;
    public static final int NETWORK_TYPE_BLUETOOTH = 128;
    public static final int NETWORK_TYPE_ETHERNET = 512;
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final WeakReference<Context> mWeakContext;
    @NonNull
    private final ConnectivityCallback mCallback;
    @NonNull
    private final Handler mUIHandler;
    @NonNull
    private final Handler mAsyncHandler;
    @TargetApi(value=21)
    @Nullable
    private ConnectivityManager.OnNetworkActiveListener mOnNetworkActiveListener;
    @TargetApi(value=21)
    @Nullable
    private ConnectivityManager.NetworkCallback mNetworkCallback;
    @Nullable
    private BroadcastReceiver mNetworkChangedReceiver;
    private int mActiveNetworkType = -1;
    private volatile boolean mIsReleased = false;
    private static final String ACTION_GLOBAL_CONNECTIVITY_CHANGE = "android.net.conn.CONNECTIVITY_CHANGE";

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public ConnectivityHelper(@NonNull Context context, @NonNull ConnectivityCallback callback) {
        this.mWeakContext = new WeakReference<Context>(context);
        this.mCallback = callback;
        this.mUIHandler = new Handler(context.getMainLooper());
        this.mAsyncHandler = HandlerThreadHandler.createHandler(TAG);
        this.mUIHandler.post(new Runnable(){

            @Override
            @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
            public void run() {
                ConnectivityHelper.this.initAsync();
            }
        });
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    public void release() {
        this.mIsReleased = true;
        this.updateActiveNetwork(0);
        Context context = (Context)this.mWeakContext.get();
        if (context != null) {
            this.mWeakContext.clear();
            if (BuildCheck.isAPI21()) {
                ConnectivityManager manager = ContextUtils.requireSystemService(context, ConnectivityManager.class);
                if (this.mOnNetworkActiveListener != null) {
                    try {
                        manager.removeDefaultNetworkActiveListener(this.mOnNetworkActiveListener);
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                    this.mOnNetworkActiveListener = null;
                }
                if (this.mNetworkCallback != null) {
                    try {
                        manager.unregisterNetworkCallback(this.mNetworkCallback);
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                    this.mNetworkCallback = null;
                }
            }
            if (this.mNetworkChangedReceiver != null) {
                try {
                    context.unregisterReceiver(this.mNetworkChangedReceiver);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                this.mNetworkChangedReceiver = null;
            }
        }
        Object object = this.mSync;
        synchronized (object) {
            this.mUIHandler.removeCallbacksAndMessages(null);
            try {
                this.mAsyncHandler.removeCallbacksAndMessages(null);
                this.mAsyncHandler.getLooper().quit();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    public boolean isValid() {
        try {
            this.requireConnectivityManager();
            return !this.mIsReleased;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveNetworkType() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mIsReleased) {
                throw new IllegalStateException("already released!");
            }
            return this.mActiveNetworkType;
        }
    }

    public boolean isNetworkReachable() throws IllegalStateException {
        return this.getActiveNetworkType() != 0;
    }

    public boolean isWifiNetworkReachable() throws IllegalStateException {
        int active = this.getActiveNetworkType();
        return active == 2 || active == 512;
    }

    public boolean isMobileNetworkReachable() throws IllegalStateException {
        return this.getActiveNetworkType() == 1;
    }

    public boolean isBluetoothNetworkReachable() throws IllegalStateException {
        return this.getActiveNetworkType() == 128;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mIsReleased) {
                throw new IllegalStateException("already released!");
            }
            this.mActiveNetworkType = 0;
            this.mUIHandler.post(new Runnable(){

                @Override
                @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
                public void run() {
                    ConnectivityHelper.this.refreshAsync();
                }
            });
        }
    }

    @NonNull
    private Context requireContext() throws IllegalStateException {
        Context context = (Context)this.mWeakContext.get();
        if (context == null) {
            throw new IllegalStateException("context is already released");
        }
        return context;
    }

    @NonNull
    private ConnectivityManager requireConnectivityManager() throws IllegalStateException {
        return ContextUtils.requireSystemService(this.requireContext(), ConnectivityManager.class);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private void initAsync() {
        ConnectivityManager manager = this.requireConnectivityManager();
        if (BuildCheck.isAPI21()) {
            this.mOnNetworkActiveListener = new MyOnNetworkActiveListener();
            manager.addDefaultNetworkActiveListener(this.mOnNetworkActiveListener);
            this.mNetworkCallback = new MyNetworkCallback();
            if (BuildCheck.isAPI26()) {
                manager.registerDefaultNetworkCallback(this.mNetworkCallback, this.mAsyncHandler);
            } else if (BuildCheck.isAPI24()) {
                manager.registerDefaultNetworkCallback(this.mNetworkCallback);
            } else {
                manager.registerNetworkCallback(new NetworkRequest.Builder().build(), this.mNetworkCallback);
            }
        } else {
            this.mNetworkChangedReceiver = new NetworkChangedReceiver(this);
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction(ACTION_GLOBAL_CONNECTIVITY_CHANGE);
            this.requireContext().registerReceiver(this.mNetworkChangedReceiver, intentFilter);
        }
        this.refreshAsync();
    }

    @SuppressLint(value={"NewApi"})
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    private void refreshAsync() {
        ConnectivityManager manager = this.requireConnectivityManager();
        if (BuildCheck.isAPI23()) {
            Network network = manager.getActiveNetwork();
            this.updateActiveNetwork(network, null, null);
        } else if (BuildCheck.isAPI21()) {
            Network[] allNetworks;
            for (Network network : allNetworks = manager.getAllNetworks()) {
                NetworkCapabilities capabilities = manager.getNetworkCapabilities(network);
                LinkProperties linkProperties = manager.getLinkProperties(network);
                if (capabilities == null || linkProperties == null) continue;
                manager.getLinkProperties(network);
                this.updateActiveNetwork(network, capabilities, linkProperties);
                return;
            }
            this.updateActiveNetwork(0);
        } else {
            this.updateActiveNetwork(manager.getActiveNetworkInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callOnNetworkChanged(int activeNetworkType, int prevNetworkType) {
        Object object = this.mSync;
        synchronized (object) {
            if (HandlerUtils.isActive(this.mAsyncHandler)) {
                this.mAsyncHandler.post(() -> {
                    try {
                        this.mCallback.onNetworkChanged(activeNetworkType, prevNetworkType);
                    }
                    catch (Exception e) {
                        this.callOnError(e);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callOnError(@NonNull Throwable t) {
        Object object = this.mSync;
        synchronized (object) {
            if (HandlerUtils.isActive(this.mAsyncHandler)) {
                this.mAsyncHandler.post(() -> {
                    try {
                        this.mCallback.onError(t);
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                });
            }
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    @TargetApi(value=21)
    private void updateActiveNetwork(@Nullable Network network, @Nullable NetworkCapabilities caps, @Nullable LinkProperties props) {
        if (network != null) {
            ConnectivityManager manager = this.requireConnectivityManager();
            NetworkCapabilities capabilities = caps != null ? caps : manager.getNetworkCapabilities(network);
            LinkProperties properties = props != null ? props : manager.getLinkProperties(network);
            int activeNetworkType = 0;
            if (capabilities != null && properties != null) {
                if (ConnectivityHelper.isWifiNetworkReachable(manager, network, capabilities, properties)) {
                    activeNetworkType = 2;
                } else if (ConnectivityHelper.isMobileNetworkReachable(manager, network, capabilities, properties)) {
                    activeNetworkType = 1;
                } else if (ConnectivityHelper.isBluetoothNetworkReachable(manager, network, capabilities, properties)) {
                    activeNetworkType = 128;
                } else if (ConnectivityHelper.isNetworkReachable(manager, network, capabilities, properties)) {
                    activeNetworkType = 512;
                }
            }
            this.updateActiveNetwork(activeNetworkType);
        } else {
            this.updateActiveNetwork(0);
        }
    }

    private void updateActiveNetwork(@Nullable NetworkInfo activeNetworkInfo) {
        int type = activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting() ? activeNetworkInfo.getType() : -1;
        int activeNetworkType = 0;
        switch (type) {
            case -1: {
                break;
            }
            case 0: {
                activeNetworkType = 1;
                break;
            }
            case 1: {
                activeNetworkType = 2;
                break;
            }
            case 9: {
                activeNetworkType = 512;
            }
        }
        this.updateActiveNetwork(activeNetworkType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActiveNetwork(int activeNetworkType) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mActiveNetworkType != activeNetworkType) {
                int prev = this.mActiveNetworkType;
                this.mActiveNetworkType = activeNetworkType;
                this.callOnNetworkChanged(activeNetworkType, prev);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isWifiNetworkReachable(@NonNull Context context) {
        ConnectivityManager manager = ContextUtils.requireSystemService(context, ConnectivityManager.class);
        if (BuildCheck.isAPI23()) {
            Network network = manager.getActiveNetwork();
            NetworkCapabilities capabilities = manager.getNetworkCapabilities(network);
            LinkProperties properties = manager.getLinkProperties(network);
            return capabilities != null && properties != null && ConnectivityHelper.isWifiNetworkReachable(manager, network, capabilities, properties);
        }
        if (BuildCheck.isAPI21()) {
            Network[] allNetworks;
            for (Network network : allNetworks = manager.getAllNetworks()) {
                NetworkCapabilities capabilities = manager.getNetworkCapabilities(network);
                LinkProperties properties = manager.getLinkProperties(network);
                if (capabilities == null || properties == null || !ConnectivityHelper.isWifiNetworkReachable(manager, network, capabilities, properties)) continue;
                return true;
            }
        } else {
            NetworkInfo activeNetworkInfo = manager.getActiveNetworkInfo();
            if (activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting()) {
                int type = activeNetworkInfo.getType();
                return type == 1 || type == 6 || type == 7 || type == 9;
            }
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isMobileNetworkReachable(@NonNull Context context) {
        ConnectivityManager manager = ContextUtils.requireSystemService(context, ConnectivityManager.class);
        if (BuildCheck.isAPI23()) {
            Network network = manager.getActiveNetwork();
            NetworkCapabilities capabilities = manager.getNetworkCapabilities(network);
            LinkProperties properties = manager.getLinkProperties(network);
            return capabilities != null && properties != null && ConnectivityHelper.isMobileNetworkReachable(manager, network, capabilities, properties);
        }
        if (BuildCheck.isAPI21()) {
            Network[] allNetworks;
            for (Network network : allNetworks = manager.getAllNetworks()) {
                NetworkCapabilities capabilities = manager.getNetworkCapabilities(network);
                LinkProperties properties = manager.getLinkProperties(network);
                if (capabilities == null || properties == null || !ConnectivityHelper.isMobileNetworkReachable(manager, network, capabilities, properties)) continue;
                return true;
            }
        } else {
            NetworkInfo activeNetworkInfo = manager.getActiveNetworkInfo();
            if (activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting()) {
                int type = activeNetworkInfo.getType();
                return type == 0;
            }
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static boolean isNetworkReachable(@NonNull Context context) {
        ConnectivityManager manager = ContextUtils.requireSystemService(context, ConnectivityManager.class);
        if (BuildCheck.isAPI23()) {
            Network network = manager.getActiveNetwork();
            NetworkCapabilities capabilities = manager.getNetworkCapabilities(network);
            LinkProperties properties = manager.getLinkProperties(network);
            return capabilities != null && properties != null && ConnectivityHelper.isNetworkReachable(manager, network, capabilities, properties);
        }
        if (BuildCheck.isAPI21()) {
            Network[] allNetworks;
            for (Network network : allNetworks = manager.getAllNetworks()) {
                NetworkCapabilities capabilities = manager.getNetworkCapabilities(network);
                LinkProperties properties = manager.getLinkProperties(network);
                if (capabilities == null || properties == null || !ConnectivityHelper.isNetworkReachable(manager, network, capabilities, properties)) continue;
                return true;
            }
        } else {
            NetworkInfo activeNetworkInfo = manager.getActiveNetworkInfo();
            return activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting();
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    @TargetApi(value=21)
    private static boolean isWifiNetworkReachable(@NonNull ConnectivityManager manager, @NonNull Network network, @NonNull NetworkCapabilities capabilities, @NonNull LinkProperties linkProperties) {
        boolean isWiFi = BuildCheck.isAPI26() ? capabilities.hasTransport(1) || capabilities.hasTransport(3) : capabilities.hasTransport(1) || capabilities.hasTransport(3);
        return isWiFi && ConnectivityHelper.isNetworkReachable(manager, network, capabilities, linkProperties);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    @TargetApi(value=21)
    private static boolean isMobileNetworkReachable(@NonNull ConnectivityManager manager, @NonNull Network network, @NonNull NetworkCapabilities capabilities, @NonNull LinkProperties linkProperties) {
        boolean isMobile = BuildCheck.isAPI27() ? capabilities.hasTransport(0) || capabilities.hasTransport(6) : capabilities.hasTransport(0);
        return isMobile && ConnectivityHelper.isNetworkReachable(manager, network, capabilities, linkProperties);
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    @TargetApi(value=21)
    private static boolean isBluetoothNetworkReachable(@NonNull ConnectivityManager manager, @NonNull Network network, @NonNull NetworkCapabilities capabilities, @NonNull LinkProperties linkProperties) {
        return capabilities.hasTransport(2) && ConnectivityHelper.isNetworkReachable(manager, network, capabilities, linkProperties);
    }

    @SuppressLint(value={"NewApi"})
    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    @TargetApi(value=21)
    private static boolean isNetworkReachable(@NonNull ConnectivityManager manager, @NonNull Network network, @NonNull NetworkCapabilities capabilities, @NonNull LinkProperties linkProperties) {
        boolean hasCapability;
        boolean hasLinkAddress;
        boolean bl = hasLinkAddress = !linkProperties.getLinkAddresses().isEmpty();
        if (BuildCheck.isAPI29()) {
            hasCapability = hasLinkAddress && capabilities.hasCapability(12) && capabilities.hasCapability(16) && (capabilities.hasCapability(21) || capabilities.hasCapability(19));
        } else {
            NetworkInfo info = manager.getNetworkInfo(network);
            boolean bl2 = hasLinkAddress = hasLinkAddress && info.isConnectedOrConnecting();
            hasCapability = BuildCheck.isAPI28() ? hasLinkAddress && capabilities.hasCapability(12) && capabilities.hasCapability(16) && (capabilities.hasCapability(21) || capabilities.hasCapability(19)) : (BuildCheck.isAPI23() ? hasLinkAddress && capabilities.hasCapability(12) && capabilities.hasCapability(16) : hasLinkAddress && capabilities.hasCapability(12));
        }
        return hasCapability;
    }

    public static String getNetworkTypeString(int networkType) {
        switch (networkType) {
            case 0: {
                return "NON";
            }
            case 1: {
                return "MOBILE";
            }
            case 2: {
                return "WIFI";
            }
            case 128: {
                return "BLUETOOTH";
            }
            case 512: {
                return "ETHERNET";
            }
        }
        return String.format(Locale.US, "UNKNOWN(%d)", networkType);
    }

    @SuppressLint(value={"MissingPermission"})
    private static class NetworkChangedReceiver
    extends BroadcastReceiver {
        private static final String TAG = NetworkChangedReceiver.class.getSimpleName();
        @NonNull
        private final ConnectivityHelper mParent;

        public NetworkChangedReceiver(@NonNull ConnectivityHelper parent) {
            this.mParent = parent;
        }

        public void onReceive(Context context, Intent intent) {
            String action;
            String string2 = action = intent != null ? intent.getAction() : null;
            if (ConnectivityHelper.ACTION_GLOBAL_CONNECTIVITY_CHANGE.equals(action)) {
                ConnectivityManager manager = ContextUtils.requireSystemService(context, ConnectivityManager.class);
                this.mParent.updateActiveNetwork(manager.getActiveNetworkInfo());
            }
        }
    }

    @TargetApi(value=21)
    private class MyNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private final String TAG = MyNetworkCallback.class.getSimpleName();

        @SuppressLint(value={"MissingPermission"})
        public void onAvailable(@NonNull Network network) {
            super.onAvailable(network);
            ConnectivityHelper.this.updateActiveNetwork(network, null, null);
        }

        @SuppressLint(value={"MissingPermission"})
        public void onCapabilitiesChanged(@NonNull Network network, @NonNull NetworkCapabilities networkCapabilities) {
            super.onCapabilitiesChanged(network, networkCapabilities);
            ConnectivityHelper.this.updateActiveNetwork(network, networkCapabilities, null);
        }

        @SuppressLint(value={"MissingPermission"})
        public void onLinkPropertiesChanged(@NonNull Network network, @NonNull LinkProperties linkProperties) {
            super.onLinkPropertiesChanged(network, linkProperties);
            ConnectivityHelper.this.updateActiveNetwork(network, null, linkProperties);
        }

        @SuppressLint(value={"MissingPermission"})
        public void onLosing(@NonNull Network network, int maxMsToLive) {
            super.onLosing(network, maxMsToLive);
            ConnectivityHelper.this.updateActiveNetwork(network, null, null);
        }

        @SuppressLint(value={"MissingPermission"})
        public void onLost(@NonNull Network network) {
            super.onLost(network);
            ConnectivityHelper.this.updateActiveNetwork(network, null, null);
        }

        public void onUnavailable() {
            super.onUnavailable();
            ConnectivityHelper.this.updateActiveNetwork(0);
        }
    }

    @TargetApi(value=21)
    private class MyOnNetworkActiveListener
    implements ConnectivityManager.OnNetworkActiveListener {
        private final String TAG = MyOnNetworkActiveListener.class.getSimpleName();

        @SuppressLint(value={"MissingPermission", "NewApi"})
        public void onNetworkActive() {
            try {
                if (BuildCheck.isAPI23()) {
                    ConnectivityHelper.this.updateActiveNetwork(ConnectivityHelper.this.requireConnectivityManager().getActiveNetwork(), null, null);
                } else {
                    ConnectivityHelper.this.updateActiveNetwork(ConnectivityHelper.this.requireConnectivityManager().getActiveNetworkInfo());
                }
            }
            catch (Exception e) {
                Log.w((String)this.TAG, (Throwable)e);
            }
        }
    }

    public static interface ConnectivityCallback {
        @AnyThread
        public void onNetworkChanged(int var1, int var2);

        @AnyThread
        public void onError(@NonNull Throwable var1);
    }
}

