/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediastore;

import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import com.serenegiant.common.R;
import com.serenegiant.graphics.BitmapHelper;
import com.serenegiant.mediastore.ImageLoader;
import com.serenegiant.mediastore.LoaderDrawable;
import com.serenegiant.mediastore.MediaInfo;
import com.serenegiant.mediastore.MediaStoreUtils;
import com.serenegiant.utils.ThreadPool;
import com.serenegiant.view.ViewUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MediaStoreImageAdapter
extends PagerAdapter {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaStoreImageAdapter.class.getSimpleName();
    @NonNull
    private final Context mContext;
    @NonNull
    private final LayoutInflater mInflater;
    private final int mLayoutId;
    @NonNull
    private final ContentResolver mCr;
    @NonNull
    private final MyAsyncQueryHandler mQueryHandler;
    protected boolean mDataValid;
    protected ChangeObserver mChangeObserver;
    protected DataSetObserver mDataSetObserver;
    private Cursor mCursor;
    private final String mSelection = MediaStoreUtils.SELECTIONS[1];
    private String[] mSelectionArgs = null;
    @NonNull
    private final MediaInfo info = new MediaInfo();
    @NonNull
    private final List<Integer> mValues = new ArrayList<Integer>();
    private boolean mNeedValidate;
    private boolean mShowTitle;

    public MediaStoreImageAdapter(@NonNull Context context, @LayoutRes int id_layout) {
        this(context, id_layout, true);
    }

    public MediaStoreImageAdapter(@NonNull Context context, @LayoutRes int id_layout, boolean refreshNow) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.mLayoutId = id_layout;
        this.mCr = context.getContentResolver();
        this.mQueryHandler = new MyAsyncQueryHandler(this.mCr, this);
        this.mNeedValidate = true;
        if (refreshNow) {
            this.refresh();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.changeCursor(null);
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        List<Integer> list = this.mValues;
        synchronized (list) {
            return this.mValues.size();
        }
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        View view = this.mInflater.inflate(this.mLayoutId, container, false);
        if (view != null) {
            container.addView(view);
            ViewHolder holder = (ViewHolder)view.getTag();
            if (holder == null) {
                holder = new ViewHolder();
            }
            holder.mImageView = ViewUtils.findIconView(view);
            holder.mTitleView = ViewUtils.findTitleView(view);
            this.info.loadFromCursor(this.getCursor(position));
            Drawable drawable2 = holder.mImageView.getDrawable();
            if (!(drawable2 instanceof LoaderDrawable)) {
                drawable2 = this.createLoaderDrawable(this.mContext, this.info);
                holder.mImageView.setImageDrawable(drawable2);
            }
            ((LoaderDrawable)drawable2).startLoad(this.info);
            if (holder.mTitleView != null) {
                holder.mTitleView.setVisibility(this.mShowTitle ? 0 : 8);
                if (this.mShowTitle) {
                    holder.mTitleView.setText((CharSequence)this.info.title);
                }
            }
        }
        return view;
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        if (object instanceof View) {
            container.removeView((View)object);
        }
    }

    public int getItemPosition(@NonNull Object object) {
        return super.getItemPosition(object);
    }

    public void setValidateItems(boolean needValidate) {
        if (this.mNeedValidate != needValidate) {
            this.mNeedValidate = needValidate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getItemPositionFromID(long id2) {
        int result;
        block7: {
            result = -1;
            Cursor cursor = this.mCr.query(MediaStoreUtils.QUERY_URI_FILES, MediaStoreUtils.PROJ_MEDIA, this.mSelection, this.mSelectionArgs, null);
            if (cursor != null) {
                try {
                    if (!cursor.moveToFirst()) break block7;
                    int ix = 0;
                    while (true) {
                        if (cursor.getLong(0) == id2) {
                            result = ix;
                            break;
                        }
                        if (!cursor.moveToNext()) {
                            break;
                        }
                        ++ix;
                    }
                }
                finally {
                    cursor.close();
                }
            }
        }
        return result;
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view.equals(object);
    }

    @NonNull
    public MediaInfo getMediaInfo(int position) {
        return this.getMediaInfo(position, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public synchronized MediaInfo getMediaInfo(int position, @Nullable MediaInfo info) {
        int pos;
        MediaInfo _info = info != null ? info : new MediaInfo();
        List<Integer> list = this.mValues;
        synchronized (list) {
            pos = this.mValues.get(position);
        }
        if (this.mCursor == null) {
            throw new IllegalStateException("Cursor is not ready!");
        }
        if (this.mCursor.moveToPosition(pos)) {
            _info.loadFromCursor(this.mCursor);
        }
        return _info;
    }

    protected void changeCursor(@Nullable Cursor cursor) {
        Cursor old = this.swapCursor(cursor);
        if (old != null && !old.isClosed()) {
            old.close();
        }
    }

    protected Cursor getCursor(int position) {
        if (this.mDataValid && this.mCursor != null) {
            this.mCursor.moveToPosition(position);
            return this.mCursor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Cursor swapCursor(@Nullable Cursor newCursor) {
        if (newCursor == this.mCursor) {
            return null;
        }
        Cursor oldCursor = this.mCursor;
        if (oldCursor != null) {
            if (this.mChangeObserver != null) {
                oldCursor.unregisterContentObserver((ContentObserver)this.mChangeObserver);
            }
            if (this.mDataSetObserver != null) {
                oldCursor.unregisterDataSetObserver(this.mDataSetObserver);
            }
        }
        this.mCursor = newCursor;
        if (newCursor != null) {
            if (this.mChangeObserver != null) {
                newCursor.registerContentObserver((ContentObserver)this.mChangeObserver);
            }
            if (this.mDataSetObserver != null) {
                newCursor.registerDataSetObserver(this.mDataSetObserver);
            }
            List<Integer> list = this.mValues;
            synchronized (list) {
                this.mValues.clear();
                if (newCursor.moveToFirst()) {
                    int pos = 0;
                    do {
                        this.info.loadFromCursor(newCursor);
                        if (!this.mNeedValidate || this.info.canRead(this.mCr)) {
                            this.mValues.add(pos);
                        }
                        ++pos;
                    } while (newCursor.moveToNext());
                }
            }
            this.mDataValid = true;
            this.notifyDataSetChanged();
        } else {
            List<Integer> list = this.mValues;
            synchronized (list) {
                this.mValues.clear();
            }
            this.mDataValid = false;
            this.notifyDataSetInvalidated();
        }
        return oldCursor;
    }

    public void notifyDataSetInvalidated() {
    }

    public void refresh() {
        ThreadPool.preStartAllCoreThreads();
        this.mQueryHandler.requery();
    }

    protected LoaderDrawable createLoaderDrawable(@NonNull Context context, @NonNull MediaInfo info) {
        return new ImageLoaderDrawable(context, info.width, info.height);
    }

    private static class MyImageLoader
    extends ImageLoader {
        public MyImageLoader(ImageLoaderDrawable parent) {
            super(parent);
        }

        @Override
        protected Bitmap loadBitmap(@NonNull Context context, @NonNull MediaInfo info, int requestWidth, int requestHeight) {
            Bitmap result = null;
            try {
                result = BitmapHelper.asBitmap(context.getContentResolver(), info.id, requestWidth, requestHeight);
                if (result != null) {
                    int w = result.getWidth();
                    int h = result.getHeight();
                    Rect bounds = new Rect();
                    this.mParent.copyBounds(bounds);
                    int cx = bounds.centerX();
                    int cy = bounds.centerY();
                    bounds.set(cx - w / 2, cy - h / w, cx + w / 2, cy + h / 2);
                    this.mParent.onBoundsChange(bounds);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (result == null) {
                result = this.loadDefaultBitmap(context, R.drawable.ic_error_outline_red_24dp);
            }
            return result;
        }
    }

    private static class ImageLoaderDrawable
    extends LoaderDrawable {
        public ImageLoaderDrawable(@NonNull Context context, int width, int height) {
            super(context, width, height);
        }

        @Override
        @NonNull
        protected ImageLoader createImageLoader() {
            return new MyImageLoader(this);
        }

        @Override
        protected Bitmap checkCache(long id2) {
            return null;
        }
    }

    private class MyDataSetObserver
    extends DataSetObserver {
        private MyDataSetObserver() {
        }

        public void onChanged() {
            MediaStoreImageAdapter.this.mDataValid = true;
            MediaStoreImageAdapter.this.notifyDataSetChanged();
        }

        public void onInvalidated() {
            MediaStoreImageAdapter.this.mDataValid = false;
            MediaStoreImageAdapter.this.notifyDataSetInvalidated();
        }
    }

    private class ChangeObserver
    extends ContentObserver {
        public ChangeObserver() {
            super(new Handler());
        }

        public boolean deliverSelfNotifications() {
            return true;
        }

        public void onChange(boolean selfChange) {
            MediaStoreImageAdapter.this.refresh();
        }
    }

    private static final class MyAsyncQueryHandler
    extends AsyncQueryHandler {
        @NonNull
        private final MediaStoreImageAdapter mAdapter;

        public MyAsyncQueryHandler(@NonNull ContentResolver cr, @NonNull MediaStoreImageAdapter adapter) {
            super(cr);
            this.mAdapter = adapter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requery() {
            MediaStoreImageAdapter mediaStoreImageAdapter = this.mAdapter;
            synchronized (mediaStoreImageAdapter) {
                this.startQuery(0, (Object)this.mAdapter, MediaStoreUtils.QUERY_URI_IMAGES, MediaStoreUtils.PROJ_MEDIA_IMAGE, this.mAdapter.mSelection, this.mAdapter.mSelectionArgs, null);
            }
        }

        protected void onQueryComplete(int token, Object cookie, Cursor cursor) {
            Cursor oldCursor = this.mAdapter.swapCursor(cursor);
            if (oldCursor != null && !oldCursor.isClosed()) {
                oldCursor.close();
            }
        }
    }

    private static final class ViewHolder {
        TextView mTitleView;
        ImageView mImageView;

        private ViewHolder() {
        }
    }
}

