/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaScannerConnection;
import android.os.Environment;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;
import com.serenegiant.media.IMediaQueue;
import com.serenegiant.media.IMuxer;
import com.serenegiant.media.MemMediaQueue;
import com.serenegiant.media.RecycleMediaData;
import com.serenegiant.media.VideoConfig;
import com.serenegiant.mediastore.MediaStoreUtils;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.PermissionUtils;
import com.serenegiant.system.StorageInfo;
import com.serenegiant.system.StorageUtils;
import com.serenegiant.system.Time;
import com.serenegiant.utils.FileUtils;
import com.serenegiant.utils.UriHelper;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class MediaSplitMuxerV2
implements IMuxer {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaSplitMuxerV2.class.getSimpleName();
    private static final String DEFAULT_PREFIX_SEGMENT_NAME = "";
    public static String PREFIX_SEGMENT_NAME = "";
    private static final int INI_POOL_NUM = 4;
    private static final int MAX_POOL_NUM = 1000;
    private static final long DEFAULT_SPLIT_SIZE = 4000000000L;
    private static final String EXT_MP4 = "mp4";
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final WeakReference<Context> mWeakContext;
    @NonNull
    private final MediaFormat[] mMediaFormats = new MediaFormat[2];
    @NonNull
    private final String mSegmentPrefix;
    @NonNull
    private final VideoConfig mVideoConfig;
    @NonNull
    private final IMuxer.IMuxerFactory mMuxerFactory;
    @NonNull
    private final IMediaQueue<RecycleMediaData> mQueue;
    private final long mSplitSize;
    @NonNull
    private final String mOutputDirName;
    @Nullable
    private final DocumentFile mOutputDir;
    private int mVideoTrackIx = -1;
    private int mAudioTrackIx = -1;
    private DocumentFile mCurrent;
    private volatile boolean mIsRunning;
    private volatile boolean mRequestStop;
    private boolean mReleased;
    private int mLastTrackIndex = -1;
    @Nullable
    private IMuxer mMuxer;
    @Nullable
    private MuxTask mMuxTask;
    private static final long MAX_CHECK_INTERVALS_NS = 3000000000L;
    private static final long STORAGE_SIZE_LIMIT = 0x100000000L;
    private static final long MIN_FREE_SPACE = 0x1000000L;

    public MediaSplitMuxerV2(@NonNull Context context, @Nullable DocumentFile outputDir, @Nullable VideoConfig config, @Nullable IMuxer.IMuxerFactory factory, @Nullable IMediaQueue<RecycleMediaData> queue, long splitSize) throws IOException {
        this.mWeakContext = new WeakReference<Context>(context);
        this.mVideoConfig = config != null ? config : new VideoConfig();
        this.mMuxerFactory = factory != null ? factory : new IMuxer.DefaultFactory();
        this.mQueue = queue != null ? queue : new MemMediaQueue(4, 1000);
        this.mSplitSize = splitSize <= 0L ? 4000000000L : splitSize;
        this.mSegmentPrefix = PREFIX_SEGMENT_NAME != null ? PREFIX_SEGMENT_NAME : DEFAULT_PREFIX_SEGMENT_NAME;
        this.mOutputDirName = FileUtils.getDateTimeString();
        if (outputDir != null) {
            this.mOutputDir = outputDir;
        } else if (!BuildCheck.isAPI29() && PermissionUtils.hasWriteExternalStorage(context)) {
            File dir = FileUtils.getCaptureDir(context, Environment.DIRECTORY_MOVIES);
            if (dir != null) {
                dir = new File(dir, this.mOutputDirName);
                dir.mkdirs();
                this.mOutputDir = DocumentFile.fromFile((File)dir);
            } else {
                this.mOutputDir = null;
            }
        } else {
            this.mOutputDir = null;
        }
        this.mMuxer = this.createMuxer(0);
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mReleased) {
                this.mReleased = true;
                if (this.mIsRunning && !this.mRequestStop) {
                    this.stop();
                }
                this.mIsRunning = false;
                this.mQueue.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStarted() {
        Object object = this.mSync;
        synchronized (object) {
            return !this.mReleased && this.mIsRunning;
        }
    }

    @Override
    public synchronized void start() throws IllegalStateException {
        if (!this.mReleased && !this.mIsRunning) {
            if (this.mMediaFormats[0] == null && this.mMediaFormats[1] == null) {
                throw new IllegalStateException("no added track");
            }
        } else {
            throw new IllegalStateException("already released or started");
        }
        this.mIsRunning = true;
        this.mRequestStop = false;
        this.mMuxTask = new MuxTask();
        new Thread((Runnable)this.mMuxTask, "MuxTask").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        Object object = this.mSync;
        synchronized (object) {
            this.mRequestStop = true;
            this.mMuxTask = null;
            this.mAudioTrackIx = -1;
            this.mVideoTrackIx = -1;
            this.mLastTrackIndex = -1;
            this.mMediaFormats[1] = null;
            this.mMediaFormats[0] = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int addTrack(@NonNull MediaFormat format) throws IllegalArgumentException, IllegalStateException {
        int result = this.mLastTrackIndex + 1;
        switch (result) {
            case 0: 
            case 1: {
                if (!format.containsKey("mime")) throw new IllegalArgumentException("has no mime type");
                String mime = format.getString("mime");
                if (mime.startsWith("video/")) {
                    result = this.mVideoTrackIx = this.mMuxer.addTrack(format);
                    this.mMediaFormats[result] = format;
                } else {
                    if (!mime.startsWith("audio/")) throw new IllegalArgumentException("un-expected mime type");
                    result = this.mAudioTrackIx = this.mMuxer.addTrack(format);
                    this.mMediaFormats[result] = format;
                }
                ++this.mLastTrackIndex;
                return result;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void writeSampleData(int trackIx, @NonNull ByteBuffer buffer, @NonNull MediaCodec.BufferInfo info) {
        RecycleMediaData buf;
        if (!this.mRequestStop && trackIx <= this.mLastTrackIndex && (buf = this.mQueue.obtain(new Object[0])) != null) {
            buffer.clear();
            buf.set(trackIx, buffer, info);
            this.mQueue.queueFrame(buf);
        }
    }

    protected void internalWriteSampleData(@NonNull IMuxer muxer, int trackIx, @NonNull ByteBuffer buffer, @NonNull MediaCodec.BufferInfo info) {
        muxer.writeSampleData(trackIx, buffer, info);
    }

    @Nullable
    protected Context getContext() {
        return (Context)this.mWeakContext.get();
    }

    @NonNull
    protected Context requireContext() throws IllegalStateException {
        Context context = (Context)this.mWeakContext.get();
        if (context == null) {
            throw new IllegalStateException();
        }
        return context;
    }

    @NonNull
    public VideoConfig getConfig() {
        return this.mVideoConfig;
    }

    protected boolean checkFreespace() {
        long freeBytes;
        long totalBytes;
        float rate;
        StorageInfo info = null;
        if (this.mCurrent != null) {
            try {
                info = StorageUtils.getStorageInfo(this.requireContext(), this.mCurrent);
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        if (info == null) {
            try {
                info = StorageUtils.getStorageInfo(this.getContext(), Environment.DIRECTORY_MOVIES);
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        if (info != null && info.totalBytes > 0L) {
            rate = (float)info.freeBytes / (float)info.totalBytes;
            totalBytes = info.totalBytes;
            freeBytes = info.freeBytes;
        } else {
            rate = 0.0f;
            freeBytes = 0L;
            totalBytes = 0L;
        }
        return rate < FileUtils.FREE_RATIO && totalBytes < 0x100000000L || freeBytes < 0x1000000L;
    }

    private IMuxer restartMuxer(@NonNull IMuxer muxer, int segment) throws IOException {
        try {
            muxer.stop();
            muxer.release();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return this.setupMuxer(segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMuxer setupMuxer(int segment) throws IOException {
        IMuxer result = this.createMuxer(segment);
        int n = 0;
        Object object = this.mSync;
        synchronized (object) {
            int trackIx;
            if (this.mMediaFormats[0] != null) {
                trackIx = result.addTrack(this.mMediaFormats[0]);
                ++n;
            }
            if (this.mMediaFormats[1] != null) {
                trackIx = result.addTrack(this.mMediaFormats[1]);
                ++n;
            }
        }
        if (n <= 0) {
            throw new IOException("already released?");
        }
        result.start();
        return result;
    }

    private IMuxer createMuxer(int segment) throws IOException {
        if (this.mCurrent != null) {
            Context context = this.requireContext();
            if (BuildCheck.isAPI29()) {
                MediaStoreUtils.updateContentUri(context, this.mCurrent);
            } else if (UriHelper.isFileUri(this.mCurrent)) {
                String path = UriHelper.getPath(context, this.mCurrent.getUri());
                try {
                    MediaScannerConnection.scanFile((Context)context, (String[])new String[]{path}, null, null);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
            }
        }
        this.mCurrent = this.createOutputDoc(segment);
        return this.createMuxer(this.requireContext(), this.mCurrent);
    }

    @NonNull
    protected DocumentFile createOutputDoc(int segment) throws IOException {
        File dir;
        String fileName = String.format(Locale.US, "%s%04d.%s", this.mSegmentPrefix, segment + 1, EXT_MP4);
        Context context = this.requireContext();
        if (this.mOutputDir != null) {
            DocumentFile dir2 = this.mOutputDir.isDirectory() ? this.mOutputDir : this.mOutputDir.getParentFile();
            return this.mOutputDir.createFile(null, fileName);
        }
        if (BuildCheck.isAPI29()) {
            return MediaStoreUtils.getContentDocument(context, "video/mp4", Environment.DIRECTORY_MOVIES + "/" + FileUtils.getDirName() + "/" + this.mOutputDirName, fileName, null);
        }
        if (PermissionUtils.hasWriteExternalStorage(context) && (dir = FileUtils.getCaptureDir(context, Environment.DIRECTORY_MOVIES)) != null) {
            dir = new File(dir, this.mOutputDirName);
            dir.mkdirs();
            DocumentFile output = DocumentFile.fromFile((File)dir);
            return output.createFile(null, fileName);
        }
        throw new IOException("Failed to create output DocumentFile");
    }

    @SuppressLint(value={"NewApi"})
    private IMuxer createMuxer(@NonNull Context context, @NonNull DocumentFile output) throws IOException {
        boolean useMediaMuxer = this.getConfig().useMediaMuxer();
        IMuxer result = this.mMuxerFactory.createMuxer(context, useMediaMuxer, output);
        if (result == null) {
            throw new IOException("Failed to create muxer");
        }
        return result;
    }

    static /* synthetic */ IMuxer access$100(MediaSplitMuxerV2 x0) {
        return x0.mMuxer;
    }

    static /* synthetic */ IMuxer access$102(MediaSplitMuxerV2 x0, IMuxer x1) {
        x0.mMuxer = x1;
        return x0.mMuxer;
    }

    static /* synthetic */ IMuxer access$200(MediaSplitMuxerV2 x0, int x1) throws IOException {
        return x0.setupMuxer(x1);
    }

    static /* synthetic */ String access$300() {
        return TAG;
    }

    static /* synthetic */ int access$400(MediaSplitMuxerV2 x0) {
        return x0.mVideoTrackIx;
    }

    static /* synthetic */ boolean access$500(MediaSplitMuxerV2 x0) {
        return x0.mIsRunning;
    }

    static /* synthetic */ IMediaQueue access$600(MediaSplitMuxerV2 x0) {
        return x0.mQueue;
    }

    static /* synthetic */ boolean access$502(MediaSplitMuxerV2 x0, boolean x1) {
        x0.mIsRunning = x1;
        return x0.mIsRunning;
    }

    static /* synthetic */ IMuxer access$700(MediaSplitMuxerV2 x0, IMuxer x1, int x2) throws IOException {
        return x0.restartMuxer(x1, x2);
    }

    static /* synthetic */ boolean access$800(MediaSplitMuxerV2 x0) {
        return x0.mRequestStop;
    }

    static /* synthetic */ DocumentFile access$900(MediaSplitMuxerV2 x0) {
        return x0.mCurrent;
    }

    static /* synthetic */ long access$1000(MediaSplitMuxerV2 x0) {
        return x0.mSplitSize;
    }

    static /* synthetic */ boolean access$802(MediaSplitMuxerV2 x0, boolean x1) {
        x0.mRequestStop = x1;
        return x0.mRequestStop;
    }

    private final class MuxTask
    implements Runnable {
        private MuxTask() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block19: {
                context = MediaSplitMuxerV2.this.getContext();
                if (context == null) break block19;
                muxer = MediaSplitMuxerV2.access$100(MediaSplitMuxerV2.this);
                MediaSplitMuxerV2.access$102(MediaSplitMuxerV2.this, null);
                try {
                    if (muxer == null) {
                        try {
                            muxer = MediaSplitMuxerV2.access$200(MediaSplitMuxerV2.this, 0);
                        }
                        catch (IOException e) {
                            Log.w((String)MediaSplitMuxerV2.access$300(), (Throwable)e);
                            return;
                        }
                    } else {
                        muxer.start();
                    }
                    info = new MediaCodec.BufferInfo();
                    shouldCheckIFrame = MediaSplitMuxerV2.access$400(MediaSplitMuxerV2.this) >= 0;
                    prevCheckTime = Time.nanoTime();
                    bytesWrote = 0L;
                    mRequestChangeFile = false;
                    segment = 1;
                    cnt = 0;
                    while (MediaSplitMuxerV2.access$500(MediaSplitMuxerV2.this)) {
                        block20: {
                            try {
                                buf = (RecycleMediaData)MediaSplitMuxerV2.access$600(MediaSplitMuxerV2.this).poll(10L, TimeUnit.MILLISECONDS);
                            }
                            catch (InterruptedException e) {
                                MediaSplitMuxerV2.access$502(MediaSplitMuxerV2.this, false);
                                break;
                            }
                            if (buf == null) break block20;
                            buf.get(info);
                            if (mRequestChangeFile && (!shouldCheckIFrame || info.flags == 1)) {
                                mRequestChangeFile = false;
                                try {
                                    muxer = MediaSplitMuxerV2.access$700(MediaSplitMuxerV2.this, muxer, segment++);
                                    bytesWrote = 0L;
                                }
                                catch (IOException e) {
                                    break;
                                }
                            }
                            MediaSplitMuxerV2.this.internalWriteSampleData(muxer, buf.trackIx(), buf.get(), info);
                            bytesWrote += (long)Math.max(info.size, 0);
                            MediaSplitMuxerV2.access$600(MediaSplitMuxerV2.this).recycle(buf);
                            ** GOTO lbl-1000
                        }
                        if (MediaSplitMuxerV2.access$800(MediaSplitMuxerV2.this)) {
                            MediaSplitMuxerV2.access$502(MediaSplitMuxerV2.this, false);
                        } else lbl-1000:
                        // 2 sources

                        {
                            if (mRequestChangeFile || ++cnt % 1000 != 0 && Time.nanoTime() - prevCheckTime <= 3000000000L) continue;
                            prevCheckTime = Time.nanoTime();
                            length = Math.max(bytesWrote, MediaSplitMuxerV2.access$900(MediaSplitMuxerV2.this).length());
                            if (length >= MediaSplitMuxerV2.access$1000(MediaSplitMuxerV2.this)) {
                                mRequestChangeFile = true;
                            }
                            if (!MediaSplitMuxerV2.this.checkFreespace()) continue;
                            MediaSplitMuxerV2.access$802(MediaSplitMuxerV2.this, true);
                            MediaSplitMuxerV2.access$502(MediaSplitMuxerV2.this, false);
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    Log.w((String)MediaSplitMuxerV2.access$300(), (Throwable)e);
                }
                if (muxer != null) {
                    try {
                        muxer.stop();
                        muxer.release();
                    }
                    catch (Exception e) {
                        Log.w((String)MediaSplitMuxerV2.access$300(), (Throwable)e);
                    }
                }
            }
            MediaSplitMuxerV2.access$502(MediaSplitMuxerV2.this, false);
        }
    }
}

