/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import androidx.annotation.NonNull;
import com.serenegiant.media.PostMuxCommon;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

abstract class MediaRawFileWriter
extends PostMuxCommon {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaRawFileWriter.class.getSimpleName();
    private DataOutputStream mOut;
    private int mFrameCounts;
    private byte[] temp;

    public static MediaRawFileWriter newInstance(@NonNull Context context, int mediaType, @NonNull MediaFormat configFormat, @NonNull MediaFormat outputFormat, @NonNull String tempDir) throws IOException {
        switch (mediaType) {
            case 0: {
                return new MediaRawVideoWriter(context, configFormat, outputFormat, tempDir);
            }
            case 1: {
                return new MediaRawAudioWriter(context, configFormat, outputFormat, tempDir);
            }
        }
        throw new IOException("Unexpected media type=" + mediaType);
    }

    private MediaRawFileWriter(@NonNull Context context, @NonNull MediaFormat configFormat, @NonNull MediaFormat outputFormat, @NonNull String tempDir, @NonNull String name) throws IOException {
        this.mOut = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tempDir.endsWith("/") ? tempDir + name : tempDir + "/" + name, false)));
        MediaRawFileWriter.writeFormat(this.mOut, configFormat, outputFormat);
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void release() {
        if (this.mOut != null) {
            try {
                this.mOut.flush();
                this.mOut.close();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            this.mOut = null;
        }
    }

    public synchronized void writeSampleData(@NonNull ByteBuffer buffer, @NonNull MediaCodec.BufferInfo info) throws IOException {
        if (info.size != 0) {
            if (this.temp == null || this.temp.length < info.size) {
                this.temp = new byte[info.size];
            }
            ++this.mFrameCounts;
            MediaRawFileWriter.writeStream(this.mOut, 0, this.mFrameCounts, info, buffer, this.temp);
        }
    }

    private static class MediaRawAudioWriter
    extends MediaRawFileWriter {
        public MediaRawAudioWriter(@NonNull Context context, @NonNull MediaFormat configFormat, @NonNull MediaFormat outputFormat, @NonNull String tempDir) throws IOException {
            super(context, configFormat, outputFormat, tempDir, "audio.raw");
        }
    }

    private static class MediaRawVideoWriter
    extends MediaRawFileWriter {
        public MediaRawVideoWriter(@NonNull Context context, @NonNull MediaFormat configFormat, @NonNull MediaFormat outputFormat, @NonNull String tempDir) throws IOException {
            super(context, configFormat, outputFormat, tempDir, "video.raw");
        }
    }
}

