/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.documentfile.provider.DocumentFile;
import com.serenegiant.media.IMuxer;
import com.serenegiant.mediastore.MediaStoreOutputStream;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.utils.UriHelper;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

@TargetApi(value=18)
public class MediaMuxerWrapper
implements IMuxer {
    private static final String TAG = MediaMuxerWrapper.class.getSimpleName();
    public static boolean USE_MEDIASTORE_OUTPUT_STREAM = true;
    @NonNull
    private final MediaMuxer mMuxer;
    @Nullable
    private final OutputStream mOutputStream;
    @Nullable
    private final String mOutputPath;
    private volatile boolean mIsStarted;
    private boolean mReleased;

    @Nullable
    public static MediaMuxerWrapper newInstance(@NonNull Context context, @NonNull DocumentFile output, int format) throws IOException {
        Uri uri = output.getUri();
        if (BuildCheck.isAPI29() && UriHelper.isContentUri(uri)) {
            return new MediaMuxerWrapper(new MediaStoreOutputStream(context, output), format);
        }
        if (BuildCheck.isAPI26()) {
            if (USE_MEDIASTORE_OUTPUT_STREAM) {
                return new MediaMuxerWrapper(new MediaStoreOutputStream(context, output), format);
            }
            return new MediaMuxerWrapper(context.getContentResolver().openFileDescriptor(uri, "rw").getFileDescriptor(), format);
        }
        String path = UriHelper.getPath(context, uri);
        File f = new File(path);
        if (f.canWrite()) {
            return new MediaMuxerWrapper(path, format);
        }
        return null;
    }

    public MediaMuxerWrapper(@NonNull String outputPath, int format) throws IOException {
        this.mMuxer = new MediaMuxer(outputPath, format);
        this.mOutputStream = null;
        this.mOutputPath = outputPath;
    }

    @RequiresApi(api=26)
    public MediaMuxerWrapper(FileDescriptor fd, int format) throws IOException {
        this.mMuxer = new MediaMuxer(fd, format);
        this.mOutputStream = null;
        this.mOutputPath = null;
    }

    @RequiresApi(api=26)
    public MediaMuxerWrapper(@NonNull FileOutputStream output, int format) throws IOException {
        this.mMuxer = new MediaMuxer(output.getFD(), format);
        this.mOutputStream = output;
        this.mOutputPath = null;
    }

    @RequiresApi(api=26)
    public MediaMuxerWrapper(@NonNull MediaStoreOutputStream output, int format) throws IOException {
        this.mMuxer = new MediaMuxer(output.getFd(), format);
        this.mOutputStream = output;
        this.mOutputPath = output.getOutputPath();
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    @Deprecated
    @Nullable
    public String getOutputPath() {
        return this.mOutputPath;
    }

    @Override
    public int addTrack(@NonNull MediaFormat format) {
        return this.mMuxer.addTrack(format);
    }

    @Override
    public void writeSampleData(int trackIndex, @NonNull ByteBuffer byteBuf, @NonNull MediaCodec.BufferInfo bufferInfo) {
        if (!this.mReleased) {
            this.mMuxer.writeSampleData(trackIndex, byteBuf, bufferInfo);
        }
    }

    @Override
    public void start() {
        this.mMuxer.start();
        this.mIsStarted = true;
    }

    @Override
    public void stop() {
        if (this.mIsStarted) {
            this.mIsStarted = false;
            this.mMuxer.stop();
        }
    }

    @Override
    public void release() {
        this.mIsStarted = false;
        if (!this.mReleased) {
            this.mReleased = true;
            try {
                this.mMuxer.release();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            try {
                if (this.mOutputStream != null) {
                    this.mOutputStream.close();
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.mIsStarted && !this.mReleased;
    }
}

