/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.serenegiant.egl.EGLBase;
import com.serenegiant.egl.EglTask;
import com.serenegiant.gl.GLConst;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLTexture;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.gl.RendererTarget;
import com.serenegiant.glutils.IMirror;
import com.serenegiant.math.Fraction;

public class StaticTextureSource
implements GLConst,
IMirror {
    private static final boolean DEBUG = false;
    private static final String TAG = StaticTextureSource.class.getSimpleName();
    private final Object mSync = new Object();
    private RendererTask mRendererTask;
    private static final int REQUEST_DRAW = 1;
    private static final int REQUEST_ADD_SURFACE = 3;
    private static final int REQUEST_REMOVE_SURFACE = 4;
    private static final int REQUEST_MIRROR = 6;
    private static final int REQUEST_SET_BITMAP = 7;
    private final Runnable mOnFrameTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long ms = StaticTextureSource.this.mRendererTask.mIntervalsNs / 1000000L;
            int ns = (int)(StaticTextureSource.this.mRendererTask.mIntervalsNs % 1000000L);
            while (StaticTextureSource.this.isRunning()) {
                try {
                    RendererTask task;
                    Object object = StaticTextureSource.this.mSync;
                    synchronized (object) {
                        StaticTextureSource.this.mSync.wait(ms, ns);
                        task = StaticTextureSource.this.mRendererTask;
                    }
                    if (task == null || task.mImageSource == null) continue;
                    task.removeRequest(1);
                    task.offer(1);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
            }
        }
    };

    public StaticTextureSource(@Nullable Bitmap bitmap) {
        this(bitmap, new Fraction(10));
    }

    public StaticTextureSource(@Nullable Fraction fps) {
        this(null, fps);
    }

    public StaticTextureSource(@Nullable Bitmap bitmap, @Nullable Fraction fps) {
        int width = bitmap != null ? bitmap.getWidth() : 1;
        int height = bitmap != null ? bitmap.getHeight() : 1;
        this.mRendererTask = new RendererTask(this, width, height, fps);
        new Thread((Runnable)this.mRendererTask, TAG).start();
        if (!this.mRendererTask.waitReady()) {
            throw new RuntimeException("failed to start renderer thread");
        }
        this.setBitmap(bitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mRendererTask != null && this.mRendererTask.isRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        RendererTask task;
        Object object = this.mSync;
        synchronized (object) {
            task = this.mRendererTask;
            this.mRendererTask = null;
            this.mSync.notifyAll();
        }
        if (task != null) {
            task.release();
        }
    }

    public void addSurface(int id2, Object surface, boolean isRecordable) {
        this.addSurface(id2, surface, isRecordable, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSurface(int id2, Object surface, boolean isRecordable, int maxFps) {
        RendererTask task;
        Object object = this.mSync;
        synchronized (object) {
            task = this.mRendererTask;
        }
        if (task != null) {
            task.addSurface(id2, surface, maxFps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSurface(int id2) {
        RendererTask task;
        Object object = this.mSync;
        synchronized (object) {
            task = this.mRendererTask;
        }
        if (task != null) {
            task.removeSurface(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFrame() {
        RendererTask task;
        Object object = this.mSync;
        synchronized (object) {
            task = this.mRendererTask;
        }
        if (task != null) {
            task.removeRequest(1);
            task.offer(1);
        }
    }

    public int getCount() {
        return this.mRendererTask.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBitmap(Bitmap bitmap) {
        if (bitmap != null) {
            RendererTask task;
            Object object = this.mSync;
            synchronized (object) {
                task = this.mRendererTask;
            }
            if (task != null) {
                task.setBitmap(bitmap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mRendererTask != null ? this.mRendererTask.mVideoWidth : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mRendererTask != null ? this.mRendererTask.mVideoHeight : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMirror(int mirror) throws IllegalStateException {
        RendererTask task;
        Object object = this.mSync;
        synchronized (object) {
            task = this.mRendererTask;
        }
        if (task != null && task.mMirror != mirror) {
            task.offer(6, mirror);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMirror() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mRendererTask != null ? this.mRendererTask.mMirror : 0;
        }
    }

    private static class RendererTask
    extends EglTask {
        private final SparseArray<RendererTarget> mTargets = new SparseArray();
        private final StaticTextureSource mParent;
        private final long mIntervalsNs;
        private GLDrawer2D mDrawer;
        private int mVideoWidth;
        private int mVideoHeight;
        private GLTexture mImageSource;
        private int mMirror = 0;

        public RendererTask(StaticTextureSource parent, int width, int height, @Nullable Fraction fps) {
            super(GLUtils.getSupportedGLVersion(), null, 0);
            this.mParent = parent;
            this.mVideoWidth = width;
            this.mVideoHeight = height;
            float _fps = fps != null ? fps.asFloat() : 0.0f;
            this.mIntervalsNs = _fps <= 0.0f ? 100000000L : (long)(1.0E9f / _fps);
        }

        @Override
        @WorkerThread
        protected void onInit(int arg1, int arg2, Object obj) {
            super.onInit(arg1, arg2, obj);
        }

        @Override
        @WorkerThread
        protected void onStart() {
            this.mDrawer = GLDrawer2D.create(false, false);
            new Thread(this.mParent.mOnFrameTask, TAG).start();
        }

        @Override
        @WorkerThread
        protected void onStop() {
            this.makeCurrent();
            if (this.mDrawer != null) {
                this.mDrawer.release();
                this.mDrawer = null;
            }
            if (this.mImageSource != null) {
                this.mImageSource.release();
                this.mImageSource = null;
            }
            this.handleRemoveAll();
        }

        @Override
        protected boolean onError(Throwable e) {
            return false;
        }

        @Override
        @WorkerThread
        protected Object processRequest(int request, int arg1, int arg2, Object obj) {
            switch (request) {
                case 1: {
                    this.handleDraw();
                    break;
                }
                case 3: {
                    this.handleAddSurface(arg1, obj, arg2);
                    break;
                }
                case 4: {
                    this.handleRemoveSurface(arg1);
                    break;
                }
                case 6: {
                    this.handleMirror(arg1);
                    break;
                }
                case 7: {
                    this.handleSetBitmap((Bitmap)obj);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSurface(int id2, Object surface, int maxFps) {
            this.checkFinished();
            if (!GLUtils.isSupportedSurface(surface)) {
                throw new IllegalArgumentException("Surface should be one of Surface, SurfaceTexture or SurfaceHolder");
            }
            SparseArray<RendererTarget> sparseArray = this.mTargets;
            synchronized (sparseArray) {
                while (this.mTargets.get(id2) == null) {
                    if (this.offer(3, id2, maxFps, surface)) {
                        try {
                            this.mTargets.wait(1000L);
                        }
                        catch (InterruptedException e) {}
                        break;
                    }
                    try {
                        this.mTargets.wait(10L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSurface(int id2) {
            SparseArray<RendererTarget> sparseArray = this.mTargets;
            synchronized (sparseArray) {
                if (this.mTargets.get(id2) != null) {
                    while (true) {
                        if (this.offer(4, id2)) {
                            try {
                                this.mTargets.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                            break;
                        }
                        try {
                            this.mTargets.wait(10L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }

        public void setBitmap(@NonNull Bitmap bitmap) {
            this.offer(7, bitmap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getCount() {
            SparseArray<RendererTarget> sparseArray = this.mTargets;
            synchronized (sparseArray) {
                return this.mTargets.size();
            }
        }

        private void checkFinished() {
            if (this.isFinished()) {
                throw new RuntimeException("already finished");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private void handleDraw() {
            this.makeCurrent();
            if (this.mImageSource != null) {
                int texId = this.mImageSource.getTexId();
                SparseArray<RendererTarget> sparseArray = this.mTargets;
                synchronized (sparseArray) {
                    int n = this.mTargets.size();
                    for (int i = n - 1; i >= 0; --i) {
                        RendererTarget target = (RendererTarget)this.mTargets.valueAt(i);
                        if (target == null || !target.canDraw()) continue;
                        try {
                            target.draw(this.mDrawer, 33984, texId, null);
                            GLUtils.checkGlError("handleDraw");
                            continue;
                        }
                        catch (Exception e) {
                            this.mTargets.removeAt(i);
                            target.release();
                        }
                    }
                }
            } else {
                Log.w((String)TAG, (String)"mImageSource is not ready");
            }
            GLES20.glClear((int)16384);
            GLES20.glFlush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private void handleAddSurface(int id2, Object surface, int maxFps) {
            this.checkTarget();
            SparseArray<RendererTarget> sparseArray = this.mTargets;
            synchronized (sparseArray) {
                RendererTarget target = (RendererTarget)this.mTargets.get(id2);
                if (target == null) {
                    try {
                        target = this.createRendererTarget(id2, this.getEgl(), surface, maxFps);
                        target.setMirror(this.mMirror);
                        this.mTargets.append(id2, (Object)target);
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (String)("invalid surface: surface=" + surface), (Throwable)e);
                    }
                } else {
                    Log.w((String)TAG, (String)("surface is already added: id=" + id2));
                }
                this.mTargets.notifyAll();
            }
        }

        private RendererTarget createRendererTarget(int id2, @NonNull EGLBase egl, Object surface, float maxFps) {
            return RendererTarget.newInstance(egl, surface, maxFps > 1000.0f ? maxFps / 1000.0f : maxFps);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private void handleRemoveSurface(int id2) {
            SparseArray<RendererTarget> sparseArray = this.mTargets;
            synchronized (sparseArray) {
                RendererTarget target = (RendererTarget)this.mTargets.get(id2);
                if (target != null) {
                    this.mTargets.remove(id2);
                    target.release();
                }
                this.checkTarget();
                this.mTargets.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private void handleRemoveAll() {
            SparseArray<RendererTarget> sparseArray = this.mTargets;
            synchronized (sparseArray) {
                int n = this.mTargets.size();
                for (int i = 0; i < n; ++i) {
                    RendererTarget target = (RendererTarget)this.mTargets.valueAt(i);
                    if (target == null) continue;
                    this.makeCurrent();
                    target.release();
                }
                this.mTargets.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private void checkTarget() {
            SparseArray<RendererTarget> sparseArray = this.mTargets;
            synchronized (sparseArray) {
                int n = this.mTargets.size();
                for (int i = 0; i < n; ++i) {
                    RendererTarget target = (RendererTarget)this.mTargets.valueAt(i);
                    if (target == null || target.isValid()) continue;
                    int id2 = this.mTargets.keyAt(i);
                    ((RendererTarget)this.mTargets.valueAt(i)).release();
                    this.mTargets.remove(id2);
                }
            }
        }

        @WorkerThread
        private void handleMirror(int mirror) {
            this.mMirror = mirror;
            int n = this.mTargets.size();
            for (int i = 0; i < n; ++i) {
                RendererTarget target = (RendererTarget)this.mTargets.valueAt(i);
                if (target == null) continue;
                GLUtils.setMirror(target.getMvpMatrix(), mirror);
            }
        }

        @WorkerThread
        private void handleSetBitmap(Bitmap bitmap) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            if (this.mImageSource == null) {
                this.mImageSource = GLTexture.newInstance(33984, width, height);
                GLUtils.checkGlError("handleSetBitmap");
            }
            this.mImageSource.loadBitmap(bitmap);
            this.mVideoWidth = width;
            this.mVideoHeight = height;
        }
    }
}

