/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLManager;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.gl.RendererTarget;
import com.serenegiant.glutils.IMirror;
import com.serenegiant.math.Fraction;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class GLSurfaceWriter
implements IMirror {
    private static final boolean DEBUG = false;
    private static final String TAG = GLSurfaceWriter.class.getSimpleName();
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final GLManager mManager;
    private final boolean mOwnManager;
    private volatile boolean mReleased = false;
    @Nullable
    private GLDrawer2D mDrawer;
    @Nullable
    private RendererTarget mRendererTarget;
    private int mMirror = 0;
    private int cnt;

    public GLSurfaceWriter(@NonNull GLManager manager, boolean useSharedContext) {
        this.mOwnManager = useSharedContext;
        this.mManager = useSharedContext ? manager.createShared(null) : manager;
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public final void release() {
        if (!this.mReleased) {
            this.mReleased = true;
            this.internalRelease();
        }
    }

    protected void internalRelease() {
        if (this.mManager.isValid()) {
            this.mManager.runOnGLThread(() -> {
                this.releaseTargetOnGL();
                if (this.mOwnManager) {
                    this.mManager.release();
                }
            });
        }
    }

    public boolean isValid() {
        return !this.mReleased && this.mManager.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSurface() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mRendererTarget != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getId() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mRendererTarget != null ? this.mRendererTarget.getId() : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMirror(int mirror) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mMirror != mirror) {
                this.mMirror = mirror;
                this.mManager.runOnGLThread(() -> {
                    if (this.mRendererTarget != null) {
                        this.mRendererTarget.setMirror(IMirror.flipVertical(mirror));
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMirror() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mMirror;
        }
    }

    public void setSurface(@Nullable Object surface) throws IllegalStateException, IllegalArgumentException {
        this.setSurface(surface, null);
    }

    public void setSurface(@Nullable Object surface, @Nullable Fraction maxFps) throws IllegalStateException, IllegalArgumentException {
        if (!this.isValid()) {
            throw new IllegalStateException("already released?");
        }
        if (surface != null && !GLUtils.isSupportedSurface(surface)) {
            throw new IllegalArgumentException("Unsupported surface type!," + surface);
        }
        this.mManager.runOnGLThread(() -> this.createTargetOnGL(surface, maxFps));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onFrameAvailable(boolean isOES, int texId, @NonNull @Size(min=16L) float[] texMatrix) {
        if (!this.isValid()) return;
        if (this.mManager.isGLThread()) {
            this.renderTargetOnGL(isOES, texId, texMatrix);
            return;
        } else {
            Semaphore sem = new Semaphore(0);
            this.mManager.runOnGLThread(() -> {
                this.renderTargetOnGL(isOES, texId, texMatrix);
                sem.release();
            });
            try {
                if (sem.tryAcquire(50L, TimeUnit.MILLISECONDS)) return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderTargetOnGL(boolean isOES, int texId, @NonNull @Size(min=16L) float[] texMatrix) {
        RendererTarget target;
        GLDrawer2D drawer;
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDrawer == null || isOES != this.mDrawer.isOES()) {
                if (this.mDrawer != null) {
                    this.mDrawer.release();
                }
                this.mDrawer = GLDrawer2D.create(this.mManager.isGLES3(), isOES);
            }
            drawer = this.mDrawer;
            target = this.mRendererTarget;
        }
        if (target != null && target.canDraw()) {
            target.draw(drawer, 33984, texId, texMatrix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void createTargetOnGL(@Nullable Object surface, @Nullable Fraction maxFps) {
        Object object = this.mSync;
        synchronized (object) {
            Object object2 = this.mSync;
            synchronized (object2) {
                if (this.mRendererTarget != null && this.mRendererTarget.getSurface() != surface) {
                    this.mRendererTarget.release();
                    this.mRendererTarget = null;
                }
                if (this.mRendererTarget == null && surface != null) {
                    this.mRendererTarget = RendererTarget.newInstance(this.mManager.getEgl(), surface, maxFps != null ? maxFps.asFloat() : 0.0f);
                }
                if (this.mRendererTarget != null) {
                    this.mRendererTarget.setMirror(IMirror.flipVertical(this.mMirror));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void releaseTargetOnGL() {
        RendererTarget target;
        GLDrawer2D drawer;
        Object object = this.mSync;
        synchronized (object) {
            drawer = this.mDrawer;
            this.mDrawer = null;
            target = this.mRendererTarget;
            this.mRendererTarget = null;
        }
        if ((drawer != null || target != null) && this.mManager.isValid()) {
            try {
                this.mManager.runOnGLThread(new Runnable(){

                    @Override
                    @WorkerThread
                    public void run() {
                        if (drawer != null) {
                            drawer.release();
                        }
                        if (target != null) {
                            target.release();
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

