/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glpipeline;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.gl.EffectDrawer2D;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLManager;
import com.serenegiant.gl.GLSurface;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.gl.RendererTarget;
import com.serenegiant.glpipeline.GLSurfacePipeline;
import com.serenegiant.glpipeline.ProxyPipeline;
import com.serenegiant.glutils.IMirror;
import com.serenegiant.math.Fraction;

public class EffectPipeline
extends ProxyPipeline
implements GLSurfacePipeline,
IMirror {
    private static final boolean DEBUG = false;
    private static final String TAG = EffectPipeline.class.getSimpleName();
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final GLManager mManager;
    @Nullable
    private EffectDrawer2D mDrawer;
    private int mEffect = 0;
    @Nullable
    private RendererTarget mRendererTarget;
    private volatile boolean mEffectOnly;
    @Nullable
    private GLSurface work;
    private int mMirror = 0;
    private int cnt;
    final EffectDrawer2D.EffectListener mEffectListener = new EffectDrawer2D.EffectListener(){

        @Override
        @WorkerThread
        public boolean onChangeEffect(int effect, @NonNull GLDrawer2D drawer) {
            return EffectPipeline.this.onChangeEffect(effect, drawer);
        }
    };

    public EffectPipeline(@NonNull GLManager manager) throws IllegalStateException, IllegalArgumentException {
        this(manager, null, null);
    }

    public EffectPipeline(@NonNull GLManager manager, final @Nullable Object surface, final @Nullable Fraction maxFps) throws IllegalStateException, IllegalArgumentException {
        if (surface != null && !GLUtils.isSupportedSurface(surface)) {
            throw new IllegalArgumentException("Unsupported surface type!," + surface);
        }
        this.mManager = manager;
        manager.runOnGLThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                EffectPipeline.this.createTargetOnGL(surface, maxFps);
            }
        });
    }

    @Override
    protected void internalRelease() {
        if (this.isValid()) {
            this.releaseTarget();
        }
        super.internalRelease();
    }

    @Override
    public void setSurface(@Nullable Object surface) throws IllegalStateException, IllegalArgumentException {
        this.setSurface(surface, null);
    }

    @Override
    public void setSurface(final @Nullable Object surface, final @Nullable Fraction maxFps) throws IllegalStateException, IllegalArgumentException {
        if (!this.isValid()) {
            throw new IllegalStateException("already released?");
        }
        if (surface != null && !GLUtils.isSupportedSurface(surface)) {
            throw new IllegalArgumentException("Unsupported surface type!," + surface);
        }
        this.mManager.runOnGLThread(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                EffectPipeline.this.createTargetOnGL(surface, maxFps);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSurface() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mRendererTarget != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getId() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mRendererTarget != null ? this.mRendererTarget.getId() : 0;
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.mManager.isValid();
    }

    public boolean isEffectOnly() {
        return this.mEffectOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMirror(int mirror) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mMirror != mirror) {
                this.mMirror = mirror;
                this.mManager.runOnGLThread(() -> {
                    if (this.mRendererTarget != null) {
                        this.mRendererTarget.setMirror(IMirror.flipVertical(mirror));
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMirror() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mMirror;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void onFrameAvailable(boolean isOES, int texId, @NonNull @Size(min=16L) float[] texMatrix) {
        if (this.isValid()) {
            RendererTarget target;
            if (this.mDrawer == null || isOES != this.mDrawer.isOES()) {
                if (this.mDrawer != null) {
                    this.mDrawer.release();
                }
                this.mDrawer = new EffectDrawer2D(this.mManager.isGLES3(), isOES, this.mEffectListener);
                this.mDrawer.setEffect(this.mEffect);
            }
            EffectDrawer2D drawer = this.mDrawer;
            Object object = this.mSync;
            synchronized (object) {
                target = this.mRendererTarget;
            }
            if (target != null && target.canDraw()) {
                target.draw(drawer, 33984, texId, texMatrix);
            }
            if (this.mEffectOnly && this.work != null) {
                super.onFrameAvailable(this.work.isOES(), this.work.getTexId(), this.work.getTexMatrix());
            } else {
                super.onFrameAvailable(isOES, texId, texMatrix);
            }
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isValid()) {
            this.mManager.runOnGLThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @WorkerThread
                public void run() {
                    EffectDrawer2D drawer = EffectPipeline.this.mDrawer;
                    EffectPipeline.this.mDrawer = null;
                    if (drawer != null) {
                        Object object = EffectPipeline.this.mSync;
                        synchronized (object) {
                            EffectPipeline.this.mEffect = drawer.getCurrentEffect();
                        }
                        drawer.release();
                    }
                }
            });
        }
    }

    public void resetEffect() throws IllegalStateException {
        if (!this.isValid()) {
            throw new IllegalStateException("already released!");
        }
        this.mManager.runOnGLThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @WorkerThread
            public void run() {
                if (EffectPipeline.this.mDrawer != null) {
                    EffectPipeline.this.mDrawer.resetEffect();
                    Object object = EffectPipeline.this.mSync;
                    synchronized (object) {
                        EffectPipeline.this.mEffect = EffectPipeline.this.mDrawer.getCurrentEffect();
                    }
                }
            }
        });
    }

    public void setEffect(final int effect) throws IllegalStateException {
        if (!this.isValid()) {
            throw new IllegalStateException("already released!");
        }
        this.mManager.runOnGLThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @WorkerThread
            public void run() {
                if (EffectPipeline.this.mDrawer != null) {
                    EffectPipeline.this.mDrawer.setEffect(effect);
                    Object object = EffectPipeline.this.mSync;
                    synchronized (object) {
                        EffectPipeline.this.mEffect = EffectPipeline.this.mDrawer.getCurrentEffect();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentEffect() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mEffect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void createTargetOnGL(@Nullable Object surface, @Nullable Fraction maxFps) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mRendererTarget == null || this.mRendererTarget.getSurface() != surface) {
                if (this.mRendererTarget != null) {
                    this.mRendererTarget.release();
                    this.mRendererTarget = null;
                }
                if (this.work != null) {
                    this.work.release();
                    this.work = null;
                }
                if (GLUtils.isSupportedSurface(surface)) {
                    this.mRendererTarget = RendererTarget.newInstance(this.mManager.getEgl(), surface, maxFps != null ? maxFps.asFloat() : 0.0f);
                    this.mEffectOnly = false;
                } else {
                    this.work = GLSurface.newInstance(this.mManager.isGLES3(), this.getWidth(), this.getHeight());
                    this.mRendererTarget = RendererTarget.newInstance(this.mManager.getEgl(), this.work, maxFps != null ? maxFps.asFloat() : 0.0f);
                    this.mEffectOnly = true;
                }
                this.mRendererTarget.setMirror(IMirror.flipVertical(this.mMirror));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseTarget() {
        GLSurface w;
        RendererTarget target;
        final EffectDrawer2D drawer = this.mDrawer;
        this.mDrawer = null;
        Object object = this.mSync;
        synchronized (object) {
            target = this.mRendererTarget;
            this.mRendererTarget = null;
            w = this.work;
            this.work = null;
        }
        if ((drawer != null || target != null) && this.mManager.isValid()) {
            try {
                this.mManager.runOnGLThread(new Runnable(){

                    @Override
                    @WorkerThread
                    public void run() {
                        if (drawer != null) {
                            drawer.release();
                        }
                        if (target != null) {
                            target.release();
                        }
                        if (w != null) {
                            w.release();
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @WorkerThread
    protected boolean onChangeEffect(int effect, @NonNull GLDrawer2D drawer) {
        return false;
    }
}

