/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.camera;

import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.MediaCodec;
import android.text.TextUtils;
import android.util.Log;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.serenegiant.camera.CameraConst;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

@RequiresApi(api=21)
public class Camera2Utils
implements CameraConst {
    private static final boolean DEBUG = false;
    private static final String TAG = Camera2Utils.class.getSimpleName();

    public static CameraConst.CameraInfo findCamera(@NonNull CameraManager manager, int preferedFace) throws CameraAccessException {
        CameraConst.CameraInfo info = null;
        String[] cameraIds = manager.getCameraIdList();
        if (cameraIds != null && cameraIds.length > 0) {
            int face = preferedFace == 0 ? 1 : 0;
            boolean triedAllCameras = false;
            int targetFace = face;
            String cameraId = null;
            int orientation = 0;
            block0: while (!triedAllCameras) {
                for (String id2 : cameraIds) {
                    CameraCharacteristics characteristics = manager.getCameraCharacteristics(id2);
                    if ((Integer)characteristics.get(CameraCharacteristics.LENS_FACING) != targetFace) continue;
                    StreamConfigurationMap map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                    cameraId = id2;
                    orientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                    break block0;
                }
                if (cameraId == null && targetFace == face) {
                    targetFace = face == 1 ? 0 : 1;
                    continue;
                }
                triedAllCameras = true;
            }
            if (!TextUtils.isEmpty(cameraId)) {
                info = new CameraConst.CameraInfo(cameraId, face, orientation, 640, 480);
            }
        }
        return info;
    }

    @Nullable
    public static CameraConst.CameraInfo findCamera(@NonNull CameraManager manager, int width, int height, int preferedFace, int degrees) throws CameraAccessException {
        String cameraId = null;
        Size previewSize = null;
        int targetFace = -1;
        int orientation = 0;
        String[] cameraIds = manager.getCameraIdList();
        if (cameraIds != null && cameraIds.length > 0) {
            int face = preferedFace == 0 ? 1 : 0;
            boolean triedAllCameras = false;
            targetFace = face;
            block0: while (!triedAllCameras) {
                for (String id2 : cameraIds) {
                    CameraCharacteristics characteristics = manager.getCameraCharacteristics(id2);
                    if ((Integer)characteristics.get(CameraCharacteristics.LENS_FACING) != targetFace) continue;
                    StreamConfigurationMap map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                    previewSize = Camera2Utils.chooseOptimalSize(characteristics, map, width, height, degrees);
                    orientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                    cameraId = id2;
                    break block0;
                }
                if (cameraId == null && targetFace == face) {
                    targetFace = face == 1 ? 0 : 1;
                    continue;
                }
                triedAllCameras = true;
            }
        }
        if (!TextUtils.isEmpty(cameraId) && previewSize != null) {
            return new CameraConst.CameraInfo(cameraId, targetFace, orientation, previewSize.getWidth(), previewSize.getHeight());
        }
        return null;
    }

    public static CameraConst.CameraInfo chooseOptimalSize(@NonNull CameraManager manager, String cameraId, int targetFace, int width, int height, int degrees) throws CameraAccessException {
        CameraCharacteristics characteristics = manager.getCameraCharacteristics(cameraId);
        StreamConfigurationMap map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Size previewSize = Camera2Utils.chooseOptimalSize(characteristics, map, width, height, degrees);
        int orientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        if (!TextUtils.isEmpty((CharSequence)cameraId) && previewSize != null) {
            return new CameraConst.CameraInfo(cameraId, targetFace, orientation, previewSize.getWidth(), previewSize.getHeight());
        }
        return null;
    }

    public static Size chooseOptimalSize(CameraCharacteristics characteristics, StreamConfigurationMap map, int _width, int _height, int degrees) {
        double r;
        double a;
        Rect activeArraySize = (Rect)characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        Size[] sizes = map.getOutputSizes(MediaCodec.class);
        Size ppsfv = Collections.max(Arrays.asList(sizes), new CompareSizesByArea());
        if (_width <= 0 || _height <= 0) {
            Log.d((String)TAG, (String)("chooseOptimalSize:select" + ppsfv));
            return ppsfv;
        }
        int width = Math.max(_width, _height);
        int height = Math.min(_width, _height);
        double aspect = width > 0 && height > 0 ? (double)width / (double)height : (double)ppsfv.getWidth() / (double)ppsfv.getHeight();
        long max_areas = width > 0 && height > 0 ? (long)width * (long)height : (long)ppsfv.getWidth() * (long)ppsfv.getHeight();
        double selectedDelta = Double.MAX_VALUE;
        Size selectedSize = null;
        for (Size sz : sizes = map.getOutputSizes(SurfaceTexture.class)) {
            if (sz.getWidth() != width || sz.getHeight() != height) continue;
            selectedSize = sz;
            Log.v((String)TAG, (String)("chooseOptimalSize:found(" + selectedSize + ")"));
            return selectedSize;
        }
        ArrayList<Size> possible = new ArrayList<Size>();
        if (selectedSize == null) {
            for (Size sz : sizes) {
                a = (double)sz.getWidth() / (double)sz.getHeight();
                long areas = (long)sz.getWidth() * (long)sz.getHeight();
                r = Math.abs(a - aspect) / aspect;
                if (r < 0.2 && areas <= max_areas) {
                    possible.add(sz);
                }
                if (sz.getWidth() != width || !(r < selectedDelta)) continue;
                selectedSize = sz;
                selectedDelta = r;
            }
        }
        if (selectedSize == null || selectedDelta >= 0.05) {
            selectedDelta = Double.MAX_VALUE;
            selectedSize = null;
            for (Size sz : sizes) {
                if (sz.getWidth() != width || !((r = Math.abs((a = (double)sz.getWidth() / (double)sz.getHeight()) - aspect) / aspect) < selectedDelta)) continue;
                selectedSize = sz;
                selectedDelta = r;
            }
        }
        if (selectedSize != null && selectedDelta < 0.05) {
            Log.d((String)TAG, (String)String.format("chooseOptimalSize:select(%dx%d), request(%d,%d)", selectedSize.getWidth(), selectedSize.getHeight(), width, height));
            return selectedSize;
        }
        try {
            selectedSize = Collections.max(possible, new CompareSizesByArea());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (selectedSize == null) {
            selectedSize = ppsfv;
        }
        Log.d((String)TAG, (String)("chooseOptimalSize:select(" + selectedSize + ")"));
        return selectedSize;
    }

    protected static class CompareSizesByArea
    implements Comparator<Size> {
        protected CompareSizesByArea() {
        }

        @Override
        public int compare(Size lhs, Size rhs) {
            return Long.signum((long)lhs.getWidth() * (long)lhs.getHeight() - (long)rhs.getWidth() * (long)rhs.getHeight());
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestTemplate {
    }
}

