/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.serenegiant.camera.IFrameCallback;
import com.serenegiant.camera.RawFrameType;
import com.serenegiant.usb.uvc.IPipeline;

@Keep
public class FrameCallbackPipeline
extends IPipeline {
    private static final String TAG = FrameCallbackPipeline.class.getSimpleName();
    protected final Object mSync;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameCallbackPipeline() {
        super(300);
        Object object = this.mSync = new Object();
        synchronized (object) {
            this.mNativePtr = this.nativeCreateDefault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameCallbackPipeline(int sanitaryCheck) {
        super(300);
        Object object = this.mSync = new Object();
        synchronized (object) {
            this.mNativePtr = this.nativeCreateSanitary(sanitaryCheck);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameCallbackPipeline(@IntRange(from=1L) int defaultFrameSize, int sanitaryCheck) {
        super(300);
        Object object = this.mSync = new Object();
        synchronized (object) {
            this.mNativePtr = this.nativeCreate(defaultFrameSize, sanitaryCheck);
        }
    }

    @Override
    public int getState() {
        return this.nativeGetState(this.mNativePtr);
    }

    @Override
    public void setPipeline(@Nullable IPipeline next_pipeline) {
        if (this.getState() < 20) {
            throw new IllegalStateException("already released");
        }
        this.nativeSetPipeline(this.mNativePtr, next_pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.mSync;
        synchronized (object) {
            int result = FrameCallbackPipeline.nativeStart(this.mNativePtr);
            if (result != 0) {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.mSync;
        synchronized (object) {
            int result = FrameCallbackPipeline.nativeStop(this.mNativePtr);
            if (result != 0) {
                Log.w((String)TAG, (String)("nativeStop returned " + result));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.mSync;
        synchronized (object) {
            this.nativeDestroy(this.mNativePtr);
            this.mNativePtr = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrameCallback(@Nullable IFrameCallback callback, RawFrameType rawFrameType) throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.getState() <= 10) {
                throw new IllegalStateException("already released");
            }
            FrameCallbackPipeline.nativeSetFrameCallback(this.mNativePtr, callback, rawFrameType.getValue());
        }
    }

    private final native long nativeCreateDefault();

    private final native long nativeCreateSanitary(int var1);

    private final native long nativeCreate(int var1, int var2);

    private final native void nativeDestroy(long var1);

    private final native int nativeGetState(long var1);

    private final native int nativeSetPipeline(long var1, IPipeline var3);

    private static final native int nativeStart(long var0);

    private static final native int nativeStop(long var0);

    private static final native int nativeSetFrameCallback(long var0, IFrameCallback var2, int var3);
}

