/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import android.content.Context;
import android.content.res.AssetManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.IntRange;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.camera.IFrameCallback;
import com.serenegiant.media.Encoder;
import com.serenegiant.usb.uvc.IPipeline;
import java.lang.ref.WeakReference;

@Deprecated
@Keep
public class CapturePipeline
extends IPipeline {
    private static final boolean DEBUG = false;
    private static final String TAG = CapturePipeline.class.getSimpleName();
    private final WeakReference<Context> mWeakContext;
    protected final AssetManager mAssetManager;

    public CapturePipeline(@NonNull Context context) {
        super(700);
        this.mAssetManager = context.getAssets();
        this.mWeakContext = new WeakReference<Context>(context);
        this.mNativePtr = this.nativeCreate(this.mAssetManager);
    }

    @Override
    public int getState() {
        return this.nativeGetState(this.mNativePtr);
    }

    @Override
    public void setPipeline(@Nullable IPipeline nextPipeline) {
        if (this.getState() < 20) {
            throw new IllegalStateException("already released");
        }
        this.nativeSetPipeline(this.mNativePtr, nextPipeline);
    }

    @Override
    public synchronized void start() {
        int result = CapturePipeline.nativeStart(this.mNativePtr);
        if (result != 0) {
            throw new IllegalStateException(Integer.toString(result));
        }
    }

    @Override
    public synchronized void stop() {
        int result = CapturePipeline.nativeStop(this.mNativePtr);
        if (result != 0) {
            Log.w((String)TAG, (String)("nativeStop returned " + result));
        }
    }

    @Override
    public void release() {
        this.nativeDestroy(this.mNativePtr);
        this.mNativePtr = 0L;
    }

    public void setVideoSize(int width, int height) {
        CapturePipeline.nativeSetVideoSize(this.mNativePtr, width, height);
    }

    public void takePicture(@Nullable String outputPath, int width, int height, @IntRange(from=1L, to=99L) int compress, @Nullable IFrameCallback callback) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)outputPath) && callback == null) {
            throw new IllegalArgumentException("at least one of output path and callback should be specified.");
        }
        if (this.mNativePtr != 0L) {
            CapturePipeline.nativeTakePicture(this.mNativePtr, outputPath, width, height, compress, callback);
        }
    }

    public void setCaptureSurface(@Nullable Surface surface, int captureFormat) {
        if (this.mNativePtr != 0L) {
            CapturePipeline.nativeSetCaptureDisplay(this.mNativePtr, surface, captureFormat);
        }
    }

    public void setEncoder(@Nullable Encoder encoder) {
        if (this.mNativePtr != 0L) {
            CapturePipeline.nativeSetEncoder(this.mNativePtr, encoder);
        }
    }

    protected Context getContext() {
        return (Context)this.mWeakContext.get();
    }

    private final native long nativeCreate(AssetManager var1);

    private final native void nativeDestroy(long var1);

    private final native int nativeGetState(long var1);

    private final native int nativeSetPipeline(long var1, IPipeline var3);

    private static final native int nativeStart(long var0);

    private static final native int nativeStop(long var0);

    private static final native int nativeSetVideoSize(long var0, int var2, int var3);

    private static final native int nativeTakePicture(long var0, @Nullable String var2, int var3, int var4, int var5, @Nullable IFrameCallback var6);

    private static final native int nativeSetCaptureDisplay(long var0, Surface var2, int var3);

    private static final native int nativeSetEncoder(long var0, Encoder var2);
}

