/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.camera;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CameraState {
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_INITIALIZING = 1;
    public static final int STATE_INITIALIZED = 16;
    public static final int STATE_CONNECTING = 256;
    public static final int STATE_CONNECTED = 512;
    public static final int STATE_STREAMING = 1024;
    public static final int STATE_RECORDING = 2048;
    public static final int STATE_TIMELAPSE = 4096;
    public static final int STATE_MASK_CONNECTING = 272;
    public static final int STATE_MASK_CONNECTED = 528;
    public static final int STATE_MASK_STREAM = 1552;
    public static final int STATE_MASK_RECORDING = 2576;
    public static final int STATE_MASK_TIMELAPSE = 4624;
    public static final int STATE_MASK_CAPTURING = 6672;
    private final ReentrantReadWriteLock mSensorLock = new ReentrantReadWriteLock();
    private final Lock mReadLock = this.mSensorLock.readLock();
    private final Lock mWriteLock = this.mSensorLock.writeLock();
    private int mState = 0;

    public CameraState() {
        this.setState(1);
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public void release() {
        this.setState(0);
    }

    public void readLock() {
        this.mReadLock.lock();
    }

    public boolean tryReadLock(long timeoutMs) throws InterruptedException {
        return this.mReadLock.tryLock(timeoutMs, TimeUnit.MILLISECONDS);
    }

    public void readUnlock() {
        this.mReadLock.unlock();
    }

    public void writeLock() {
        this.mWriteLock.lock();
    }

    public boolean tryWriteLock(long timeoutMs) throws InterruptedException {
        return this.mWriteLock.tryLock(timeoutMs, TimeUnit.MILLISECONDS);
    }

    public void writeUnlock() {
        this.mWriteLock.unlock();
    }

    public boolean isInitialized() {
        this.mReadLock.lock();
        try {
            boolean bl = (this.mState & 0x10) == 16;
            return bl;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public boolean isConnected() {
        this.mReadLock.lock();
        try {
            boolean bl = (this.mState & 0x210) == 528;
            return bl;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public boolean isStreaming() {
        this.mReadLock.lock();
        try {
            boolean bl = (this.mState & 0x610) == 1552;
            return bl;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public boolean isRecording() {
        this.mReadLock.lock();
        try {
            boolean bl = (this.mState & 0xA10) == 2576;
            return bl;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public boolean isTimeLapse() {
        this.mReadLock.lock();
        try {
            boolean bl = (this.mState & 0x1210) == 4624;
            return bl;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    public boolean isCapturing() {
        this.mReadLock.lock();
        try {
            int state = this.mState & 0x1A10;
            boolean bl = state != 0 && state != 528;
            return bl;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    protected int state() {
        this.mReadLock.lock();
        try {
            int n = this.mState;
            return n;
        }
        finally {
            this.mReadLock.unlock();
        }
    }

    protected boolean setState(int newState) {
        boolean changed;
        this.mWriteLock.lock();
        try {
            changed = this.mState != newState;
            this.mState = newState;
        }
        finally {
            this.mWriteLock.unlock();
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setState(int newState, int mask) {
        boolean changed;
        this.mWriteLock.lock();
        try {
            int state = this.mState & mask;
            boolean bl = changed = state != newState;
            if (changed) {
                this.mState = state | newState;
            }
        }
        finally {
            this.mWriteLock.unlock();
        }
        return changed;
    }
}

